#INCLUDE ALLDEFS.H
#Define MAX_PARAMS 254
#Define MAX_ROWS 180
#Define WIZARD_CLOSING	.T.

* jvf 9/1/99
#Define VIEW_NAME_EXTENSION_LOC	"v_"
* New local table name for wiz report if was dropped
#Define DROPPED_TABLE_STATUS_LOC "Table Dropped"
#Define BULK_INSERT_FILENAME "BulkIns.out"
#Define SQL_SERVER_EMPTY_DATE_Y2K {^1900-01-01}
#Define SQL_SERVER_EMPTY_DATE_CHAR "01/01/1900"
* Use tilde rather than comma in case commas in char fields
#Define BULK_INSERT_FIELD_DELIMITER	~

*******************************************
Define CLASS UpsizeEngine AS WizEngineAll
	*******************************************

	*ODBC-related properties
	MasterConnHand=0
	ConnectString=""
	DataSourceName=""
	ServerType=""
	CurrentServerType=""
	ServerVer=0
	UserConnection=""
	ViewConnection=""
	UserName=""
	Userid=0
	MyError=0
	FetchMemo=.F.

	*Navigation variables
	DeviceRecalc=.T.
	AnalyzeTablesRecalc=.T.
	AnalyzeFieldsRecalc=.T.
	AnalyzeIndexesRecalc=.T.
	ChooseTargetDBRecalc=.T.
	TableCboRecalc=.T.
	GetRiInfoRecalc=.T.
	EligibleRelsRecalc=.T.
	TableChosen=.F.
	DataSourceChosen=.F.
	DSNChange=.F.
	NoDataSourceRightNow=.F.
	GetConnDefsRecalc=.T.
	DeviceLogChosen=.F.
	DeviceDBChosen=.F.
	SourceDBChosen=.F.
	GridFilled=.F.

	*Device properties
	DeviceNumbersFree=0
	DeviceDBName=""
	DeviceDBPName=""
	DeviceDBSize=0
	DeviceDBNumber=0
	DeviceDBNew=.F.
	DeviceLogName=""
	DeviceLogPName=""
	DeviceLogSize=0
	DeviceLogNumber=0
	DeviceLogNew=.F.
	MasterPath=""
	NewDeviceCount=0
	DefaultFreeSpace=0
	DeviceDBInDefa=.F.		&&used to in Device class, DeviceThingOK method
	DeviceLogInDefa=.F.
	DBonDefault=.F.

	*Server Database properties
	CreateNewDB=.F.
	ServerFreeSpace=-5
	ServerDBName=""
	ServerDBSize=0
	ServerLogSize=0

	*Oracle Wizard properties

	*Tables Selection Step properties
	TBFoxTableSize = 0
	TBFoxIndexSize = 0

	*Tablespaces Step properties
	TSNewTableTS = .F.
	TSNewIndexTS = .F.
	TSTableTSName = ""
	TSIndexTSName = ""
	TSDefaultTSName = ""
	TSPermTablespaces =	.T.
	TSNew = .F.
	TSDone = .F.

	*Tablespace File Step properties
	TSFTableFileName = ""
	TSFIndexFileName = ""
	TSFTableFileSize = 0
	TSFIndexFileSize = 0
	TSFDone = .F.

	*Cluster Table Step properties
	CLClustersDone = .F.
	CLTablesDone = .F.
	CLKeysDone = .F.

	*Export properties
	SourceDB=""
	ExportIndexes=.T.
	ExportValidation=.T.
	ExportRelations=.T.
	ExportDRI=.F.
	ExportStructureOnly=.F.
	ExportDefaults=.T.
	ExportTimeStamp=.T.
	ExportTableToView=.F.
	ExportViewToRmt=.T.
	ExportSavePwd=.F.
	Overwrite=.F.					&&If .T., existing tables are overwritten
	NullOverride = 1
	ExportClustered=.F.				&& Default to Primary Keys not being Clustered
	ViewNameExtension=VIEW_NAME_EXTENSION_LOC
	ViewPrefixOrSuffix=1
	DropLocalTables=.F.

	*Names of tables created and aliases
	EnumFieldsTbl=""
	MappingTable=""					&& Same as EnumfieldsTbl, used again
	EnumTablesTbl=""
	EnumClustersTbl=""				&& Cluster table name
	EnumIndexesTbl=""
	DeviceTable=""					&& Same table, used twice
	DeviceTableAlias=""				&& Same as DeviceTable, used again by the log device screen
	ViewsTbl=""
	EnumRelsTbl=""
	ScriptTbl=""					&& Basically a big memo field for holding generated sql
	ErrTbl=""
	OraNames=""						&& Just a cursor of Oracle index names

	*Action properties
	DoUpsize=.T.
	DoScripts=.F.
	DoReport=.T.
	* jvf 08/13/99 Now can choose for all tables
	TimeStampAll=0					&& add timestamp column to all tables
	IdentityAll=0					&& add identity column to all tables

	*Permissions properties
	Perm_Device		=	.T.
	Perm_Table		=	.T.
	Perm_Database	=	.T.
	Perm_Default	=	.T.
	Perm_Sproc		=	.T.
	Perm_Index		=	.T.
	Perm_Trigger	=	.T.
	Perm_AltTS		=	.T.
	Perm_CreaTS		=	.T.
	Perm_Cluster	=	.T.
	Perm_UnlimTS	=	.T.

	*Arrays of server datatypes, one for each FoxPro type
	Dimension C[1]
	Dimension N[1]
	Dimension B[1]
	Dimension L[1]
	Dimension M[1]
	Dimension Y[1]
	Dimension D[1]
	Dimension T[1]
	Dimension P[1]
	Dimension G[1]
	Dimension F[1]
	Dimension I[1]

	*Other
	UserInput=""			&& Inputbox always puts user input here
	ZeroDefaultCreated=.F.	&& Flag set true after zero default has been created
	ScriptTblCreated=.F.
	ThermCreated=.F.
	ProcessingOutput=.F.	&& Set to .T. after user clicks Finish button
	OldRow=1				&& Used by type mapping grid to see if row changed
	OldType=""				&& Used by type mapping grid in case user wants to undo change
	NormalShutdown=.F.		&& Flag used to prevent analysis files from getting nuked
	DataErrors=.F.
	NewProjName=""
	PwdInDef=.F.			&& See comment in page9 activate method
	RealClick=.T.			&& Flag for page9
	SaveErrors=.T.			&& Save error tables, set in BuildReport method
	ZDUsed=.F.				&& So that sql for zero default included (if appropriate) in sql script
	FiltCond=""				&& Used on type mapping page
	NewDir=""				&& Directory created to store tables etc. the upsizing wizard creates
	CreatedNewDir=.F.
	KeepNewDir=.F.
	SQLServer=.F.			&& True if we're connected to SQL Server
	TimeStampName=""		&& Name used for all timestamp fields (if any) that are added
	IdentityName = ""		&& Name used for all identity fields (if any) that are added
	TruncLog = -1			&& Status of Trunc.log on chkpt. option of database
	cFinishMsg = ""			&& message to display at end
	nSQL7CompLevel = 0		&& SQL 7.0 database compatiblity level

	Procedure ProcessOutput
		Local lcSQL, lcMsg

		This.ProcessingOutput=.T.

		*Let user bail if they want
		On ESCAPE OEngine.Esc_proc

		If this.SQLServer

			*SQL Server: create devices
			This.DealWithDevices

			*SQL Server: create database
			This.CreateTargetDB

			*Connect to target database
			lcSQL="use " + ALLTRIM(this.ServerDBName)
			=this.ExecuteTempSPT(lcSQL)

			*set option Trunc.Log on chkpt. for database on server
			This.TruncLogOn

		Endif

		*Make sure everything's been analyzed that's going to be upsized
		This.AnalyzeFields

		*create tablespaces, clusters and cluster indexes
		If this.ServerType="Oracle"
			This.CreateTablespaces
			This.CreateClusters
		Endif


		*create tables
		This.CreateTables

		*send data
		This.SendData

		*create indexes
		This.AnalyzeIndexes

		*build RI code
		If this.ExportRelations THEN
			This.BuildRiCode
		Endif

		If this.ExportIndexes THEN
			This.CreateIndexes
		Endif

		*deal with defaults and validation rules
		This.DefaultsAndRules

		*create put rules and RI code into triggers
		This.CreateTriggers

		*redirect app
		This.RedirectApp

		*do report stuff
		This.CreateScript

		This.BuildReport

		*done
		*reset option trunc. log on chkpt. to initial value
		If this.SQLServer
			This.TruncLogOff
		Endif

		*test if all the tables were upsized. If not display warning message.
		This.UpsizeComplete

	Endproc


	Procedure Error
		Parameters nError, cMethod, nLine, oObject
		Local lcErrMsg, lnServerError

		=AERROR(aErrArray)
		nError=aErrArray[1]
		This.MyError=nError

		Do CASE
		Case nError=1523
			*User hit cancel button in ODBC dialog
			This.HadError=.T.
			Return .F.

		Case nError=15
			*Not a table (probably means the table is corrupt)
			This.HadError=.T.
			Return

		Case nError=108
			*File opened exclusive by someone else
			This.HadError=.T.
			Return

		Case nError=1705 OR nError=3
			*File access denied
			*Should be caused only when the wizard tries to open
			*all tables in database exclusively
			This.HadError=.T.
			Return

		Case nError=1976
			*Table is not marked for current database
			*Like 1705 above, should only happen in the this.Upsizable function
			This.HadError=.T.
			Return

		Case nError=1984
			*Table definition and DBC are out of sync
			*(Another error that could result from this.Upsizable)
			This.HadError=.T.
			Return

		Case nError=1498
			*Attempt to create remote view failed because of bogus SQL
			This.HadError=.T.
			Return

		Case nError=1160
			*Out of disk space
			lnUserChoice=MESSAGEBOX(NO_DISK_SPACE_LOC,RETRY_CANCEL+ICON_EXCLAMATION,TITLE_TEXT_LOC)
			If lnUserChoice=RETRY_CHOICE THEN
				Retry
			Endif
		Case nError=1577 
			*Table "name" is referenced in a relation
			*Occurs when drop table that's in a relation
			This.HadError=.T.
			Return

		Endcase

		*Unhandled errors->We're dead
		WizEngineAll::Error(nError, cMethod, nLine, oObject)

	Endproc


	Procedure Esc_proc

		*If the user hits escape when the wizard is processing output
		Clear TYPEAHEAD
		If MESSAGEBOX(ESCAPE_CONT_LOC,ICON_EXCLAMATION+YES_NO_BUTTONS,TITLE_TEXT_LOC)=USER_YES
			Set ESCAPE OFF
			This.Die
			Return TO Wizstart
		Else
			Return
		Endif
	Endproc


	Procedure Destroy
		Local lcAction, lcDelDir, lcSQL, llRetVal

		*don't nuke the analysis tables if the user wants a report
		lcAction=IIF(this.DoReport AND this.ProcessingOutput,"Close","Delete")

		*Deal with tables that are part of the upsizing wizard project (that don't need to be deleted)
		This.DisposeTable("Keywords","Close")
		This.DisposeTable("ExprMap","Close")
		This.DisposeTable("TypeMap","Close")

		*Close this cursor (created in SQL 95 case)
		This.DisposeTable(this.OraNames,"Close")

		*Clean up device stuff if it exists
		This.DeviceCleanUp(WIZARD_CLOSING)

		* jvf 8/17/99 Don't close them if we've already dropped 'em.
		If !this.DropLocalTables
			*Close user tables
			This.CloseUserTables
		Endif

		*Close/delete analysis tables
		This.AnalCleanUp(lcAction, WIZARD_CLOSING)

		* Restore SQL Server 7.0 compatibility levels
		If ATC("SQL Server",THIS.ServerType)#0 AND THIS.nSQL7CompLevel>=70
			lcSQL=[sp_dbcmptlevel ]+ALLTRIM(THIS.ServerDBName)+[,]+TRANS(THIS.nSQL7CompLevel)
			llRetVal=THIS.ExecuteTempSPT(lcSQL)
		Endif

		*Connection cleanup
		If this.MasterConnHand>0 THEN
			SQLDISCONN(this.MasterConnHand)
		Endif

		*Clean up error tables
		If !this.SaveErrors THEN
			This.DisposeTable(this.ErrTbl,"Delete")
			If !EMPTY(aDataErrTbls) THEN
				For I=1 to ALEN(aDataErrTbls,1)
					This.DisposeTable(aDataErrTbls[i,2],"Delete")
				Next
			Endif
		Endif

		*Nix newly created directory if appropriate
		If this.CreatedNewDir AND !this.KeepNewDir THEN
			lcDelDir=FULLPATH(SYS(5))
			Cd ..
			Rmdir (lcDelDir)
		Endif

		*Release memory variables
		Release aOpenDatabases, aDataSources, aServerDatabases, ;
			aConnDefs, aExport, aTablesToExport, ;
			aDataErrTbls, aDeviceNumbers, gcQT, gc2QT, ;
			aClusters, aValidTables, aClusterTables, aServerTablespaces, ;
			aDataFiles, aSelectedTablespaces, aSelectList, aFiles

		* restore fetch memo option
		=cursorsetprop('FetchMemo', this.FetchMemo, 0)

		*- save messagebox until we've have finished clearnup
		If !EMPTY(THIS.cFinishMsg)
			=MESSAGEBOX(THIS.cFinishMsg, ICON_EXCLAMATION, TITLE_TEXT_LOC)
		Endif

		WizEngineAll::Destroy

	Endproc


	Procedure AnalCleanUp
		*Called by main Cleanup proc and if the user changes the source database
		Parameters lcAction, llWizardClosing

		If !llWizardClosing

			*Turn off the recordsource of grid and columns to prevent errors when source table is closed
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.recordsource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.RecordSource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.grcFldName.ControlSource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.grcType.ControlSource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.grcRmtType.ControlSource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.grcRmtLength.ControlSource=""
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page7.grdTypeMap.grcRmtPrec.ControlSource=""

			*Reset flags
			This.AnalyzeTablesRecalc=.T.
			This.AnalyzeIndexesRecalc=.T.
			This.AnalyzeFieldsRecalc=.T.
			This.GetConnDefsRecalc=.T.
			This.GridFilled=.F.
			This.EligibleRelsRecalc=.T.
			This.GetRiInfoRecalc=.T.

		Endif

		If this.NormalShutdown THEN
			If this.DoReport AND this.ProcessingOutput THEN
				lcAction="Close"
			Else
				lcAction="Delete"
			Endif
		Else
			lcAction="Delete"
		Endif

		This.DisposeTable(this.MappingTable,"Close")
		This.DisposeTable(this.EnumFieldsTbl,lcAction)
		This.DisposeTable(this.EnumTablesTbl,lcAction)
		This.DisposeTable(this.EnumIndexesTbl,lcAction)
		This.DisposeTable(this.ViewsTbl,lcAction)
		This.DisposeTable(this.EnumRelsTbl,lcAction)

		*Don't want to delete error or script table unless user hit cancel or error
		If this.NormalShutdown THEN
			lcAction="Close"
		Endif
		This.DisposeTable(this.ErrTbl,lcAction)
		This.DisposeTable(this.ScriptTbl,lcAction)

		If !llWizardClosing
			*Reset analysis table-related variables to original default values
			This.EnumRelsTbl=""
			This.MappingTable=""
			This.EnumFieldsTbl=""
			This.EnumTablesTbl=""
			This.EnumIndexesTbl=""
			This.ViewsTbl=""
			This.TableChosen=.F.
			This.UserConnection=""
		Endif


	Endproc


	Procedure DeviceCleanUp
		Parameters WizardClosing
		*Called by main Cleanup proc and if the user changes the data source

		*Only execute this code only if the user is changing the data source or source database
		If type('oWizard') = 'O' .and. .not. isnull(OWizard)
			*Reset rowsources of the two device screens to nothing to avoid an error
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page4.Device1.cboDeviceName.rowsourcetype=0
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page5.Device1.cboDeviceName.rowsourcetype=0
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page4.Device1.SelfFilled=.F.
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page5.Device1.SelfFilled=.F.

		Endif

		*Clean up the device tables
		This.DisposeTable(this.DeviceTableAlias,"Close")
		This.DisposeTable(this.DeviceTable,"Delete")

		If !WizardClosing THEN
			*Reset all Device-related properties to their original default values
			This.UserInput=""
			This.DeviceTable=""
			This.DeviceTableAlias=""
			This.DeviceNumbersFree=0
			This.DeviceDBName=""
			This.DeviceDBPName=""
			This.DeviceDBSize=0
			This.DeviceDBNumber=0
			This.DeviceDBNew=.F.
			This.DeviceDBChosen=.F.
			This.DeviceLogName=""
			This.DeviceLogPName=""
			This.DeviceLogSize=0
			This.DeviceLogNumber=0
			This.DeviceLogNew=.F.
			This.DeviceLogChosen=.F.
			This.MasterPath=""
			This.NewDeviceCount=0
			This.ChooseTargetDBRecalc=.T.
			This.DataSourceChosen=.F.
			DeviceDBInDefa=.F.
			DeviceLogInDefa=.F.
			DBonDefault=.F.

			*Set recalc flag on
			This.DeviceRecalc=.T.

		Endif

	Endproc


	Procedure CloseUserTables
		Local lcEnumTablesTbl

		*Closes user tables that weren't open before running the upsizing wizard

		lcEnumTablesTbl=this.EnumTablesTbl
		If lcEnumTablesTbl=="" THEN
			Return
		Endif

		Dimension aTableArray[1]
		Select CursName FROM (lcEnumTablesTbl) ;
			WHERE Upsizable=.T. AND PreOpened=.F. ;
			INTO ARRAY aTableArray
		If !EMPTY(aTableArray) THEN
			For I=1 TO ALEN(aTableArray)
				*close the table
				Select (RTRIM(aTableArray[i]))
				Use
			Next
		Endif

	Endproc


	Procedure DisposeTable
		Parameters lcTableName, lcAction
		*Close the table if it's open
		If USED(lcTableName)
			Select (lcTableName)
			Use
		Endif

		*Clean up any backup files incidentally created
		If FILE(lcTableName+".bak") THEN
			Delete FILE lcTableName+".bak"
		Endif
		If FILE(lcTableName+".tbk") THEN
			Delete FILE lcTableName+".tbk"
		Endif

		*Delete file if appropriate
		If lcAction="Delete" THEN
			If FILE(lcTableName+".dbf") THEN
				Delete FILE lcTableName+".dbf"
			Endif
			If FILE(lcTableName+".cdx") THEN
				Delete FILE lcTableName+".cdx"
			Endif
			If FILE(lcTableName+".fpt") THEN
				Delete FILE lcTableName+".fpt"
			Endif
		Endif

	Endproc


	Procedure InitTherm
		Parameters lcTitle, lnBasis, lnInterval

		*This routine creates the thermometer or initializes it if it already exists

		If !this.ProcessingOutput THEN
			Return
		Endif

		If !this.ThermCreated THEN
			This.AddTherm
			This.ThermRef.AlwaysOnTop = .F.
			This.ThermRef.Visible = .T.
			This.ThermCreated=.T.
		Endif

		This.ThermRef.Init(lcTitle,lnBasis,lnInterval)
		This.ThermRef.Update(0,"")

	Endproc


	Procedure UpDateTherm
		Parameters lnProgress, lcTask

		*This routine updates the thermometer if processing output

		If !this.ProcessingOutput THEN
			Return
		Else
			If PARAMETERS()=2 THEN
				This.ThermRef.Update(lnProgress,lcTask)
			Else
				This.ThermRef.Update(lnProgress)
			Endif
		Endif

	Endproc


	Procedure DealWithDevices
		*Creates devices if appropriate
		Local lnRetVal, lcDevicePName,lnDeviceNumber

		If this.ServerVer>=7
			This.DeviceDBNew = .F.
			This.DeviceLogNew = .F.
		Endif

		lcDevicePName=""
		lnDeviceNumber=0

		If this.DeviceDBNew = .T. THEN
			lnRetVal=this.CreateDevice("DB",@lcDevicePName,@lnDeviceNumber)
			This.DeviceDBPName=lcDevicePName
			This.DeviceDBNumber=lnDeviceNumber
		Endif
		If this.DeviceLogNew = .T. THEN
			lnRetVal=this.CreateDevice("Log", @lcDevicePName,@lnDeviceNumber)
			This.DeviceLogPName=lcDevicePName
			This.DeviceLogNumber=lnDeviceNumber
		Endif
	Endproc


	Procedure CreateTargetDB
		Local lcSQL, lcMsg, lnErr, lcErrMsg, lnCompLevel

		*Build the SQL statement
		If this.CreateNewDB THEN
			If this.ServerVer>=7
				lcSQL= "create database " + RTRIM(this.ServerDBName)
			Else
				lcSQL= "create database " + RTRIM(this.ServerDBName) + " on "
				lcSQL= lcSQL + RTRIM(this.DeviceDBName) + "=" + ALLTRIM(STR(this.ServerDBSize))
				If this.ServerLogSize<> 0 THEN
					lcSQL= lcSQL+ " log on " + RTRIM(this.DeviceLogName)  + "=" + ALLTRIM(STR(this.ServerLogSize))
				Endif
			Endif
		Else
			Return
		Endif

		*Execute if appropriate
		If this.DoUpsize THEN
			lcMsg=STRTRAN(CREATING_DATABASE_LOC,'|1',RTRIM(this.ServerDBName))
			This.InitTherm(lcMsg,0,0)
			This.UpDateTherm(0,TAKES_AWHILE_LOC)
			SQLSETPROP(this.MasterConnHand,"QueryTimeOut",600)
			This.MyError=0
			If !this.ExecuteTempSPT(lcSQL, @lnErr,@lcErrMsg) THEN
				If lnErr=262 THEN
					*User doesn't have CREATE DATABASE permissions
					lcMsg=STRTRAN(NO_CREATEDB_PERM_LOC,'|1',RTRIM(this.DataSourceName))
				Else
					*Something else went wrong
					lcMsg=STRTRAN(CREATE_DB_FAILED_LOC,'|1',RTRIM(this.ServerDBName))
				Endif
				Messagebox(lcMsg,ICON_EXCLAMATION,TITLE_TEXT_LOC)
				This.Die
			Endif
			SQLSETPROP(this.MasterConnHand,"QueryTimeOut",30)
			This.ThermRef.Complete
		Endif

		*Stash sql for script
		This.StoreSQL(lcSQL,CREATE_DBSQL_LOC)

		If this.ServerVer>=7
			lnCompLevel=0
			lcSQL = "select cmptlevel from master.dbo.sysdatabases where name='"+this.ServerDBName+"'"
			If THIS.SingleValueSPT(lcSQL,@lnCompLevel,"cmptlevel")
				This.nSQL7CompLevel = lnCompLevel
				lcSQL=[sp_dbcmptlevel ]+this.ServerDBName+[,65]
				This.ExecuteTempSPT(lcSQL)
			Endif
		Endif

	Endproc


	Procedure CreateTablespaces
		* create new Table tablespace or add file to an existing one
		If this.TSNewTableTS
			This.CreateTS(this.TSTableTSName, this.TSFTableFileName, this.TSFTableFileSize)
		Else
			If !EMPTY(this.TSFTableFileName)
				This.CreateDataFile(this.TSTableTSName, this.TSFTableFileName, this.TSFTableFileSize)
			Endif
		Endif

		*If the tablespace for tables and indexes are the same, bail
		If this.TSTableTSName=this.TSIndexTSName THEN
			Return
		Endif

		* create new Index tablespace or add file to an existing one
		If this.TSNewIndexTS
			This.CreateTS(this.TSIndexTSName, this.TSFIndexFileName, this.TSFIndexFileSize)
		Else
			If !EMPTY(this.TSFIndexFileName)
				This.CreateDataFile(this.TSIndexTSName, this.TSFIndexFileName, this.TSFIndexFileSize)
			Endif
		Endif

	Endproc


	Procedure CreateTables
		Local lcEnumTablesTbl, llRetVal, dummy, llTableExists, MyMessageBox, ;
			lnTableCount, lcMsg, lcSQL, lnError, lcErrMsg, lcCRLF, lcRmtTable

		dummy = "x"
		lcCRLF = CHR(10) + CHR(13)

		* first go create a SQL statement for all tables the user chose to export
		This.CreateTableSQL

		* then if the user wants to upsize and not just create scripts, export the tables
		If this.DoUpsize THEN
			lcEnumTablesTbl = this.EnumTablesTbl
			Select (lcEnumTablesTbl)

			* For thermometer
			Select COUNT(*) FROM (lcEnumTablesTbl) WHERE Export = .T. INTO ARRAY aTableCount
			lnTableCount = 0
			This.InitTherm(CREATING_TABLES_LOC, aTableCount,0)

			This.Overwrite = .F.

			Scan FOR Export = .T.
				* For thermometer
				lcMessage = STRTRAN(THIS_TABLE_LOC, "|1", RTRIM(&lcEnumTablesTbl..RmtTblName))
				This.UpDateTherm(lnTableCount, lcMessage)
				lnTableCount = lnTableCount + 1

				* If we're Oracle and table is part of cluster, make sure cluster was created
				If this.ServerType = "Oracle" AND !EMPTY(ClustName)
					If !this.ClusterExported(RTRIM(ClustName))
						* If cluster wasn't created, skip the table, log error message
						lcMsg = STRTRAN(CLUST_NOT_CREATED_LOC, '|1', RTRIM(ClustName))
						Replace Exported WITH .F., TblError WITH lcMsg ADDITIVE
						lnTableCount = lnTableCount + 1
						Loop
					Endif
				Endif

				*Check to see if table already exists
				lcRmtTable = RTRIM(&lcEnumTablesTbl..RmtTblName)
				If this.TableExists(lcRmtTable) THEN
					If !this.OverWrite THEN
						This.OverWriteOK(RTRIM(&lcEnumTablesTbl..RmtTblName), "Table")
						Do CASE
						Case this.UserInput = '3'
							* user says leave it alone ('NO') THEN
							lcMsg = TABLE_NOT_CREATED_LOC
							Replace Exported WITH .F., TblError WITH lcMsg ADDITIVE
							lnTableCount = lnTableCount + 1
							Loop
						Case this.UserInput = '2'
							* user says overwrite all
							This.OverWrite = .T.
							*CASE else
							* just keep going
						Endcase
						This.UserInput = ""
					Endif
					* Drop the table; skip the table if it can't be dropped for some reason
					llRetVal = this.DropTable(&lcEnumTablesTbl..RmtTblName)
					If !llRetVal THEN
						Replace Exported WITH .F., TblError WITH CANT_DROP2_LOC ADDITIVE
						lnTableCount = lnTableCount+1
						Loop
					Endif
				Endif

				lcSQL = TableSQL
				llRetVal = this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg)
				If llRetVal THEN
					Replace Exported WITH .T.
				Else
					This.StoreError(lnError, lcErrMsg, lcSQL, CANT_CREATE_LOC, lcRmtTable, TABLE_LOC)
					Replace Exported WITH .F., TblError WITH CANT_CREATE_LOC ADDITIVE, ;
						TblErrNo WITH lnError
				Endif
			Endscan
			This.ThermRef.Complete
		Endif
	Endproc


	Procedure CreateTableSQL
		Local lcEnumTablesTbl, lcEnumFieldsTbl, lnOldArea, lcTableName, llTStamp, ;
			lnTableCount, lcCRLF, lcTimeStamp, I, lcExact
		lcCR=CHR(10)
		lcEnumTablesTbl = this.EnumTablesTbl
		lcEnumFieldsTbl = this.EnumFieldsTbl
		lnOldArea = SELECT()
		Select (lcEnumTablesTbl)

		*Update thermometer
		Select COUNT(*) FROM (lcEnumTablesTbl) WHERE Export=.T. INTO ARRAY aTableCount
		This.InitTherm(TABLE_SQL_LOC,aTableCount,0)
		lnTableCount=0

		*SQL Server bit fields don't support NULLs
		Select (lcEnumFieldsTbl)
		Replace RmtNull WITH .F. FOR RmtType="bit"

		* Handle Null overrides
		Do CASE
		Case THIS.NullOverride=1	&&general only
			Replace RmtNull WITH .T. FOR RmtType#"bit" AND INLIST(Datatype,"G")
		Case THIS.NullOverride=2	&&general and memo only
			Replace RmtNull WITH .T. FOR RmtType#"bit" AND INLIST(Datatype,"G","M")
		Case THIS.NullOverride=3	&&all fields
			Replace RmtNull WITH .T. FOR RmtType#"bit"
		Endcase

		*Make sure if we add timestamp that we don't get duplicate field names
		lcTimeStamp=LOWER(TIMESTAMP_LOC)
		lcExact=SET("EXACT")
		Set EXACT ON
		Locate FOR FldName=(lcTimeStamp)
		I=1
		Do WHILE LEN(lcTimeStamp)<MAX_NAME_LENGTH
			If EOF()
				Exit
			Endif
			lcTimeStamp=TIMESTAMP_LOC+LTRIM(STR(I))
			Locate FOR FldName=(lcTimeStamp)
			I=I+1
		Enddo
		Set EXACT &lcExact
		This.TimeStampName=lcTimeStamp

		*Make sure if we add identity column that we don't get duplicate field names
		lcIdentityCol = LOWER(IDENTCOL_LOC)
		lcExact=SET("EXACT")
		Set EXACT ON
		Locate FOR FldName=(lcIdentityCol)
		I=1
		Do WHILE LEN(lcIdentityCol)<MAX_NAME_LENGTH
			If EOF()
				Exit
			Endif
			lcIdentityCol=IDENTCOL_LOC+LTRIM(STR(I))
			Locate FOR FldName=(lcIdentityCol)
			I=I+1
		Enddo
		Set EXACT &lcExact
		This.IdentityName=lcIdentityCol

		Select (lcEnumTablesTbl)
		Scan FOR Export=.T.
			lcTableName=RTRIM(&lcEnumTablesTbl..TblName)
			lcMsg=STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
			This.UpDateTherm(lnTableCount,lcMsg)

			lcCreateString="CREATE TABLE " + RTRIM(&lcEnumTablesTbl..RmtTblName) +" ("
			Select (lcEnumFieldsTbl)
			Scan FOR RTRIM(&lcEnumFieldsTbl..TblName)==lcTableName
				lcCreateString = lcCreateString + RTRIM(&lcEnumFieldsTbl..RmtFldname)
				lcCreateString = lcCreateString + " " + RTRIM(&lcEnumFieldsTbl..RmtType)
				If &lcEnumFieldsTbl..RmtLength<>0 THEN
					lcCreateString = lcCreateString + "(" + ALLTRIM(STR(&lcEnumFieldsTbl..RmtLength))
					If this.ServerType="Oracle" OR this.ServerType=="SQL Server95" THEN
						If &lcEnumFieldsTbl..RmtPrec<>0 THEN
							lcCreateString = lcCreateString + "," + ALLTRIM(STR(&lcEnumFieldsTbl..RmtPrec))
						Endif
					Endif
					lcCreateString = lcCreateString + ")"
				Endif
				lcCreateString = lcCreateString + " " + IIF(&lcEnumFieldsTbl..RmtNull=.T., "NULL, ","NOT NULL, ")
			Endscan
			Select (lcEnumTablesTbl)

			* Add timestamp and identity if appropriate
			* Account for choosing All
			* jvf: 08/13/99
			llTStamp = (this.SQLServer AND (TStampAdd OR this.TimeStampAll=1))
			llIdentity = (this.SQLServer AND (IdentAdd OR this.IdentityAll=1))

			If llTStamp
				lcCreateString = lcCreateString + lcTimeStamp + " timestamp, "
			Endif

			If llIdentity
				lcCreateString = lcCreateString + lcIdentityCol + " int IDENTITY(1,1), "
			Endif

			* peel off the extra comma at the end and add a closing parenthesis
			lcCreateString = LEFT(lcCreateString, LEN(RTRIM(lcCreateString)) - 1) + ")"

			* Oracle only: add tablespace or cluster name if appropriate
			If this.ServerType = ORACLE_SERVER
				* clustered tables are created in the tablespace of the cluster index
				If !EMPTY(&lcEnumTablesTbl..ClustName)
					lcClustName = TRIM(&lcEnumTablesTbl..ClustName)
					lcClusterKey = this.CreateClusterKey(lcTableName, .F.)
					lcCreateString = lcCreateString + " CLUSTER " + lcClustName + " (" + lcClusterKey + ")"
				Else
					If !EMPTY(this.TSTableTSName)
						lcCreateString = lcCreateString + " TABLESPACE " + this.TSTableTSName
					Endif
				Endif
			Endif

			Replace TableSQL with lcCreateString
			lnTableCount = lnTableCount + 1

		Endscan

		This.ThermRef.Complete
		Select (lnOldArea)

	Endproc



	Function TableExists
		Parameters lcTableName
		Local dummy, lcSQuote

		*Checks to see if a table of the same name already exists on the server

		dummy='x'
		lcSQuote=CHR(39)
		If this.ServerType="Oracle" THEN
			lcSQL="SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME=" + lcSQuote+ UPPER(lcTableName) + lcSQuote
			lcField="TABLE_NAME"
		Else
			lcSQL="select uid from sysobjects where uid = user_id() and name =" + lcSQuote + lcTableName + lcSQuote
			lcField="uid"
		Endif

		Return this.SingleValueSPT(lcSQL, dummy, lcField)

	Endfunc



	Procedure AddTableToCluster
		Parameters lcClustName, aKeyFields
		Local lnOldArea, lcEnumFieldsTbl, lcTableName, I

		* Adds the cluster name to the table record and the ClustOrder
		* to the fields participating in the key expression
		* The <table> parameter is given by the current record in 'Tables'

		Dimension aKeyFields[ALEN(aKeyFields)]
		lnOldArea = SELECT()
		lcEnumFieldsTbl = this.EnumFieldsTbl
		lcTableName = LOWER(TRIM(TblName))
		Replace ClustName WITH lcClustName

		* set the ClusterOrder field for each Key column
		Select (lcEnumFieldsTbl)
		Replace ClustOrder WITH 0 FOR TblName == lcTableName
		For m.I = 1 TO ALEN(aKeyFields,1)
			Locate FOR TblName = lcTableName AND FldName = LOWER(aKeyFields[m.i])
			If EOF()
				* we should never get here
				Loop
			Endif
			Replace ClustOrder WITH m.I
		Endfor

		Select (lnOldArea)

	Endfunc


	Procedure DeleteClusterInfo(lcClusterName)
		Local lnOldArea, lcEnumTablesTbl, lcEnumFieldsTbl, llAll

		* removes <lcClusterName> from its tables in Tables and
		* removes ClustOrder from all corresponding field records in Fields
		* if called with no parameter, clears all cluster info from Tables and Fields

		llAll = (PARAMETERS() = 0)
		lnOldArea = SELECT()
		lcEnumTablesTbl = this.EnumTablesTbl
		lcEnumFieldsTbl = this.EnumFieldsTbl

		If !llAll
			Select (lcEnumTablesTbl)
			Scan FOR ClustName = lcClusterName
				lcTableName = LOWER(TRIM(TblName))
				Select (lcEnumFieldsTbl)
				Replace ClustOrder WITH 0 FOR TblName == lcTableName
				Select (lcEnumTablesTbl)
				Replace ClustName WITH ""
			Endscan
		Else
			Select (lcEnumFieldsTbl)
			Replace ClustOrder WITH 0 ALL
			Select (lcEnumTablesTbl)
			Replace ClustName WITH "" ALL
		Endif

		Select (lnOldArea)
	Endproc



	Procedure GetDefaultClusters
		Local lcEnumRelsTbl, lnOldArea, lcEnumTablesTbl, lcClustName, ;
			aParentKey, aChildKey, lcChildExpr, myarray, lcMsg
		Dimension aParentKey[1], aChildKey[1], myarray[1]

		This.GetRiInfo
		Select COUNT(*) from (this.EnumRelsTbl) into array myarray
		If EMPTY(myarray)
			=MESSAGEBOX(CANTDEFCLUSTERS_LOC, ICON_EXCLAMATION, TITLE_TEXT_LOC)
			Return .F.
		Else
			This.DeleteClusterInfo()

			lnOldArea = SELECT()
			lcEnumRelsTbl = this.EnumRelsTbl
			lcEnumTablesTbl = this.EnumTablesTbl

			* select all parent tables in aParents
			Select DISTINCT  DD_PARENT,DD_PAREXPR  FROM (lcEnumRelsTbl) INTO ARRAY aParents
			For m.I = 1 to ALEN(aParents,1)
				* find next available parent table
				Select (lcEnumTablesTbl)
				Locate FOR TblName = LOWER(aParents(m.I,1))
				If EOF() OR !EMPTY(ClustName)
					Loop
				Endif

				* get cluster name and parent key fields
				lcClustName = CL_LOC + TRIM(aParents[m.i,1])
				aParentKey[1] = ""
				This.KeyArray(aParents[m.i,2], @aParentKey)

				* add child table to cluster
				This.AddTableToCluster(lcClustName, @aParentKey)

				* find available child tables and add them to the cluster
				Select (lcEnumRelsTbl)
				Scan FOR DD_PARENT = aParents[m.i,1] AND DD_PAREXPR = aParents[m.i,2]
					lcChild = TRIM(DD_CHILD)
					lcChildExpr = DD_CHIEXPR
					Select(lcEnumTablesTbl)
					Locate FOR TblName = LOWER(lcChild)
					If EOF() OR !EMPTY(ClustName)
						Loop
					Endif

					* get child key fields, compare with parent key fields
					aChildKey[1] = ""
					This.KeyArray(lcChildExpr, @aChildKey)
					If ALEN(aParentKey) != ALEN(aChildKey)
						Loop
					Endif

					* add child table to cluster
					This.AddTableToCluster(lcClustName, @aChildKey)

					Select (lcEnumRelsTbl)
				Endscan
			Endfor

			* initialise the aClusters array
			Dimension aClusters[1,5]
			aClusters[1,1] = ""
			Select DISTINCT ClustName FROM (lcEnumTablesTbl) INTO ARRAY aParents
			For m.I = 1 to ALEN(aParents,1)
				If (m.I = 1)
					aClusters[1,1] = aParents[1]
					aClusters[1,2] = "INDEX"
					aClusters[1,3] = 0
					aClusters[1,4] = 2
					aClusters[1,5] = .F.
				Else
					OEngine.InsArrayRow(@aClusters, aParents[m.i], "INDEX", 0, 2, .F.)
				Endif
			Endfor
		Endif

		Select (lnOldArea)
	Endproc


	Function GetClusterKey
		Parameters lcTableName, lcClustName
		Local lcEnumRelsTbl, lnOldArea

		* Returns the key of a table that's in a cluster

		lnOldArea = SELECT()
		lcEnumRelsTbl = this.EnumRelsTbl
		Select (lcEnumRelsTbl)
		Locate FOR RTRIM(ClustName) == lcClustName
		If RTRIM(DD_PARENT)==lcTableName THEN
			lcClusterKey=DD_PAREXPR
		Else
			lcClusterKey=DD_CHIEXPR
		Endif

		Select (lnOldArea)
		Return ALLTRIM(lcClusterKey)

	Endfunc


	Function AddTimeStamp
		Parameters lcTableName
		Local lcEnumFieldsTbl, aCount[1]

		*This routine returns True if a table has float, real, binary,
		*varbinary, image, or text data types in them

		lcEnumFieldsTbl = this.EnumFieldsTbl

		Select COUNT(*) FROM (lcEnumFieldsTbl) ;
			WHERE TblName = lcTableName ;
			AND (DataType = "M" or ;
			DataType = "G" or ;
			DataType = "P") ;
			INTO ARRAY aCount

		Return aCount[1] > 0
	Endfunc


	Function DropTable
		Parameters lcTable
		Local lcSQL

		If this.ServerType="Oracle" THEN
			lcSQL="drop table " + RTRIM(lcTable) + " CASCADE CONSTRAINTS"
		Else
			lcSQL="drop table " + RTRIM(this.UserName) + "." + RTRIM(lcTable)
		Endif
		lnRetVal=this.ExecuteTempSPT(lcSQL)
		Return lnRetVal

	Endfunc


	Procedure CreateClusters
		Local lcSQL, lcEnumClustersTbl, llClusterCreated, dummy, lcClusterName, lcThermMsg, ;
			lnClustCount, lnError, lcErrMsg, aClustCount

		*In this routine, the SQL for clusters is created and (possibly) executed
		*and cluster indexes are created as appropriate

		*Bail if there aren't any clusters to create
		If !this.CreateClusterSQL() THEN
			Return
		Endif

		dummy = "x"
		If this.DoUpsize THEN
			lcEnumClustersTbl = this.EnumClustersTbl
			Select (lcEnumClustersTbl)
			aClustCount = RECCOUNT()
			This.InitTherm(CREATING_CLUSTERS_LOC, aClustCount, 0)
			lnClustCount = 0

			Scan
				*check for existing cluster
				lcClusterName = RTRIM(ClustName)
				lcThermMsg = STRTRAN(THIS_CLUST_LOC, "|1", lcClusterName)
				This.UpDateTherm(lnClustCount, lcThermMsg)
				lnClustCount = lnClustCount + 1
				lcSQL = "SELECT CLUSTER_NAME FROM USER_CLUSTERS WHERE CLUSTER_NAME=" + "'" + UPPER(lcClusterName) + "'"
				If this.SingleValueSPT(lcSQL, dummy, "CLUSTER_NAME") THEN
					If !this.OverWrite THEN
						*Pop up dialog and ask user what they want to do
						This.OverWriteOK(RTRIM(ClustName), "Cluster")
						Do CASE
						Case this.UserInput = '3'
							*user says leave it alone ('NO') THEN
							Replace Exported WITH .F., ClustErr WITH CLUST_EXISTS_LOC
							Loop
						Case this.UserInput = '2'
							*user says overwrite all
							This.OverWrite = .T.
							*CASE else
							*just keep going
						Endcase
						This.UserInput = ""
					Endif
					* Drop the cluster and all tables; otherwise you can't know
					* if the cluster key is going to work for the tables
					* the wizard will try to add
					*
					*If dropping cluster and tables doesn't work, bag the cluster
					*and the tables

					If !this.DropCluster(RTRIM(ClustName), @lnError, @lcErrMsg)
						Replace Exported WITH .F., ClustErr WITH CANT_DROP_LOC ADDITIVE
						This.StoreError(lnError, lcErrMsg, lcSQL, CANT_DROP_LOC, lcClusterName, CLUSTER_LOC)
						Loop
					Endif
				Endif

				lcSQL = &lcEnumClustersTbl..ClusterSQL
				If !this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg) THEN
					This.StoreError(lnError, lcErrMsg, lcSQL, CANT_CREATE_CLUST_LOC, lcClusterName, CLUSTER_LOC)
					Replace Exported WITH .F., ClustErr WITH CANT_CREATE_CLUST_LOC ADDITIVE, ;
						ClustErrNo WITH lnError
				Else
					Replace Exported WITH .T.
				Endif
			Endscan
			This.ThermRef.complete
		Endif

		* Now go create cluster indexes, if any
		This.CreateClusterIndexes

	Endproc


	Procedure CreateClusterIndexes
		Local lcEnumRelsTbl, lcEnumIndexesTbl, llRetVal, lnError, lcMessage, lnOldArea

		* If there are clusters, create the index sql now
		*
		* DRI on clusters requires that indexes be created before the DRI is executed
		* On the other hand, indexes can conflict with DRI.  This way the wizard
		* creates cluster indexes, does the DRI (which resolves potential index-DRI conflicts
		* and then creates non-cluster indexes
		*

		*Create table to hold index names and expressions
		If RTRIM(this.EnumIndexesTbl) == ""
			This.EnumIndexesTbl = this.CreateWzTable("Indexes")
		Endif

		lcEnumClustersTbl = this.EnumClustersTbl
		lcEnumIndexesTbl = this.EnumIndexesTbl
		lnOldArea = SELECT()
		Select (lcEnumClustersTbl)

		Scan FOR ClustType = "INDEX"
			lcClusterName = RTRIM(ClustName)
			lcTagName = CLUST_INDEX_PREFIX + LEFT(lcClusterName, MAX_NAME_LENGTH-LEN(CLUST_INDEX_PREFIX))
			lcTagName = this.UniqueOraName(lcTagName)
			lcSQL = "CREATE INDEX " + lcTagName + " ON CLUSTER " + lcClusterName

			If !EMPTY(this.TSIndexTSName)
				lcSQL = lcSQL + " TABLESPACE " + LTRIM(this.TSIndexTSName)
			Endif

			If this.DoUpsize THEN
				llRetVal = this.ExecuteTempSPT(lcSQL, @lnError, @lcMessage)
				If !llRetVal
					This.StoreError(lnError, lcMessage, lcSQL, CLUST_IDX_FAILED_LOC, lcTagName, INDEX_LOC)
				Endif
			Endif

			Select (lcEnumIndexesTbl)
			Append BLANK
			Replace RmtName WITH lcTagName, ;
				RmtTable WITH lcClusterName, ;
				IndexSQL WITH lcSQL, ;
				Exported WITH llRetVal, ;
				DontCreate WITH .T.

			If !EMPTY(lcMessage) THEN
				Replace IdxError WITH CLUST_IDX_FAILED_LOC, ;
					IdxErrNo WITH lnError
			Endif

			Select (lcEnumClustersTbl)
		Endscan

		Select(lnOldArea)

	Endproc


	Function UniqueOraName
		Parameters lcObjName, llAddToTable
		Local lcSQL, lnOldArea, lcOraNames, I, lcNewName, lnN, lcM, lcFieldName

		*Returns a name that is not in use by an index, constraint, or trigger
		*Only an issue for Oracle and SQL '95
		*
		*SQL Server 4.x and '95 let you have the same index name as long as they're
		*on different tables; however must have unique name for constraints

		lnOldArea=SELECT()
		If PARAMETERS()=1
			llAddToTable=.T.
		Endif

		* Get the names of all the user's indexes and constraints
		* this cursor is built once, then saved in <this.OraNames>
		If this.OraNames == "" THEN
			Select 0
			This.OraNames = this.UniqueCursorName("OraIdx")

			If this.ServerType="Oracle" THEN
				lcSQL=        "SELECT INDEX_NAME FROM USER_INDEXES "
				lcSQL=lcSQL + "UNION SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS "
				lcSQL=lcSQL + "UNION SELECT TRIGGER_NAME FROM USER_TRIGGERS"
			Else
				lcSQL="SELECT name FROM sysobjects"
			Endif

			*If it doesn't work, just send back original name; fatal
			*error is probably imminent anyway
			If !this.ExecuteTempSPT(lcSQL, lnN, lcM, this.OraNames) THEN
				This.OraNames=""
				Return lcObjName
			Endif
		Endif

		If this.ServerType = ORACLE_SERVER THEN
			lcFieldName = "INDEX_NAME"
		Else
			lcFieldName = "name"
		Endif

		*See if there's a conflict
		lcOraNames = this.OraNames
		Select (lcOraNames)
		lcNewName = lcObjName
		Locate FOR LOWER(RTRIM(&lcFieldName)) == LOWER(lcNewName)

		I=1
		Do WHILE FOUND()
			*If there's a duplicate name, fiddle with the new object name til it's unique
			lcNewName=LEFT(lcObjName,MAX_NAME_LENGTH-(LEN(LTRIM(STR(I))))) + LTRIM(STR(I))
			I=I+1
			Locate FOR LOWER(RTRIM(&lcFieldName))==LOWER(lcNewName)
		Enddo

		*Add the new name to the list of those in use
		If llAddToTable THEN
			Append BLANK
			Replace &lcFieldName WITH lcNewName
		Endif

		Select (lnOldArea)
		Return lcNewName

	Endfunc


	Function DropCluster
		Parameters lcClusterName, lnErrNo, lcErrMsg

		*Drop cluster, its tables, and any RI on the tables
		lcSQL="DROP CLUSTER " + RTRIM(lcClusterName)+ " INCLUDING TABLES CASCADE CONSTRAINTS"
		Return this.ExecuteTempSPT(lcSQL,@lnErrNo, @lcErrMsg)

	Endfunc


	Function ClusterExported
		Parameters lcClustName
		Local lcEnumClustersTbl, lnOldArea, llExported

		* Checks to see if the cluster was actually created

		lcEnumClustersTbl = this.EnumClustersTbl
		lnOldArea = SELECT()
		Select (lcEnumClustersTbl)
		Locate FOR RTRIM(ClustName) == lcClustName
		llExported = Exported
		Select(lnOldArea)
		Return llExported

	Endfunc


	Function HashDefault
		Parameters lcRel
		Local lcParent, lcChild, lnDupID, lnHashKeys, lnOldArea

		*Don't change this ratio w/o letting UE know
		#Define HASH_RATIO 			1.1

		#Define HASHKEYS_FLOOR		500
		#Define HASHKEYS_CEILING	2147483647

		*
		*Derives a number for default hashkey value
		*

		*Figures out how many records are in the parent table, multiplies it by some number

		This.ParseRel (lcRel, @lcParent, @lcChild, @lnDupID)

		lnOldArea=SELECT()
		Select (lcParent)

		lnHashKeys=RECCOUNT()*HASH_RATIO
		lnHashKeys=IIF(lnHashKeys>HASHKEYS_FLOOR,lnHashKeys,HASHKEYS_FLOOR)
		lnHashKeys=IIF(lnHashKeys>HASHKEYS_CEILING,HASHKEYS_CEILING,lnHashKeys)
		Select (lnOldArea)

		Return INT(lnHashKeys)

	Endfunc


	Procedure OverWriteOK
		Parameters lcObjectName, lcObjectType
		Local aButtonNames

		*display message box displaying Yes, Yes to all, No buttons
		If lcObjectType="Table" THEN
			lcMessageText=STRTRAN(TABLE_EXISTS_LOC,"|1",lcObjectName)
		Else
			lcMessageText=STRTRAN(CLUSTER_EXISTS_LOC,"|1",lcObjectName)
		Endif

		Dimension aButtonNames[3]
		aButtonNames[1]=YES_LOC
		aButtonNames[2]=YESALL_LOC
		aButtonNames[3]=NO_LOC
		MyMessageBox=CREATEOBJECT('MessageBox2',lcMessageText, @aButtonNames)
		MyMessageBox.show

	Endproc


	Function CreateClusterSQL
		Local lcClustName, lcPkey, aClusterTables, lcEnumClustersTbl, lnOldArea
		Dimension aClusterTables[1]

		*If the clusters table doesn't exist yet, there won't be any clusters
		If EMPTY(this.EnumClustersTbl)
			Return .F.
		Endif

		* needs to be of the form:
		* CREATE CLUSTER <clustername> (<key_name> <datatype>, etc.)

		lnOldArea = SELECT()
		lcEnumClustersTbl = this.EnumClustersTbl
		Select (lcEnumClustersTbl)
		Scan
			lcClustName = RTRIM(ClustName)
			This.GetEligibleClusterTables(@aClusterTables, lcClustName)
			lcPkey = this.CreateClusterKey(aClusterTables[1], .T.)

			lcSQL = "CREATE CLUSTER " + lcClustName + " (" + lcPkey + ")"

			If !EMPTY(this.TSTableTSName)
				lcSQL = lcSQL + " TABLESPACE " + LTRIM(this.TSTableTSName)
			Endif

			If ClustType = RTRIM("HASH")
				lcSQL = lcSQL + " HASHKEYS " + LTRIM(STR(HashKeys))
			Endif

			If !EMPTY(ClustSize)
				lcSQL = lcSQL + " SIZE " + LTRIM(STR(ClustSize)) + " K"
			Endif

			Replace ClusterSQL WITH lcSQL
		Endscan
		Select(lnOldArea)

		Return .T.

	Endfunc


	Function CreateClusterKey
		Parameters lcTableName, llDataType

		* Creates the Cluster Key with data types for CreateClustersSQL
		* Creates the Cluster Key list for CreateTablesSQL

		Local aKeyArray, lcClustKey, I
		Dimension aKeyArray[1,4]
		This.GetInfoTableFields(@aKeyArray, lcTableName, .T.)
		lcClustKey = ""

		For m.I = 1 to ALEN(aKeyArray,1)
			lcClustKey = lcClustKey + RTRIM(aKeyArray[m.i, 1])

			If llDataType
				lcClustKey = lcClustKey + " " + RTRIM(aKeyArray[m.i, 2])
				If !EMPTY(aKeyArray[m.i, 3])
					lcClustKey = lcClustKey + "(" + ALLTRIM(STR(aKeyArray[m.i, 3]))
					If !EMPTY(aKeyArray[m.i, 4])
						lcClustKey = lcClustKey + "," + ALLTRIM(STR(aKeyArray[m.i, 4]))
					Endif
					lcClustKey = lcClustKey + ")"
				Endif
			Endif

			lcClustKey = lcClustKey + ", "
		Endfor

		*peel off the extra comma at the end
		lcClustKey = LEFT(lcClustKey, LEN(lcClustKey)-2)
		Return lcClustKey

	Endfunc


	Procedure SendData
		Local lcOldArea, lcEnumTables, lcSprocSQL, lnBigRows, ;
			lnSmallRows,  lnBigBlocks, lnSmallBlocks, lnExportErrors, ;
			ll255, llMaxErrExceeded, lcErrMsg, lcCursorName, lcErrTblName, lcExportType
		
		If !this.DoUpsize OR this.ExportStructureOnly THEN
			Return
		Endif

		lcOldArea=SELECT()
		lcErrMsg=""
		lcEnumTables=this.EnumTablesTbl
		Select (lcEnumTables)

		*Don't send deleted records
		lcDelStatus=SET("DELETED")
		Set DELETED ON

		Scan FOR &lcEnumTables..Export=.T. AND Exported=.T.

			lcExportType = ""  && can resolve to BULKINSERT, FASTEXPORT, or JIMEXPORT
			lcTablePath=&lcEnumTables..TblPath
			lcRmtTableName=RTRIM(&lcEnumTables..RmtTblName)
			lcTableName=RTRIM(&lcEnumTables..TblName)
			lcCursorName=RTRIM(&lcEnumTables..CursName)

			lcEnumFieldsTbl=RTRIM(this.EnumFieldsTbl)
			If this.ServerType="Oracle" THEN
				*this query eliminates long, raw, and long raw data types
				Select COUNT(FldName) FROM  &lcEnumFieldsTbl ;
					WHERE (RmtType="raw" OR RmtType="long") ;
					AND RTRIM(TblName)==lcTableName INTO ARRAY aExportType
				IF !EMPTY(aExportType)
					lcExportType = "JIMEXPORT"
				ENDIF	
			ENDIF
			
			*	Text and image datatypes won't work with BULKINSERT OR FASTEXPORT
			*	(can't pass these as parameters to stored procedures, nor can they 
			*	reside in text files to be used as source of SQL>=7 bulk insert.
			IF EMPTY(lcExportType)
				Select COUNT(FldName) FROM &lcEnumFieldsTbl ;
					WHERE (RmtType="text" OR RmtType="image") ;
					AND RTRIM(TblName)==lcTableName INTO ARRAY aExportType
				IF !EMPTY(aExportType)
					lcExportType = "JIMEXPORT"
				ENDIF
			ENDIF

			IF EMPTY(lcExportType) AND THIS.ServerType#"Oracle" AND THIS.ServerVer>=7
				* jvf Determine if we can use SQL >=7's BULK INSERT function:
				* 	- Can't bulk insert tables with NULL columns of non-character 
				* 		datatype b/c COPY TO loses the null value by creating 
				* 		empty values in the text file (eg, /  /, F).
				Select COUNT(FldName) FROM  &lcEnumFieldsTbl ;
					WHERE (RmtType <> "char" AND lclnull) ;
					AND RTRIM(TblName)==lcTableName INTO ARRAY aExportType		
				IF !EMPTY(aExportType)
					lcExportType = "FASTEXPORT"
				ENDIF
			ENDIF			

			* If survived all conditions above, we can go fast
			IF EMPTY(lcExportType)
				IF this.ServerType#"Oracle" AND THIS.ServerVer>=7
					lcExportType = "BULKINSERT"  && specific to SQL vers >= 7
				ELSE
					lcExportType = "FASTEXPORT"
				ENDIF
			ENDIF

			* If the table has 255 fields, we have to use JimExport
			* Stored procs can only pass 255 parameters and one of them
			* is used for something other than data leaving 254.
			* jvf 1/9/01 SQL >= 7 can handle 1024 SP Parameters. Handled in Case below.
			ll255=(MAX_PARAMS=this.CountFields(lcCursorName))

			Do CASE
			Case lcExportType = "BULKINSERT" AND this.Perm_Database
				* jvf Use SQL 7's BULK INSERT technique
				lnExportErrors=this.BulkInsert(lcTableName, lcCursorName, ;
					lcRmtTableName, @llMaxErrExceeded)
			* jvf SQL >=7 can handle 1024 SP Parameters.
			Case lcExportType = "FASTEXPORT" AND this.Perm_Sproc AND ;
				(!ll255 OR (THIS.ServerType="Oracle" OR THIS.ServerVer<7)) AND !TStampAdd
				*go fast if possible and user can create sprocs
				lnExportErrors=this.FastExport(lcTableName, lcCursorName, lcRmtTableName, @llMaxErrExceeded)
			Otherwise
				lnExportErrors=this.JimExport(lcTableName, lcCursorName, lcRmtTableName, @llMaxErrExceeded)
			Endcase

			If lnExportErrors<>0 THEN
				lcErrorTable=ERR_TBL_PREFIX_LOC + ;
					LEFT(lcTableName,MAX_NAME_LENGTH-LEN(ERR_TBL_PREFIX_LOC))
			Else
				lcErrorTable=""
			Endif

			If llMaxErrExceeded THEN
				lcErrMsg=DEXPORT_FAILED_LOC
				This.StoreError(.NULL.,"","",lcErrMsg,lcTableName,DATA_EXPORT_LOC)
			Else
				If lnExportErrors<>0 THEN
					lcErrMsg=STRTRAN(SOME_ERRS_LOC,"|1",LTRIM(STR(lnExportErrors)))
					This.StoreError(.NULL.,"","",lcErrMsg,lcTableName,DATA_EXPORT_LOC)
				Endif
			Endif

			If this.NormalShutdown=.F.
				Exit
			Endif

			*For report
			Replace &lcEnumTables..DataErrs WITH lnExportErrors, ;
				&lcEnumTables..DataErrMsg WITH lcErrMsg, ;
				&lcEnumTables..ErrTable WITH lcErrorTable

			lnExportErrors=0
			llMaxErrExceeded=.F.
			lcErrMsg=""

		Endscan

		Set DELETED &lcDelStatus
		Select (lcOldArea)

	Endproc


	Function CountFields
		Parameters lcCursorName
		Local lnFldCount, lnOldArea

		lnOldArea=SELECT()
		Select (lcCursorName)
		lnFldCount=AFIELDS(zoo)
		Select (lnOldArea)

		Return lnFldCount

	Endfunc


	Function JimExport
		*Thanks Jim Lewallen for this code (or the important and bug-free parts of it anyway)

		Parameters lcTableName, lcCursorName, lcRmtTableName, llMaxErrExceeded

		Local lnOldArea, lnFieldCount, lcInsertString, lcInsertFinal, llRetVal, lnRecs, ;
			lnRecordsCopied, lcMsg, I, lnExportErrors, lcDataErrTable, lnMaxErrors, ;
			aTblFields, lcSQLErrMsg, lnSQLErrno

		#Define STAGGER_COUNT		5

		*Create array of local field names and their remote equivalents
		lcEnumFields=this.EnumFieldsTbl
		Dimension aTblFields[1]
		Select FldName, RmtFldname FROM (lcEnumFieldsTbl) WHERE RTRIM(TblName)==lcTableName ;
			INTO ARRAY aTblFields

		lnOldArea=SELECT()
		Select (lcCursorName)
		lcRemoteName=this.RemotizeName(lcTableName)

		*Thermometer stuff
		lnRecs=RECCOUNT()
		lnRecordsCopied=0
		This.InitTherm(SEND_DATA_LOC,lnRecs,0)
		lcMsg=STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
		This.UpDateTherm(lnRecordsCopied,lcMsg)

		*Use the remote field name here
		lcInsertString = 'INSERT INTO '+ALLTRIM(lcRmtTableName) + ' ('
		lnFieldCount = ALEN(aTblFields,1)
		For ii = 1 TO lnFieldCount
			lcInsertString = lcInsertString + alltrim(aTblFields[ii,2]) ;
				+ IIF( ii < lnFieldCount, ', ',' )')
		Endfor

		lcInsertString = lcInsertString + ' VALUES ('
		*Use the local field name here
		lcInsertFinal = lcInsertString
		For ii = 1 to lnFieldCount
			Select (lcCursorName)
			lcInsertFinal = lcInsertFinal + RMT_OPERATOR + ALLT(lcCursorName) ;
				+ '.'+ALLT(aTblFields[ii,1]) ;
				+ IIF(ii < lnFieldCount,' , ',' )')
		Endfor

		*Set maximum number of errors allowed so user's disk doesn't fill up if
		*something goes wrong over and over
		lnMaxErrors=lnRecs*DATA_ERR_FRACTION
		If lnMaxErrors<DATA_ERR_MIN THEN
			lnMaxErrors=DATA_ERR_MIN
		Endif

		I=0
		lnExportErrors=0

		*undone: need to set number of inserts per batch

		Scan
			If !this.ExecuteTempSPT(lcInsertFinal,@lnSQLErrno,@lcSQLErrMsg) THEN
				Copy TO ARRAY aErrData NEXT 1
				This.DataExportErr(@aErrData, lcTableName, @lcDataErrTable, lnSQLErrno, lcSQLErrMsg)
				lnExportErrors=lnExportErrors+1
			Endif

			If lnExportErrors>lnMaxErrors THEN
				This.UpDateTherm(lnRecordsCopied,CANCELED_LOC)
				llMaxErrExceeded=.T.
				Exit
			Endif

			If I=STAGGER_COUNT THEN
				lnRecordsCopied=lnRecordsCopied+STAGGER_COUNT
				If lnExportErrors<>0 THEN
					This.UpDateTherm(lnRecordsCopied,lcMsg + ", " + LTRIM(STR(lnExportErrors))+ " " + ERROR_COUNT_LOC)
				Else
					This.UpDateTherm(lnRecordsCopied)
				Endif
				I=1
			Else
				I=I+1
			Endif
		Endscan

		If !llMaxErrExceeded THEN
			This.ThermRef.complete
		Endif

		*Close the errors table if it exists
		If lnExportErrors<>0 THEN
			Select (lcDataErrTable)
			Use
		Endif
		Select (lnOldArea)

		Return lnExportErrors

	Endfunc


	Procedure DataExportErr
		Parameters aErrData, lcTableName, lcDataErrTable, lnSQLErrno, lcSQLErrMsg
		Local lnAlen, lnArrayPos, lnOldArea, lcExact

		*If record(s) is not exported successfully, it's placed in an error table

		lnOldArea=SELECT()

		If EMPTY(lcDataErrTable) THEN
			If !this.DataErrors THEN
				Dimension aDataErrTbls [1,3]
				aDatErrTbls=.F.
				This.DataErrors=.T.
			Else
				Dimension aDataErrTbls [ALEN(aDataErrTbls,1)+1,3]
			Endif
			lnAlen=ALEN(aDataErrTbls,1)
			aDataErrTbls[lnAlen,1]=lcTableName
			lcDataErrTable=this.UniqueTableName(ERRT_LOC + LTRIM(STR(lnAlen)))
			aDataErrTbls[lnAlen,2]=lcDataErrTable

			*Create table with same structure
			Copy STRUCTURE TO &lcDataErrTable
			Select 0
			Use (lcDataErrTable) EXCLUSIVE

			*May not be able to store the error if the table has 255 fields already
			If this.CountFields(lcDataErrTable) < MAX_FIELDS THEN
				aDataErrTbls[lnAlen,3]=.T.		&&this column says whether it's <255 or not
				Alter TABLE (lcDataErrTable) add column SQLErrNo N(10,0)
				Alter TABLE (lcDataErrTable) add column SQLErrMsg M
			Endif
		Else
			Select (lcDataErrTable)
		Endif

		*If a field has numeric overflow condition, can get an error here; ignore it
		This.SetErrorOff=.T.
		Append FROM ARRAY aErrData
		This.SetErrorOff=.F.

		lcExact=SET('EXACT')
		Set EXACT ON
		If aDataErrTbls[ASCAN(aDataErrTbls,lcDataErrTable)+1] THEN
			Replace SQLErrNo with lnSQLErrno, SQLErrMsg with lcSQLErrMsg
		Endif
		Set EXACT &lcExact

		Select (lnOldArea)

		*The data export routine will close the error table, so it's not closed here


	Endproc



	Function FastExport
		Parameters lcTableName, lcCursorName, lcRmtTableName, llMaxErrExceeded
		Local lnBigRows, lnSmallRows, lnBigBlocks, lnSmallBlocks, llTStamp, lnExportErrors

		*
		*This thing creates stored procedures that slam data in batches
		*(i.e. the sproc has multiple insert statements
		*

		*lnBigRows is the number of insert statements to put into the sproc; this
		*depends on how many fields are in the table
		*
		*lnBigBlocks is the number of times to execute the sproc
		*
		*lnSmallRows is basically the number of rows left after the sproc has
		*been executed lnBigBlocks number of times
		*
		*lnSmallBlocks is either 0 (if lnBigRows divides evenly into the number of
		*records in a table) or 1
		*
		lnSmallRows=0
		lnBigBlocks=0
		lnBigRows=0
		lnSmallBlocks=0

		*See if the table has a timestamp field
		*(Note: this proc is getting called from within a SCAN/ENDSCAN so we
		*know we're on the right record already
		llTStamp=TStampAdd

		*Figure out how many rows to send at a time
		This.RowHeuristics(lcCursorName, @lnBigRows, ;
			@lnSmallRows, @lnBigBlocks, @lnSmallBlocks)

		*Create stored procedures that do the inserts
		This.CreateSQLServerSproc(lcTableName,lcRmtTableName, lnBigRows, lnSmallRows, llTStamp)

		*Execute the stored procedures
		lnExportErrors=this.ExecuteSproc(lcTableName, lcCursorName, lcRmtTableName, lnBigBlocks, ;
			lnSmallBlocks, lnBigRows, lnSmallRows, llTStamp, @llMaxErrExceeded)

		Return lnExportErrors

	Endfunc


	Function BulkInsert
		* Assuption: We won't get here if this table has image, text, or non-char nulls 
		* columns. Also assume we are upsizing to SQL 7+.
		Lparameters tcTableName, tcCursorName, tcRmtTableName, tlMaxErrExceeded
		Local lnServerError, lcErrMsg, lcBulkInsertString, lcBulkFileNameWithPath
		
		* See if the table has a timestamp and identity field
		* (Note: this proc is getting called from within a SCAN/ENDSCAN so we
		* know we're on the right record already.

		lnServerError = 0
		lcErrMsg = ""
		lnServerError = 0
		lcBulkFileNameWithPath = SYS(5) + CURDIR() + BULK_INSERT_FILENAME
		If FILE(lcBulkFileNameWithPath)
			Delete FILE (lcBulkFileNameWithPath)
		Endif

		If This.GenBulkInsertTextFile(tcTableName, tcCursorName, lcBulkFileNameWithPath)
			lcBulkInsertString = This.GetBulkInsertString(tcRmtTableName, lcBulkFileNameWithPath)
			* Execute the BULK INSERT into SQL 7 database
			If This.ExecuteTempSPT(lcBulkInsertString, @lnServerError, @lcErrMsg)
				llRetVal = .T.
			Endif
		Endif
		Return lnServerError
	Endfunc

	Function GenBulkInsertTextFile
		* This function generate a text file that will be the source of the BULK INSERT statement
		* The fastest technique is to use COPY TO, and then clean it up to support BULK INSERT.
		* So far, that means removing double quotes and filling in empty dates.
		Lparameters tcTableName, tcCursorName, tcTargetTextFile
		Local lcFieldList, llRetVal, lnOldSele, lcMsg, lnRecordsCopied, lnRecs, lnxx, lnBytes, ;
			lcFileStr, lcEnumTablesTbl, lcCursor, llHasTimeStamp, llHasIdentity
		lnOldSele = Select()

		Select (tcTableName)

		*Thermometer stuff
		lnRecs=RECCOUNT()
		lnRecordsCopied=0
		This.InitTherm(SEND_DATA_LOC,lnRecs,0)
		lcMsg=STRTRAN(THIS_TABLE_LOC,'|1',tcTableName)
		This.UpDateTherm(lnRecordsCopied,lcMsg)

		* If adding timestamp or identity, add additional placeholders (more delimiters)
		* To accomplish this we add additional fields to the source cursor so that COPY TO will
		* automatically add additional placeholders and BULK INSERT will succeed.

		lcEnumTablesTbl = RTRIM(this.EnumTablesTbl)

		lcFieldList = '*'
		If &lcEnumTablesTbl..TStampAdd OR (This.TimeStampAll=1)
			lcFieldList = lcFieldList + ", '' as tstampcol "
			llHasTimeStamp = .T.
		Endif
		If &lcEnumTablesTbl..IdentAdd OR (This.IdentityAll=1)
			lcFieldList = lcFieldList + ", '' as identcol "
			llHasIdentity = .T.
		ENDIF
		
		lcCursor = this.UniqueCursorName(tcCursorName)
		SELECT &lcFieldList From (tcTableName) Into Cursor (lcCursor)
		
		* Create the text file
		COPY TO BULK_INSERT_FILENAME DELIMITED WITH CHARACTER BULK_INSERT_FIELD_DELIMITER
		USE IN (lcCursor)

		* Clean up bulk insert file:
		* - Remove double quotes - BULK INSERT treats them literally
		lcFileStr = StrTran(FileToStr(BULK_INSERT_FILENAME), ["])
		* - COPY TO leaves blank dates as such: /  /, so
		*   make empty dates 01/01/1900 - the SQL 7 default
		lcFileStr = StrTran(lcFileStr, "/  /", SQL_SERVER_EMPTY_DATE_CHAR)
		* 1/6/01 jvf Convert VFP logicals to 0 and 1 for SQL Server.
		* - COPY TO makes VFP logicals as such: F and T, so
		*   make them 0 and 1, resp. for SQL Server
		lcFileStr = this.ConvertVFPLogicalToSQLServerBit(tcTableName, lcFileStr, llHasTimeStamp, llHasIdentity)

		lnBytes = StrToFile(lcFileStr, BULK_INSERT_FILENAME)
		llRetVal = (lnBytes > 0)

		Select (lnOldSele)
		Return llRetVal
	Endfunc

	FUNCTION ConvertVFPLogicalToSQLServerBit
		LParameters tcTableName, lcFileStr, llHasTimeStamp, llHasIdentity
		LOCAL ii, jj, lnLines, lnPos, lcValue, llPosAdj
		lnLines = ALINES(laLines, lcFileStr)
		lnSele = SELECT()
		SELECT (tcTableName)
		llPosAdj = 0
		llPosAdj = llPosAdj + IIF(llHasTimeStamp, 1, 0)
		llPosAdj = llPosAdj + IIF(llHasIdentity, 1, 0)
		FOR ii = 1 to FCOUNT()
			IF (TYPE(FIELD(ii)) = "L")
				FOR jj = 1 to lnLines
					IF jj = 1
						lnPos = AT("~", lcFileStr, (ii-1)*jj)+1
					ELSE
						llNewPosAdj = (llPosAdj + FCOUNT()-1) * (jj-1)
						lnPos = AT("~", lcFileStr, (ii-1+llNewPosAdj))+1
					ENDIF	
					lcValue = SUBSTR(lcFileStr, lnPos, 1)
					lcFileStr = STUFF(lcFileStr, lnPos, 1, IIF(lcValue = "T", "1", "0"))
				ENDFOR
			ENDIF	
		ENDFOR
		SELECT (lnSele)
		RETURN lcFileStr
	ENDFUNC
		
	Function GetBulkInsertString
		* jvf 9/1/99 Build bulk insert string per export table
		* Used COPY TO (textfile) DELI to create source file
		* (while extracting binary and memo fields).
		Lparameters tcRmtTableName, tcSourceTextFile
		lcBulkInsStr = "BULK INSERT " + tcRmtTableName + ;
			" FROM '" + tcSourceTextFile + "' WITH " + ;
			" (FIELDTERMINATOR = '" + [BULK_INSERT_FIELD_DELIMITER] + "', " + ;
			" TABLOCK, KEEPNULLS)"

		Return lcBulkInsStr
	Endfunc

	Procedure CreateSQLServerSproc
		Parameters lcTableName, lcRmtTableName, lnBigRows, lnSmallRows, llTStamp

		Local lcEnumFields, lcSQL, lcParamString, lcInsertString, ;
			lcEnumTables, lcCR, lcLF, lcParamName, lcFieldName, llSmallCondition, ;
			lcType, lcLength, I, ii, j, lcSmallParamString, lcSmallSQL, llRetVal, ;
			lnOldArea, lcAs, lcParamChar, lcDecimals

		#Define SQL_PARAM_CHAR			"@a"
		#Define ORACLE_PARAM_CHAR		"x"
		#Define BIG_PARAM "Big"

		*If the table has no data, don't create the sproc
		If lnBigRows=0 	THEN
			Return
		Endif

		lnOldArea=SELECT()
		lcEnumTables=this.EnumTablesTbl

		lcInsertString=""
		lcParamString=""
		lcCR=CHR(10)
		lcLF=CHR(13)
		lnOldArea=SELECT()

		lcEnumFields=this.EnumFieldsTbl
		Select (lcEnumFields)
		Copy TO ARRAY aFieldNames FIELDS RmtType, RmtLength, RmtPrec FOR RTRIM(TblName)==lcTableName

		lcSQL="CREATE PROCEDURE " + DATA_PROC_NAME

		*Oracle () around the whole parameter string

		If this.ServerType="Oracle" THEN
			*Oracle doesn't allow params to begin with "@"
			lcParamString=" (" + ORACLE_PARAM_CHAR + BIG_PARAM + " CHAR, "
			lcParamChar=ORACLE_PARAM_CHAR
		Else
			*SQL Server requires that params begin with "@"
			lcParamString=" " + SQL_PARAM_CHAR + BIG_PARAM + " char(4), "
			lcParamChar=SQL_PARAM_CHAR
		Endif

		*@Big parameter is used to execute all (for "big" inserts) or part (for "small")
		*inserts) of the insert statements in the sprocs that get created.  This way
		*we don't need two sprocs; all other parameters are for data.  This means
		*we can only send 254 data parameters at a time so this routine only works
		*for tables with 254 or less fields

		j=0
		For I=1 TO lnBigRows

			lcInsertString=lcInsertString + "INSERT INTO " + RTRIM(lcRmtTableName) + ;
				lcCR + "VALUES " + "("

			For ii=1 to ALEN(aFieldNames,1)
				j=j+1
				lcParamName=lcParamChar + LTRIM(STR(j))
				lcType=RTRIM(aFieldNames[ii,1])
				lcLength=LTRIM(STR(aFieldNames[ii,2]))
				lcDecimals = LTRIM(STR(aFieldNames[ii,3]))
				If lcLength="0" OR this.ServerType="Oracle" THEN
					*Note: Oracle parameters take a datatype but no length or precision
					lcLength=""
				Else
					lcLength= "(" + lcLength + IIF(lcDecimals # '0',"," + lcDecimals,"") + ")"
				Endif

				*builds sproc param string like "@a1 char(4), @a2 text, " etc. or
				*"x1 varchar2, x2 number, " etc. for Oracle
				lcParamString=lcParamString + lcParamName + " " + lcType + lcLength + ", "

				*builds list of values for INSERT string like "@1, @2, " etc.
				lcInsertString=lcInsertString  + lcParamName + ", "

			Next ii

			*If column has a timstamp column, add parameter for that
			*IF llTStamp THEN
			*	lcInsertString=lcInsertString + "NULL)" + lcCR +lcLF
			*ELSE
			*otherwise, peel off last comma, add closing paren
			lcInsertString=LEFT(lcInsertString,LEN(lcInsertString)-2)
			*Oracle likes a semicolon after each SQL command
			If this.ServerType="Oracle" THEN
				lcInsertString=lcInsertString  + ");" + lcCR +lcLF
			Else
				lcInsertString=lcInsertString  + ")" + lcCR +lcLF
			Endif
			*ENDIF

			*if the sproc code includes enough row inserts for the "small"
			*insert sproc, tack on code that will skip over the remaining inserts
			If I=lnSmallRows THEN
				lcParamName=lcParamChar + BIG_PARAM
				lcInsertString=lcInsertString  + "IF " + lcParamName + " = " + ;
					"'" + "TRUE" + "'" + lcCR + lcLF
				If this.ServerType="Oracle" THEN
					lcInsertString=lcInsertString  + "THEN" + lcCR
				Else
					lcInsertString=lcInsertString  + "BEGIN" + lcCR
				Endif
				llSmallCondition=.T.
			Endif

		Next I

		*peel off last comma, put whole string together
		lcParamString=LEFT(lcParamString,LEN(lcParamString)-2)

		If this.ServerType="Oracle" THEN
			*Add closing paren, BEGIN statement
			lcParamString=lcParamString + ")"
			Lcas= " AS BEGIN"
		Else
			Lcas= " AS "
		Endif

		lcSQL=lcSQL + lcParamString + lcAs + lcCR + lcLF + lcInsertString
		If llSmallCondition OR this.ServerType="Oracle" THEN
			If this.ServerType="Oracle" THEN
				*The Oracle IF..THEN construct requires an "END IF"
				If llSmallCondition THEN
					lcSQL=lcSQL + "END IF;" + lcCR + lcLF
				Endif
				*Oracle sprocs have to be ended explicitly
				lcSQL=lcSQL + "END " + DATA_PROC_NAME + ";"
			Else
				lcSQL=lcSQL + "END"
			Endif
		Endif

		*drop any existing sproc
		=this.ExecuteTempSPT("drop procedure " + DATA_PROC_NAME)

		*Create the stored procedure
		llRetVal=this.ExecuteTempSPT(lcSQL)

		Select (lnOldArea)

	Endproc


	Procedure RowHeuristics
		Parameters lcCursorName, lnBigRows, lnSmallRows,  lnBigBlocks, lnSmallBlocks
		Local lnReccount, lnFieldCount, lnTotalParams, lnOldArea

		*Figures out how many rows stored procedures should insert at a time

		lnOldArea=SELECT()
		Select (lcCursorName)

		*used to be lnRecCount=reccount() but that counts deleted records too
		Select count(*) from (lcTableName) where !deleted() into array aReccount
		lnReccount=aReccount
		lnFieldCount=AFIELDS(aTemp)
		lnTotalParams=aReccount*lnFieldCount
		Select (lnOldArea)

		If lnTotalParams<=MAX_PARAMS THEN
			If lnReccount<=MAX_ROWS
				lnBigRows=lnReccount
				lnBigBlocks=1
				lnSmallRows=0
				lnSmallBlocks=0
			Else
				lnBigRows=MAX_ROWS
				lnBigBlocks=1
				lnSmallRows=lnReccount-MAX_ROWS
				lnSmallBlocks=1
			Endif
		Else
			If INT(MAX_PARAMS/lnFieldCount)> MAX_ROWS
				lnBigRows=MAX_ROWS
				lnBigBlocks=INT(lnReccount/lnBigRows)
				lnSmallRows=lnReccount-(lnBigBlocks*lnBigRows)
				lnSmallBlocks=1
			Else
				lnBigRows=INT(MAX_PARAMS/lnFieldCount)
				lnBigBlocks=INT(lnReccount/lnBigRows)
				lnSmallRows=lnReccount-(lnBigBlocks*lnBigRows)
				lnSmallBlocks=1
			Endif
		Endif

	Endproc


	Function ExecuteSproc
		Parameters lcTableName, lcCursorName, lcRmtTableName, lnBigBlocks, lnSmallBlocks, ;
			lnBigRows, lnSmallRows, llTStamp, llMaxErrExceeded

		Local lnOldArea, lnNumberOfFields, lnLoopMax, lnRecs, lcMsg, ;
			lcNumberofRows, lcArrayType, llRetVal, lcLoopLimiter, lnRowsToCopy, ;
			lnRecordsCopied, lcSQL, lnExportErrors, lcDataErrTable, lnMaxErrors, ;
			llBail, lcData, lnSQLErrno, lcSQLErrMsg, I, ii

		Private aBigArray, aSmallArray

		*If the table has no data, bail
		If lnBigRows=0 THEN
			Return 0
		Endif

		lnOldArea=SELECT()
		Select (lcCursorName)
		Go TOP

		lnNumberOfFields=AFIELDS(aTemp)

		*Thermometer stuff
		lnRecs=RECCOUNT()
		lnRecordsCopied=0
		This.InitTherm(SEND_DATA_LOC,lnRecs,0)
		lcMsg=STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
		This.UpDateTherm(lnRecordsCopied,lcMsg)

		*Set maximum number of errors allowed so user's disk doesn't fill up if
		*something goes wrong over and over
		lnMaxErrors=lnRecs*DATA_ERR_FRACTION
		If lnMaxErrors<DATA_ERR_MIN THEN
			lnMaxErrors=DATA_ERR_MIN
		Endif
		lnExportErrors=0

		Dimension aBigArray[lnBigRows,lnNumberOfFields]

		lcArrayType="aBigArray"
		lcNumberofRows="lnBigRows"

		*Create big strings that look like this:
		*:aBigArray[1,1],:aBigArray[1,2],:aBigArray[1,3],:aBigArray[1,4]

		lcData=""
		For I=1 TO &lcNumberofRows
			For ii=1 TO lnNumberOfFields
				If !lcData=="" THEN
					lcData=lcData + " , "
				Endif
				lcData=lcData+ RMT_OPERATOR + "&lcArrayType[" + LTRIM(STR(I)) + "," + ;
					LTRIM(STR(ii)) + "]"
			Next ii
		Next I

		*Set variables for first pass through loop
		lcArrayType="aBigArray"
		lcLoopLimiter="lnBigBlocks"
		lnRowsToCopy=lnBigRows
		lnRecordsCopied=1
		lcBigInsert="TRUE"		&&determines if all inserts in sproc are executed

		For I=1 TO IIF(lnSmallRows=0,1,2)
			*In case massive data export errors occurred
			If lnExportErrors>lnMaxErrors THEN
				This.UpDateTherm(lnRecordsCopied,CANCELED_LOC)
				llMaxErrExceeded=.T.
				Exit FOR
			Endif

			*Build the array string
			If this.ServerType="Oracle" THEN
				lcSQL="BEGIN " + DATA_PROC_NAME + " (" + "'" + lcBigInsert + "'" + ;
					", " + lcData+ 	"); END;"
			Else
				lcSQL="EXECUTE " + DATA_PROC_NAME + "'" + lcBigInsert + "' " + ;
					", " + lcData
			Endif

			*Fill it and send it
			For ii= 1 TO &lcLoopLimiter

				*get a load of data
				Copy TO ARRAY &lcArrayType NEXT lnRowsToCopy
				Skip

				*send it to the server
				If !this.ExecuteTempSPT(lcSQL, @lnSQLErrno, @lcSQLErrMsg) THEN
					Skip -1*lnRowsToCopy
					Copy TO ARRAY aDatErr NEXT lnRowsToCopy
					Skip
					This.DataExportErr(@aDatErr, lcTableName, @lcDataErrTable, lnSQLErrno, lcSQLErrMsg)
					lnExportErrors=lnExportErrors+lnRowsToCopy

				Endif

				*Thermometer
				lnRecordsCopied=lnRecordsCopied+lnRowsToCopy

				*If massive export errors, bail
				If lnExportErrors>lnMaxErrors THEN
					This.UpDateTherm(lnRecordsCopied,CANCELED_LOC)
					llMaxErrExceeded=.T.
					Exit FOR
				Endif

				If lnExportErrors<>0 THEN
					This.UpDateTherm(lnRecordsCopied,lcMsg + ", " + LTRIM(STR(lnExportErrors))+ " " + ERROR_COUNT_LOC)
				Else
					This.UpDateTherm(lnRecordsCopied)
				Endif

			Next ii

			*if there are leftover rows after the "big" copies, do the inner loop again with
			*the smaller array
			*lcArrayType="aSmallArray"
			*The extra parameters not used in the small insert are set to null here

			aBigArray=.NULL.
			lcLoopLimiter="lnSmallBlocks"
			lnRowsToCopy=lnSmallRows
			This.BitifyArray(lcTableName, lnSmallRows)
			lcBigInsert="FALS"		&&only takes four characters

		Next I

		*If export errors occurred, close the error table
		If lnExportErrors<>0 THEN
			Select (lcDataErrTable)
			Use
		Endif

		If !llMaxErrExceeded THEN
			This.ThermRef.complete
		Endif

		*drop the stored procedure
		lcSQL="DROP PROCEDURE rwf_insert_"
		llRetVal=this.ExecuteTempSPT(lcSQL)

		Select (lnOldArea)

		Return lnExportErrors

	Endfunc

	Procedure BitifyArray
		Parameters lcTableName, lnRowsToCopy
		Local lnOldArea, lcEnumTablesTbl, lnOldRecno, I, j

		*When ExecuteSproc does the "small" insert, the extra (empty) rows in
		*the array sent to the server have to be acceptable as parameters.
		*Null is fine for everything but bit fields
		lnOldArea=SELECT()

		*Grab the sql (table definition) of the table
		lcEnumTablesTbl=this.EnumTablesTbl
		Select (lcEnumTablesTbl)
		lnOldRecno=RECNO()
		Locate FOR LOWER(RTRIM(TblName))==LOWER(RTRIM(lcTableName))
		lcSQL=TableSQL

		*Parse it looking for bit fields
		lcSQL=SUBSTR(lcSQL,AT("(",lcSQL))

		* jvf 2/4/01 Bug ID 192139 - subscipt outside defined range on: aBigArray[j,i]=.F.
		* Add space(1) after comma as search string to differentiate
		* field separator vs. numeric column struc with precision (eg, numeric(8,2)). 
		lcSQL=STUFF(lcSQL,RAT(")",lcSQL),1,", ")
		I=1
		Do WHILE ", " $ lcSQL
			lcSubStr=LEFT(lcSQL,AT(", ",lcSQL))
			If " bit " $ lcSubStr
				For j=lnRowsToCopy +1 TO ALEN(aBigArray,1)
					aBigArray[j,i]=.F.
				Next j
			Endif

			* jvf 2/04/01
			* Money wouldn't upsize in FastExport for same reason bit don't.
			* Added this extra loop to prefill array with 0.00 instead of null
			* for money columns.
			If " money " $ lcSubStr
				For j=lnRowsToCopy +1 TO ALEN(aBigArray,1)
					aBigArray[j,i]=0.00
				Next j
			Endif

			lcSQL=SUBSTR(lcSQL,AT(", ",lcSQL)+1)
			I=I+1
		Enddo

		Go lnOldRecno
		Select (lnOldArea)

	Endproc


	Procedure CreateIndexes
		Local lnOldArea, lcEnum_Indexes, lcSQL, lcScanCondition, I, lnError, ;
			llRetVal, lcClusterName, lnLoopLimiter, lnIndexCount, lcDel, lcErrMsg, ;
			lcTagName, llTableUpsized, lnOldTO

		lnOldArea=SELECT()
		This.InitTherm(STARTING_COMMENT_LOC,0,0)

		*Generate all the sql for the indexes
		This.BuildIndexSQL

		*Create the indexes
		If this.DoUpsize AND this.Perm_Index  THEN
			*Make sure we don't create indexes with logical/bit fields
			If this.ServerType<>"Oracle" THEN
				This.MarkBitIndexes
			Endif

			lcEnum_Indexes=this.EnumIndexesTbl
			Select (lcEnum_Indexes)

			*Create indexes on tables (clustered indexes first, otherwise existing
			*indexes automatically are regenerated)

			If this.ServerType="Oracle" THEN
				lcScanCondition="DontCreate=.F. AND Exported=.F."
				lnLoopLimiter=1
			Else
				lcScanCondition="Clustered=.T. AND DontCreate=.F. AND Exported=.F."
				lnLoopLimiter=2
			Endif

			*note: if the user selected a table for export, moved ahead a few
			*pages causing the indexes to be analyzed, then deselected that table,
			*then the thermometer reading won't be right--just means that it will
			*jump up fast when some indexes are skipped
			Select COUNT(*) FROM (lcEnum_Indexes) WHERE DontCreate=.F. ;
				AND Exported=.F. INTO ARRAY aIndexCount
			lnIndexCount=0
			This.InitTherm(STARTING_COMMENT_LOC,aIndexCount,0)

			*Never timeout
			lnOldTO=SQLGETPROP(this.MasterConnHand,"QueryTimeOut")
			=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",0)

			For I=1 to lnLoopLimiter
				Scan FOR &lcScanCondition
					*Make sure table was upsized
					lcTableName=RTRIM(&lcEnum_Indexes..IndexName)
					lcErrMsg=""

					If this.TableUpsized(lcTableName, @llTableUpsized) THEN
						*for thermometer
						lcMsg=STRTRAN(THIS_TABLE_LOC,"|1",lcTableName)
						This.UpDateTherm(lnIndexCount,lcMsg)
						lcSQL=&lcEnum_Indexes..IndexSQL

						llRetVal=this.ExecuteTempSPT(lcSQL,@lnError,@lcErrMsg)

						If !llRetVal THEN
							Replace &lcEnum_Indexes..IdxErrNo WITH lnError
							lcTagName=&lcEnum_Indexes..TagName
							This.StoreError(lnError,lcErrMsg,lcSQL,INDEX_FAILED_LOC,lcTagName,INDEX_LOC)
						Endif
					Else
						llRetVal=.F.
						lcErrMsg=TABLE_NOT_EXPORTED_LOC
					Endif
					Replace &lcEnum_Indexes..Exported WITH llRetVal, ;
						&lcEnum_Indexes..IdxError WITH lcErrMsg, ;
						&lcEnum_Indexes..TblUpszd WITH llTableUpsized

					lnIndexCount=lnIndexCount+1
					This.UpDateTherm(lnIndexCount)
				Endscan
				lcScanCondition="Clustered=.F. AND DontCreate=.F. AND Exported=.F."
			Next

			*Put this back
			If TYPE('lnOldTO') = 'N' AND lnOldTO >= 0
				=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",lnOldTO)
			Endif

			This.ThermRef.Complete
		Endif

		Select (lnOldArea)

	Endproc


	Procedure MarkBitIndexes
		Local lcEnumIndexesTbl, lcEnumFieldsTbl, aLogicals, lnOldArea, llDontCreate, ;
			lcTableName

		*
		*Marks indexes that have logical fields in them as un-createable
		*

		lcEnumFieldsTbl=this.EnumFieldsTbl
		lcEnumIndexesTbl=this.EnumIndexesTbl

		lnOldArea=SELECT()
		Select (lcEnumIndexesTbl)
		Scan
			lcTableName=RTRIM(IndexName)
			*Find out which (if any) fields in the table are logical fields
			Dimension aLogicals[1]
			aLogicals=.F.
			Select RmtFldname FROM (lcEnumFieldsTbl) WHERE RTRIM(TblName)==lcTableName AND ;
				DataType="L" INTO ARRAY aLogicals
			llDontCreate=.F.

			*See if any of the logical fields are part of the index expression
			If !EMPTY(aLogicals) THEN
				For jj=1 to ALEN(aLogicals,1)
					If RTRIM(aLogicals[jj]) $ &lcEnumIndexesTbl..RmtExpr THEN
						llDontCreate=.T.
						Exit
					Endif
				Next jj
			Endif

			If llDontCreate THEN
				lcMsg=CANT_CREATE_INDEX_LOC
			Else
				lcMsg=""
			Endif

			Replace DontCreate WITH llDontCreate, IdxError with lcMsg

		Endscan

		Select (lnOldArea)

	Endproc


	Function TableUpsized
		Parameters lcTableName, llChosenForExport
		Local lcEnumTablesTbl, lnOldArea, llExport

		*Returns whether a table was actually created on the server successfully or not
		*If the user is generating a script but not upsizing, then the function
		*returns whether the table was selected for upsizing

		lnOldArea=SELECT()
		lcEnumTablesTbl=RTRIM(this.EnumTablesTbl)
		Select (lcEnumTablesTbl)
		Locate FOR TblName=lcTableName
		If this.DoUpsize THEN
			llExport=&lcEnumTablesTbl..Exported
		Else
			llExport=&lcEnumTablesTbl..Export
		Endif
		llChosenForExport=&lcEnumTablesTbl..Export
		Select (lnOldArea)
		Return llExport

	Endfunc


	Procedure AnalyzeIndexes
		Local lnOldArea, lcEnum_Tables, lcEnum_Indexes, I, ii, lcExprLeftover, ;
			lcTablePath, lcEnum_Fields, lcExpression, lcTagName, lcRemoteExpression, lcRemoteTagName, ;
			lcSQL, lcRemoteTable, lcClustered, llUserTableOpened, lcTableName, lcMsg, llCreateIndexes, ;
			aKeyFields, llDontCreate, lcErrMsg, lcLclIdxType

		*Don't do this routine if not necessary
		If this.ProcessingOutput THEN
			If  !this.ExportIndexes AND ;
					!this.ExportRelations AND ;
					!this.ExportTableToView AND ;
					!this.ExportViewToRmt THEN
				Return
			Endif
		Endif

		lnOldArea=SELECT()
		lcEnum_Fields=this.EnumFieldsTbl
		lcEnum_Tables=this.EnumTablesTbl
		Select COUNT(*) FROM (lcEnum_Tables) WHERE Export=.T. AND EMPTY(ClustName)=.T. ;
			AND CDXAnald=.F. INTO ARRAY aTableCount

		*Thermometer stuff
		If aTableCount=0 THEN
			Return
		Endif
		lnTableCount=0
		If this.ProcessingOutput
			lcMsg=STRTRAN(ANALYZING_INDEXES_LOC,"...")
			This.InitTherm(lcMsg,aTableCount,0)
		Else
			Wait ANALYZING_INDEXES_LOC WINDOW NOWAIT
		Endif

		*Create table to hold index names and expressions
		If RTRIM(this.EnumIndexesTbl)==""
			lcEnum_Indexes=this.CreateWzTable("Indexes")
			This.EnumIndexesTbl=lcEnum_Indexes
			llCreateIndexes=.T.
		Else
			lcEnum_Indexes=this.EnumIndexesTbl
			llCreateIndexes=.F.
		Endif

		*read tables-to-be-exported one at a time and see if they have .CDXs
		Select (lcEnum_Tables)

		Scan FOR Export=.T. AND CDXAnald=.F. AND EMPTY(ClustName)=.T.
			lcCursorName=RTRIM(&lcEnum_Tables..CursName)
			lcTableName=RTRIM(&lcEnum_Tables..TblName)
			lcRemoteTable=RTRIM(&lcEnum_Tables..RmtTblName)
			lcTablePath=RTRIM(&lcEnum_Tables..TblPath)

			*Therm stuff
			lcMsg=STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
			This.UpDateTherm(lnTableCount,lcMsg)
			lnTableCount=lnTableCount+1

			*Read information for each tag

			Select (lcCursorName)
			For I=1 to TAGCOUNT(STRTRAN(lcTablePath,".DBF",".CDX"))
				lcRemoteExpression=""
				lcClustered=.F.
				lcExpression=LOWER(SYS(14,I))		&&tag expression
				lcTagName=TAG(I,lcCursorName)		&&tag name

				*Figure out index type
				Do CASE
				Case PRIMARY(I)
					lcLclIdxType="Primary key"
					If this.ServerType="Oracle" OR this.ServerType=="SQL Server95" THEN
						lcTagType="PRIMARY KEY"
						If this.ServerType="Oracle" THEN
							lcClustered=.F.
						Else
							lcClustered=.T.
						Endif
					Else
						lcTagType="UNIQUE CLUSTERED"
						lcClustered=.T.
					Endif
				Case CANDIDATE(I)
					lcLclIdxType="Candidate"
					*same for both Oracle and SQL Server
					lcTagType="UNIQUE"
				Otherwise
					If UNIQUE() THEN
						lcLclIdxType="Unique"
					Else
						lcLclIdxType="Regular"
					Endif
					*if UNIQUE() or just a regular index
					lcTagType=""
				Endcase

				*pull the field names out of each expression into comma separated list
				lcRemoteExpression=this.ExtractFieldNames(lcExpression,lcTableName)
				Dimension aKeyFields[1]
				aKeyFields=.F.
				This.KeyArray(lcRemoteExpression, @aKeyFields)
				If ALEN(aKeyFields,1)>MAX_INDEX_FIELDS THEN
					llDontCreate=.T.
					lcErrMsg=TOO_MANY_FIELDS_LOC
				Else
					llDontCreate=.F.
					lcErrMsg=""
				Endif

				*Write info into index analysis table
				Select (lcEnum_Indexes)
				Append BLANK
				Replace IndexName WITH lcTableName, ;
					TagName WITH LOWER(lcTagName), ;
					LclExpr WITH lcExpression, 	;
					LclIdxType WITH lcLclIdxType, ;
					RmtExpr WITH lcRemoteExpression, ;
					RmtName WITH LOWER(this.RemotizeName(lcTagName)), ;
					RmtType WITH lcTagType, ;
					Clustered WITH lcClustered, ;
					RmtTable WITH lcRemoteTable, ;
					Exported WITH .F., ;
					DontCreate WITH llDontCreate,;
					IdxError WITH lcErrMsg

				*Fox will let you have multiple "primary keys" on a table.  Oracle and SQL 95
				*declarative RI won't.  Consequently, the wizard needs to be
				*sure that the primary key on a table is the one used
				*for RI; the other "primary keys" can just be regular indexes.

				*Here the pkey expression gets stored for comparison later
				If lcTagType="PRIMARY KEY" THEN
					Select (lcEnum_Tables)
					Replace PkeyExpr WITH lcRemoteExpression, ;
						PKTagName WITH lcTagName
				Endif

				Select (lcCursorName)

			Next I

			Select (lcEnum_Tables)
			Replace CDXAnald WITH .T.

		Endscan

		Select (lcEnum_Indexes)
		Select (lnOldArea)
		This.AnalyzeIndexesRecalc=.F.

		If this.ProcessingOutput
			This.ThermRef.Complete
		Else
			Wait CLEAR
		Endif

	Endproc


	Procedure BuildIndexSQL
		Local lcEnum_Indexes, lcSQL, lcRmtTable, lcRmtIdxName, lcRmtType, lcConstraint, lcTSClause, lcClustered

		*Build the CREATE INDEX sql string
		lcEnum_Indexes = this.EnumIndexesTbl
		Select (lcEnum_Indexes)

		Scan FOR Exported=.F.
			*Get remote table name
			lcRmtTable = LEFT(this.RemotizeName(RTRIM(&lcEnum_Indexes..IndexName)),30)
			lcRmtType = TRIM(&lcEnum_Indexes..RmtType)
			lcRmtExpr = TRIM(&lcEnum_Indexes..RmtExpr)
			lcRmtName = TRIM(&lcEnum_Indexes..RmtName)
			If this.ServerType = ORACLE_SERVER
				lcRmtName = this.UniqueOraName(lcRmtName)
			Endif

			*check index type; deal with Oracle and Primary differently
			If lcRmtType = "PRIMARY KEY" OR ;
					(lcRmtType = "UNIQUE" AND this.ServerType = "Oracle") ;
					OR (lcRmtType = "UNIQUE" AND this.ServerType == "SQL Server95") THEN

				* Oracle and SQL95 Unique and Primary Key indexes implemented via ALTER TABLE
				If this.ServerType = ORACLE_SERVER
					lcTSClause = IIF(!empty(this.TSIndexTSName), " USING INDEX TABLESPACE " + this.TSIndexTSName, "")
					lcSQL = "ALTER TABLE " + lcRmtTable + " ADD (CONSTRAINT " + lcRmtName + ;
						" " + lcRmtType + " (" + lcRmtExpr + ")" + lcTSClause + ")"
				Else
					* jvf 08/13/99
					* Use this convention for unique db objects...
					* PRIMARY KEY: "PK_" + lcRmtName,3
					* CANDIDATE KEYS: "UQ_" + lcRmtName

					* ## Add NONCLUSTERED clause when creating a PRIMARY KEY b/c SS
					* defaults to CLUSTERED INDEX.
					lcClustered = " NONCLUSTERED "
					If lcRmtType = "UNIQUE"
						* Can have multiple, so get unique name
						lcRmtName = "UQ_" + this.UniqueTableName(lcRmtTable)
					Else &&Primary Key
						lcRmtName = "PK_" + lcRmtTable
						If !EMPTY(this.ExportClustered)
							lcClustered = " CLUSTERED "
						Endif
					Endif
					lcSQL = "ALTER TABLE " + lcRmtTable + " ADD CONSTRAINT " + lcRmtName + ;
						" " + lcRmtType + lcClustered + "(" + lcRmtExpr + ")"
					*!*End Mark
				Endif
			Else
				* All other index types (including regular Oracle indexes) are handled here
				lcSQL = "CREATE " + lcRmtType + " INDEX " + lcRmtName + " ON " + lcRmtTable + " (" + lcRmtExpr + ")"
				If this.ServerType = ORACLE_SERVER
					lcTSClause = IIF(!empty(this.TSIndexTSName), " TABLESPACE " + this.TSIndexTSName, "")
					lcSQL = lcSQL + lcTSClause
				Endif
			Endif

			Replace &lcEnum_Indexes..IndexSQL WITH lcSQL, &lcEnum_Indexes..RmtName WITH lcRmtName
		Endscan
	Endproc


	Function DeviceMania
		*Method that calls a bunch of other engine methods

		*Tell user what's happening
		lcMsg=STRTRAN(GETTING_INFO_LOC,"|1",RTRIM(this.DataSourceName))
		Wait lcMsg WINDOW NOWAIT

		If this.NewDir=="" THEN
			This.CreateNewDir
		Endif

		llGotDevices=this.GetDevices()
		llGotDevNumbs=this.GetDeviceNumbers()
		llGotSvrSpace=this.GetServerSpace()
		This.DeviceRecalc=.F.

		Wait CLEAR
		Return llGotDevices AND llGotDevNumbs AND llGotSvrSpace

	Endfunc


	Function GetDevices
		Local lcSQL, lcDeviceTable, lnDefaultFreeSpace, lnDefaultSize, lnOldArea, lcMsg

		*This query returns device information for devices that have databases on them
		lcSQL = "SELECT D.name, D.status,"
		lcSQL = lcSQL + "'Size' = (1+ D.high - D.low) /512, "
		lcSQL = lcSQL + "'Used' = sum(U.size )/ 512, "
		lcSQL = lcSQL + "'Free' = ((1 + D.high - D.low) - sum(U.size))/ 512 "
		lcSQL = lcSQL + "FROM master..sysusages U, master..sysdevices D "
		lcSQL = lcSQL + "WHERE D.cntrltype = 0 AND U.vstart between D.low and D.high "
		lcSQL = lcSQL + "GROUP BY D.name, D.high, D.low, D.status "
		lcSQL = lcSQL + "UNION "
		lcSQL = lcSQL + "SELECT D.name, D.status, "
		lcSQL = lcSQL + "'Size' = (1+ D.high - D.low) /512, "
		lcSQL = lcSQL + "'Used' = 0, "
		lcSQL = lcSQL + "'Free' = (1+ D.high - D.low) /512 "
		lcSQL = lcSQL + "FROM master..sysdevices D WHERE D.cntrltype = 0 "
		lcSQL = lcSQL + "AND D.name not in (SELECT D.name "
		lcSQL = lcSQL + "FROM master..sysusages U, master..sysdevices D "
		lcSQL = lcSQL + "WHERE D.cntrltype = 0 AND U.vstart between D.low and D.high) "
		lcSQL = lcSQL + "GROUP BY D.name, D.high, D.low, D.status"

		*run the query and create a table of devices with the results
		lnOldArea=SELECT()
		Select 0
		If !this.ExecuteTempSPT(lcSQL) THEN
			OWizard.Die
		Endif
		This.DeviceTable=this.UniqueTableName("Devices")
		lcDeviceTable=this.DeviceTable
		Copy TO &lcDeviceTable
		Use &lcDeviceTable EXCLUSIVE
		Alter TABLE &lcDeviceTable add column DvcNumber N(10,0)
		Alter TABLE &lcDeviceTable add column Default L
		Use
		Use &lcDeviceTable SHARED

		*
		*See if there are any default devices on the server and add a device called "Default" if so
		*

		lnDefaultFreeSpace=0
		lnDefaultSize=0
		Scan
			If (status - 1) % 2 = 0 THEN
				lnDefaultFreeSpace = lnDefaultFreeSpace + &lcDeviceTable..Free
				lnDefaultSize = lnDefaultSize + &lcDeviceTable..Size
				Replace Default WITH .T.
			Endif
		Endscan

		*Used by Device class in the DefaultThingOK method
		This.DefaultFreeSpace=lnDefaultFreeSpace

		If lnDefaultSize<>0 THEN
			Append BLANK
			Replace NAME WITH DEFAULT_LOC, size with lnDefaultSize, Free with lnDefaultFreeSpace
		Endif

		*
		*add a token for creating new devices
		*

		Append BLANK
		Replace NAME WITH NEW_DEVICE_TOKEN_LOC

		Index ON name tag name
		Set ORDER TO name
		Select (lnOldArea)

		Return .T.

	Endfunc


	Function GetDeviceNumbers
		Local lcSQL, llRetVal, lnOldArea, lcCursor, lnErr, lcMsg

		*this query results in an array that's dimensioned to the number of
		*devices allowed on the server

		lnOldArea=SELECT()
		Select 0
		lcCursor=this.UniqueCursorName("DNumbers")
		If this.ServerType=="SQL Server" THEN
			lcSQL="sp_configure devices"
			If !this.ExecuteTempSPT(lcSQL,@lnErr, @lcMsg,lcCursor) THEN
				Return .F.
			Endif
			*SQL Server device numbers start at 0, so the array should be one less
			*than the "run value" for devices allowed
			Dimension aDeviceNumbers(&lcCursor..run_value-1)
			This.DeviceNumbersFree=&lcCursor..run_value-1
		Else
			*SQL '95 supports 256 devices
			Dimension aDeviceNumbers(256)
			This.DeviceNumbersFree=256
		Endif

		lcSQL="sp_helpdevice"
		If !this.ExecuteTempSPT(lcSQL,@lnErr, @lcMsg,lcCursor) THEN
			Return .F.
		Endif
		Local laTemp(reccount(),2)
		Copy TO ARRAY laTemp fields device_number

		*If a device number is free, its place in the array will be .F.
		For I=1 TO alen(laTemp,1)
			If laTemp(I,1)<>0 THEN
				aDeviceNumbers(laTemp(I,1))=.T.
				This.DeviceNumbersFree=this.DeviceNumbersFree-1
			Endif
		Next
		Use
		Select (lnOldArea)
		Return .T.

	Endfunc


	Function GetServerSpace
		Local lcSQL, lnRet, lcTemp, lnServerSpace, I, lcNewString, lnOldArea, ;
			lnChar, lcChar, lcSQT

		*If the user isn't 'sa' then this function won't work, so bail
		If !this.Perm_Device THEN
			Return
		Endif
		lcSQT=CHR(39)
		lnOldArea=SELECT()
		Select 0
		*store the directory where the master database is found to a variable
		lcSQL = "select phyname from sysdevices where name =  'master'"
		If !this.ExecuteTempSPT(lcSQL) THEN
			Return .F.
		Endif
		lcTemp=Phyname

		*then find out how much space is on the drive where the master database is
		lcSQL = "xp_cmdshell " + lcSQT + "dir "+ lcTemp + lcSQT
		If !this.ExecuteTempSPT(lcSQL) THEN
			Return .F.
		Endif

		Skip 7
		lcTemp = ALLTRIM(output)
		*remove non-numeric characters
		lcNewString=""
		For I = 1 TO Len(lcTemp)
			lcChar=SUBSTR(lcTemp, I, 1)
			lnChar=ASC(lcChar)
			If lnChar > 47 AND lnChar <58  THEN
				lcNewString = lcNewString + lcChar
			Endif
		Next
		Use
		This.ServerFreeSpace = VAL(lcNewString) / 1000000	&&in megabytes

		Select (lnOldArea)

	Endproc


	Function CreateDevice
		Parameters lcDeviceType, lcDevicePhysName,lnDeviceNumber

		Local lcDeviceLogicalName, lcSQL1, lcSQL2, lcSQL3, I, lnRetVal, ;
			lcRoot, lcMasterPath, lnServerErr, lnUserChoice,lcErrMsg, ;
			lcDevicePhysPath, lcSQT

		lcSQT=CHR(39)
		*Fill local variables from global
		If lcDeviceType="Log" THEN
			*If the log and database names are the same, bail
			If this.DeviceLogName=this.DeviceDBName THEN
				Return
			Endif
			*Put up thermometer
			This.InitTherm(CREATING_LOGDEVICE_LOC,0,0)
			lcDeviceLogicalName=RTRIM(this.DeviceLogName)
			lnDeviceSize=this.DeviceLogSize
		Else
			*Put up thermometer
			This.InitTherm(CREATING_DBDEVICE_LOC,0,0)
			lcDeviceLogicalName=RTRIM(this.DeviceDBName)
			lnDeviceSize=this.DeviceDBSize
		Endif
		This.UpDateTherm(0,TAKES_AWHILE_LOC)

		*convert from megabytes to 2k pages
		lnDeviceSize=lnDeviceSize*512

		* Build path for physical device based on location of Master database
		If this.MasterPath=="" THEN
			lcMasterPath=""
			lcSQL = "select phyname from sysdevices where name = " + lcSQT + "master" + lcSQT
			lnRetVal = this.SingleValueSPT(lcSQL, @lcMasterPath, "phyname")
			This.MasterPath=RTRIM(lcMasterPath)
		Endif
		lcDevicePhysPath = this.JustPath(this.MasterPath)+ "\"

		*Build device physical name
		lcRoot = LEFT(lcDeviceLogicalName,6)
		lcDevicePhysName = lcDevicePhysPath + lcRoot + ".DAT"

		*Get a device number and mark it as taken
		lnDeviceNumber=ASCAN(aDeviceNumbers,.F.)
		aDeviceNumbers[lnDeviceNumber]=.T.

		*Build sql string
		lcSQL1 = "disk init name=" + lcSQT+ lcDeviceLogicalName + lcSQT+ ", "
		lcSQL2 = "physname=" + lcSQT+ lcDevicePhysName + lcSQT+ ", "
		lcSQL3 = "vdevno=" + ALLTRIM(Str(lnDeviceNumber)) + ", "
		lcSQL3 = lcSQL3 + "size=" + ALLTRIM(Str(lnDeviceSize))
		lcSQL = lcSQL1 + lcSQL2 + lcSQL3

		*
		* Create device, incrementing physical name if already taken
		* Since error SQS_ERR_DISK_INIT_FAIL can result from other problems, only try 20 times
		*

		If this.DoUpsize THEN
			*Set query time out to huge value while this is running
			=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",600)

			lnServerErr = 0
			lcErrMsg = ""

			*- if problems creating devices ("DISK command not allowed within multi-statement transactions"),
			*- uncomment this line
			*- this.ExecuteTempSPT("COMMIT TRANSACTION",@lnServerErr,@lcErrMsg)

			*Try 20 times because physical name may be taken
			For I=1 to 20
				lnServerErr=0
				If !this.ExecuteTempSPT(lcSQL,@lnServerErr,@lcErrMsg) THEN
					lcDevicePhysName = lcDevicePhysPath + lcRoot + ALLTRIM(Str(I)) + ".DAT"
					lcSQL2 = "physname=" + lcSQT + lcDevicePhysName + lcSQT+ ", "
					lcSQL = lcSQL1 + lcSQL2 + lcSQL3
				Else
					Exit
				Endif
			Next
			*If the device creation fails, quit
			If lnServerErr<>0 THEN
				=MESSAGEBOX(CANT_CREATE_DEVICE_LOC,ICON_EXCLAMATION,TITLE_TEXT_LOC)
				This.Die
			Else
				*Set the query timeout back to a more reasonable figure
				=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",30)
			Endif

		Endif

		*Store sql for script
		This.StoreSQL(lcSQL,DEVICE_SCRIPT_COMMENT_LOC)
		This.ThermRef.Complete

	Endfunc


	Function ExecuteTempSPT
		Parameters lcSQL, lnServerError, lcErrMsg, lcCursor
		Local nRetVal, lnButtons, lcMsg, lcNewSQL, lcEscape

		lcEscape=IIF(this.ProcessingOutput,"ON",SET ("ESCAPE"))
		Set ESCAPE OFF

		If PARAMETERS()=4 THEN
			nRetVal=SQLEXEC(this.MasterConnHand,lcSQL, lcCursor)
		Else
			nRetVal=SQLEXEC(this.MasterConnHand,lcSQL)
		Endif

		Set ESCAPE &lcEscape

		Do CASE
			*It worked
		Case nRetVal=1
			lnServerError=0
			lcErrMsg=""
			Return .T.

			*Server error occurred
		Case nRetVal=-1
			=AERROR(aErrArray)
			lnServerError=aErrArray[1]
			lcErrMsg=aErrArray[2]

			If lnServerError=1526 AND !ISNULL(aErrArray[5])THEN
				lnServerError=aErrArray[5]
			Endif

			Do CASE
			Case lnServerError=1105
				*If Log is full, try to dump it (but only if upsizing to existing db)
				=MESSAGEBOX(LOG_FULL_LOC,ICON_EXCLAMATION,TITLE_TEXT_LOC)
			Case  lnServerError=1101 OR lnServerError=1510
				*Device full
				=MESSAGEBOX(DEVICE_FULL_LOC,ICON_EXCLAMATION,TITLE_TEXT_LOC)

			Case lnServerError=1804
				*SQL Server bug having to do with dropped device
				=MESSAGEBOX(SQL_BUG_LOC,ICON_EXCLAMATION,TITLE_TEXT_LOC)

				*this error happens when dropping sproc that doesn't exist
			Case lnServerError=3701
				Return .F.

			Case lnServerError=102
				*syntax error in sql
				Return .F.

			Case lnServerError=2615
				*duplicate record entered
				*should be caused only by running sp_foreignkey on a relation
				*with the same foreign key twice
				Return .F.

			Otherwise
				*unknown error
				Return .F.
			Endcase

			*Connection level error occurred
		Case nRetVal=-2
			*This is trouble; continue to generate script if user wants; otherwise bail
			lcMsg=STRTRAN(CONNECT_FAILURE_LOC,"|1",LTRIM(STR(lnServerErr)))
			=MESSAGEBOX(lcMsg,ICON_EXCLAMATION,TITLE_TEXT_LOC)

		Endcase

		This.Die

	Endfunc

	Procedure Die
		*Closes down the wizard
		If this.SQLServer
			This.TruncLogOff
		Endif
		This.NormalShutdown=.F.
		OWizard.cancel
		Return to finish
		Return to Wizstart

	Endproc


	Function SingleValueSPT
		Parameters lcSQL, lcReturnValue, lcFieldName, llReturnedOneValue
		Local lcMsg, lcErrMsg, llRetVal, lcCursor, lnOldArea, lnServerError

		*
		*Executes a server query and sees if it return one value or not
		*If it returns one value, that value gets placed in a variable passed by reference
		*

		lnOldArea=select()
		lcCursor=this.UniqueCursorName("_spt")
		Select 0
		If this.ExecuteTempSPT(lcSQL,@lnServerError,@lcErrMsg,lcCursor) THEN
			If RECCOUNT(lcCursor)=0 THEN
				llReturnedOneValue= .F.
			Else
				lcReturnValue=&lcCursor..&lcFieldName
				llReturnedOneValue=.T.
			Endif
			Use
		Else
			lcMsg=STRTRAN(QUERY_FAILURE_LOC,"|1",LTRIM(STR(lnServerError)))
			=MESSAGEBOX(lcMsg,ICON_EXCLAMATION,TITLE_TEXT_LOC)
			This.Die
			Return
		Endif

		Select (lnOldArea)
		Return llReturnedOneValue

	Endfunc


	Procedure AnalyzeTables
		Local lcEnum_Tables, lcTableName, llUTableOpen, lcSourceDB, lnOldArea, ;
			llUpsizable, lcTablePath, llAlreadyOpened, llWarnUser, lcCursorName, ;
			aOpenTables, I, ctmpTblName

		lcSourceDB=this.SourceDB
		lnOldArea=select()
		Set database to (lcSourceDB)
		lcEnum_Tables=this.CreateWzTable("Tables")
		This.EnumTablesTbl=lcEnum_Tables

		If aDBObjects(aTblArray,"table")=0 THEN
			Return
		Endif

		Dimension aOpenTables[1,2]
		=aused(aOpenTables)
		For I=1 to alen(aTblArray,1)
			Append blank
			lcTablePath= FULL(DBGETPROP(aTblArray(I),"TABLE","PATH"),DBC())
			llUpsizable=this.Upsizable(aTblArray(I), lcTablePath, @llAlreadyOpened, @lcCursorName, @aOpenTables)

			Replace TblName with LOWER(aTblArray(I)), ;
				CursName with lcCursorName,  ;
				TblPath with lcTablePath, ;
				Upsizable WITH llUpsizable, ;
				PreOpened WITH llAlreadyOpened

			* Check for DBCS
			ctmpTblName = ALLTRIM(TblName)
			If LEN(m.ctmpTblName)#LENC(m.ctmpTblName)
				ctmpTblName=STRTRAN(ctmpTblName,CHR(32),"_")
				If LEN(m.ctmpTblName)>29
					If ISLEADBYTE(SUBSTR(m.ctmpTblName,30,1))
						ctmpTblName = LEFT(m.ctmpTblName,29)
					Endif
				Endif
			Endif
			Replace RmtTblName WITH this.RemotizeName(m.ctmpTblName)

			If !llUpsizable THEN
				llWarnUser=.T.
			Endif
			lcCursorName=""
		Next

		If llWarnUser THEN
			=MESSAGEBOX(NO_OPEN_EXCLU_LOC,ICON_EXCLAMATION,TITLE_TEXT_LOC)
		Endif

		This.AnalyzeTablesRecalc=.F.

		Select (lnOldArea)

	Endproc


	Function AnalyzeClusters
		Parameters aClusters
		Local lcEnumClusters, lnOldArea, lcTableName, I, lnTableCount, aClusterCount

		* this creates the cluster table

		lnOldArea = SELECT()
		aClusterCount = ALEN(aClusters, 1)
		Dimension aClusters(ALEN(aClusters,1), 5)	&& won't compile without dimension
		If EMPTY(aClusters[1,1]) OR aClusterCount = 0
			Return
		Endif

		*Create table for clusters if it doesn't exist yet
		If RTRIM(this.EnumClustersTbl) == ""
			lcEnumClusters = this.CreateWzTable("Clusters")
			This.EnumClustersTbl = lcEnumClusters
		Else
			lcEnumClusters = RTRIM(this.EnumClustersTbl)
			Select &lcEnumClusters
			Zap
		Endif

		* copy data from aClusters to Clusters table
		lnTableCount = 0
		Select (lcEnumClusters)
		For m.I = 1 to aClusterCount
			lcClusterName = LOWER(aClusters[m.i, 1])
			lcMsg = STRTRAN(THIS_TABLE_LOC, "|1", lcClusterName)
			This.UpDateTherm(lnTableCount, lcMsg)

			Append BLANK
			Replace ClustName with  lcClusterName, ;
				ClustType with aClusters[m.i, 2], ;
				HashKeys with aClusters[m.i, 3], ;
				ClustSize with aClusters[m.i, 4], ;
				Export with .T., ;
				Exported with .F.

		Endfor

		Select (lnOldArea)
	Endproc


	Procedure AnalyzeFields
		Local lcEnum_Fields, lnOldArea, lcEnum_Tables, lcTableName, lcSourceDB, ;
			I, lnTableCount, lnListIndex, lnListIndexTemp, lcCursorName, lcErrMsg

		*
		* this creates the enumerates all the fields, their types etc.
		* in the tables selected to be upsized
		*

		* gets called when the tables selected for upsizing have changed

		lcEnum_Tables=this.EnumTablesTbl
		lnOldArea=SELECT()

		Select COUNT(*) FROM (lcEnum_Tables) WHERE FldsAnald=.F. and Export=.T. ;
			INTO ARRAY aTableCount
		If aTableCount=0 THEN
			Return
		Endif

		*Tell the user what's going on
		If this.ProcessingOutput THEN
			lcMsg=STRTRAN(ANALYZING_FIELDS_LOC,"...")
			This.InitTherm(lcMsg,aTableCount,0)
		Else
			Wait ANALYZING_FIELDS_LOC WINDOW NOWAIT
		Endif
		lnTableCount=0

		*Create table for fields if it doesn't exist yet
		If RTRIM(this.EnumFieldsTbl)=="" THEN
			lcEnum_Fields=this.CreateWzTable("Fields")
			This.EnumFieldsTbl=lcEnum_Fields
			llCreateIndexes=.T.
		Else
			lcEnum_Fields=rtrim(this.EnumFieldsTbl)
			llCreateIndexes=.F.
		Endif

		*only look at tables that haven't been crunched through this procedure before
		Select (lcEnum_Tables)
		Scan for FldsAnald=.F. and Export=.T.
			lcCursorName=rtrim(&lcEnum_Tables..CursName)
			lcTableName=rtrim(&lcEnum_Tables..TblName)
			lcMsg=STRTRAN(THIS_TABLE_LOC,"|1",lcTableName)
			This.UpDateTherm(lnTableCount,lcMsg)
			Select (lcCursorName)
			=afields(aFldArray)

			* test for number of fields and record size(for SQL Server)
			If this.SQLServer
				lcErrMsg = ""
				If ALEN(aFldArray,1)> 250
					lcErrMsg = STRTRAN(CANT_UPSIZE_LOC ,"|1", lcTableName)+ EXCEED_FIELDS_LOC
				Endif
				If RECSIZE() > 1962
					If !EMPTY(lcErrMsg)
						lcErrMsg = lcErrMsg + " and " + EXCEED_RECSIZE_LOC
					Else
						lcErrMsg = STRTRAN(CANT_UPSIZE_LOC ,"|1", lcTableName)+ EXCEED_RECSIZE_LOC
					Endif
				Endif
				If !EMPTY(lcErrMsg)
					=MESSAGEBOX(lcErrMsg, ICON_EXCLAMATION, TITLE_TEXT_LOC)
				Endif
			Endif

			Select (lcEnum_Fields)
			For I=1 to alen(aFldArray,1)
				Append blank

				lcFldName=LOWER(aFldArray(I,1))
				Replace TblName with lcTableName, ;
					FldName with lcFldName,;
					DataType with aFldArray(I,2), ;
					Length with aFldArray(I,3) ;
					Precision with aFldArray(I,4), ;
					RmtFldname WITH this.RemotizeName(lcFldName), ;
					RmtLength with aFldArray(I,3) ;
					RmtPrec with aFldArray(I,4),;
					LclNull with aFldArray(I,5), ;
					RmtNull with aFldArray(I,5), ;
					NoCptrans with aFldArray(I,6)
			Next I

			Select (lcEnum_Tables)
			* set default mapping
			This.DefaultMapping(lcTableName)
			* set TimeStamp default (M, G, P)
			Replace TStampAdd with (this.SQLServer AND this.AddTimeStamp(TblName))
			Replace FldsAnald with .T.

			If this.ProcessingOutput THEN
				lnTableCount=lnTableCount+1
				This.UpDateTherm(lnTableCount)
			Endif
		Endscan

		Select (lcEnum_Fields)

		*Only do this the first time through
		*IF llCreateIndexes THEN
		*	INDEX ON TblName TAG TblName
		*	INDEX ON FldName TAG FldName
		*	SET ORDER TO
		*ENDIF

		*Deal with thermometer or wait window
		If !this.ProcessingOutput THEN
			Wait CLEAR
		Else
			This.ThermRef.Complete
		Endif

		This.AnalyzeFieldsRecalc=.F.
		Select (lnOldArea)

	Endproc


	Procedure DefaultMapping
		Parameters lcTableName
		Local lnOldArea, aDefaultMapping, lcEnum_Fields, lnLength, lnPrecision, ;
			lcTypeString, llSkippedFirst, lcNocpType

		lnOldArea=SELECT()
		lcEnum_Fields=RTRIM(this.EnumFieldsTbl)
		*grab array of data types for setting default datatypes
		Dimension aDefaultMapping(11,4)
		This.GetDefaultMapping(@aDefaultMapping)
		*Columns in aDefaultMapping
		*Column 1: LocalType (local FoxPro data type)
		*Column 2: RemoteType (default server data type)
		*Column 3: VarLength (whether the data type is variable length or not)
		*Column 4: FullLocal	(full name of FP data type, e.g. "C"->"character")

		*Go through the fields and stick in default data type

		Select (lcEnum_Fields)
		For I=1 to ALEN(aDefaultMapping,1)

			*If the remote datatype doesn't take a length argument, put 0 in there.
			*Otherwise, put a 1 in and then transfer the length and precision values of the local type.
			*The 0 will cause the field to be ignored by the CreateTableSQL routine

			If aDefaultMapping(I,3)=.T. THEN
				lnLength=1
				lnPrecision=1
			Else
				lnLength=0
				lnPrecision=0
			Endif

			Replace RmtType with aDefaultMapping(I,2), ;
				FullType with aDefaultMapping(I,4) ;
				RmtLength with lnLength, RmtPrec with lnPrecision ;
				for DataType = aDefaultMapping(I,1) and rtrim(TblName) == lcTableName
		Next

		* Set up ComboType field of the type mapping grid
		* create a string like "character (14)" or "numeric (3,2)" or "memo" or "memo-nocp"
		Scan for RTRIM(TblName) == lcTableName
			* change default FullType for NoCptrans
			lcTypeNocp = IIF(DataType = 'C', 'char_nocp', 'memo_nocp')
			lcTypeString = IIF(NoCptrans, lcTypeNocp, RTRIM(FullType))

			* add field length and decimals for Fox variable length types
			If INLIST(DataType, 'C', 'N', 'F')
				lcTypeString = lcTypeString + " (" + ltrim(str(length))
				If Precision <> 0 THEN
					lcTypeString = lcTypeString + "," + ltrim(str(Precision))
				Endif
				lcTypeString = lcTypeString+")"
			Endif
			Replace ComboType with lcTypeString
		Endscan

		* Set up the RemLength, RemPrec fields of the type mapping grid
		* Replace all the 1s in the Rmtlength field with local length and precision values
		* jvf 08/16/99
		Scan for RmtLength <> 0 and rtrim(TblName) == lcTableName
			If Precision <> 0 and DataType = 'N'
				Replace RmtLength with Length-1, RmtPrec with Precision
			Else
				Replace RmtLength with Length, RmtPrec with Precision
			Endif
		Endscan

		* implement the server-specific cases for RmtType, Rmtlength, RmtPrec
		If this.SQLServer THEN
			Replace all RmtType with "char" ;
				for DataType = "C" and NoCptrans and rtrim(TblName)==lcTableName
			* jvf 1/8/01 RmtType s/b Text, not Image, for Binary Memos - Bug ID 45752
			Replace all RmtType with "text" ;
				for DataType = "M" and NoCptrans and rtrim(TblName)==lcTableName
		Endif

		* If we're upsizing to Oracle, need to put default values in for money and logical types
		* Same for int when converted to numeric
		If this.ServerType == ORACLE_SERVER THEN

			Replace all RmtType with "raw" ;
				for DataType = "C" and NoCptrans and rtrim(TblName)==lcTableName

			Replace all RmtType with "long raw" ;
				for DataType = "M" and NoCptrans and rtrim(TblName)==lcTableName

			Replace all RmtLength with 19, RmtPrec with 4 ;
				for DataType="Y" and rtrim(TblName)==lcTableName

			Replace all RmtLength with 1, RmtPrec with 0 ;
				for DataType="L" and rtrim(TblName)==lcTableName

			Replace all RmtLength with 11, RmtPrec with 0 ;
				for DataType="I" and rtrim(TblName)==lcTableName

			*Oracle only allows one LONG or LONG RAW column per table; change all
			*but the first LONG RAW, ie General, to RAW(255); change extra LONG fields
			*to VARCHAR2(2000)

			*This handles general fields
			Locate for RTRIM(RmtType)=="long raw" and rtrim(TblName)==lcTableName
			Do WHILE FOUND()
				If llSkippedFirst THEN
					Replace RmtType with "raw", RmtLength with 255
				Else
					llSkippedFirst=.T.
				Endif
				Continue
			Enddo

			*This handles memo fields
			Locate for RTRIM(RmtType)=="long" and rtrim(TblName)==lcTableName
			Do WHILE FOUND()
				If llSkippedFirst THEN
					Replace RmtType with "varchar2", RmtLength with 2000
				Else
					llSkippedFirst=.T.
				Endif
				Continue
			Enddo
		Endif

		Select (lnOldArea)

	Endproc


	Function GetEligibleTables
		Parameters aTableArray
		Local lcEnumTables, lnOldArea, I

		lnOldArea=SELECT()
		lcEnumTables=this.EnumTablesTbl
		Select (lcEnumTables)
		Set FILTER TO Upsizable=.T.
		Go TOP
		I=1
		If EOF()
			Return 0
		Else
			Scan
				If !EMPTY(aTableArray[1]) THEN
					Dimension aTableArray[ALEN(aTableArray,1)+1]
				Endif
				aTableArray[i]=TblName
				I=I+1
			Endscan
		Endif
		Select (lnOldArea)
		Return

	Endfunc


	Function GetEligibleClusterTables
		Parameters aTableArray, lcSelectClustName
		Local lcEnumTables, lnOldArea, I, lcFilter

		* if EOF() the array is unchanged
		Dimension aTableArray[1]
		aTableArray[1] = ""
		lnOldArea=SELECT()
		lcEnumTables=this.EnumTablesTbl
		Select (lcEnumTables)

		lcSelectClustName = TRIM(lcSelectClustName)
		If lcSelectClustName = ""
			lcFilter = "Export = .T. AND EMPTY(ClustName)"
		Else
			lcFilter = "Export = .T. AND TRIM(ClustName) = lcSelectClustName"
		Endif

		Go TOP
		I=1
		If EOF()
			Return 0
		Else
			Scan FOR &lcFilter
				If !EMPTY(aTableArray[1]) THEN
					Dimension aTableArray[ALEN(aTableArray,1)+1]
				Endif
				aTableArray[i] = TRIM(TblName)
				I=I+1
			Endscan
		Endif
		Select (lnOldArea)
		Return

	Endfunc


	Function GetEligibleTableFields
		Parameters aFieldArray, lcTableName, llKeys
		Local lcEnumFields, lnOldArea, I, lcFilter

		Dimension aFieldArray[1]
		aFieldArray[1] = ""
		lnOldArea = SELECT()
		lcEnumFields = this.EnumFieldsTbl
		Select (lcEnumFields)

		lcTableName = TRIM(lcTableName)
		If llKeys
			lcFilter = "TblName = lcTableName  AND !EMPTY(ClustOrder)"
		Else
			lcFilter = "TblName = lcTableName  AND EMPTY(ClustOrder)"
		Endif

		Go TOP
		I = 1
		If EOF()
			Return 0
		Else
			Scan FOR &lcFilter
				If !EMPTY(aFieldArray[1]) THEN
					Dimension aFieldArray[ALEN(aFieldArray,1)+1]
				Endif
				aFieldArray[i] = TRIM(FldName)
				I = I + 1
			Endscan
		Endif
		Select (lnOldArea)
		Return

	Endfunc

	Function GetInfoTableFields
		Parameters aInfoFieldArray, lcTableName, llKeys
		Local lcEnumFields, lnOldArea, I, lcFilter

		Dimension aInfoFieldArray[1,5]
		aInfoFieldArray[1,1] = ""
		lnOldArea = SELECT()
		lcEnumFields = this.EnumFieldsTbl
		Select (lcEnumFields)
		lcTableName = TRIM(lcTableName)
		If llKeys
			lcFilter = "TblName = lcTableName  AND !EMPTY(ClustOrder)"
		Else
			lcFilter = "TblName = lcTableName  AND EMPTY(ClustOrder)"
		Endif

		Go TOP
		I = 1
		If EOF()
			Return 0
		Else
			Scan FOR &lcFilter
				If !EMPTY(aInfoFieldArray[1,1])
					Dimension aInfoFieldArray[ALEN(aInfoFieldArray,1)+1,5]
				Endif
				aInfoFieldArray[i,1] = TRIM(FldName)
				aInfoFieldArray[i,2] = TRIM(RmtType)
				aInfoFieldArray[i,3] = RmtLength
				aInfoFieldArray[i,4] = RmtPrec
				If llKeys
					aInfoFieldArray[i,5] = ClustOrder
				Else
					aInfoFieldArray[i,5] = .T.
				Endif
				I = I + 1
			Endscan
		Endif
		=ASORT(aInfoFieldArray, 5)
		Select (lnOldArea)
		Return

	Endfunc


	* verify if the tables selected in cluster have common fields

	Procedure VerifyClusterTablesFields
		Parameters aClusterTables
		Local llValid, aInfoTable1Fields[1,5], aInfoTableFields[1,5]

		* False if no table selected
		If EMPTY(aClusterTables[1,1])
			Return .F.
		Endif

		This.GetInfoTableFields(@aInfoTable1Fields, aClusterTables[1], .F.)

		* True if we have a single cluster with at least one key
		If ALEN(aClusterTables,1) = 1
			Return IIF(EMPTY(aClusterTables[1,1]), .F., .T.)
		Endif

		* we have at least two tables here and first table has at least a field selected
		For m.I = 2 TO ALEN(aClusterTables,1)
			This.GetInfoTableFields(@aInfoTableFields, aClusterTables[m.i],.F.)
			For m.j = 1 TO ALEN(aInfoTable1Fields,1)
				If aInfoTable1Fields[m.j,5]
					For m.k = 1 TO ALEN(aInfoTableFields,1)
						llValid = .F.
						If (aInfoTable1Fields[m.j,2] = aInfoTableFields[m.k,2] AND ;
								aInfoTable1Fields[m.j,3] = aInfoTableFields[m.k,3] AND ;
								aInfoTable1Fields[m.j,4] = aInfoTableFields[m.k,4])
							llValid = .T.
							Exit
						Endif
					Endfor
					aInfoTable1Fields[m.j,5] = llValid
				Endif
			Endfor
		Endfor

		Return ASCAN(aInfoTable1Fields,.T.) > 0
	Endproc



	Procedure VerifyClusterKeyFields
		Parameters aClusterTables
		Local llValid, aInfoTable1Fields[1,5], aInfoTableFields[1,5]

		* verify if the fields selected in each table(part of the cluster) are the same

		* False if no clusters
		If EMPTY(aClusterTables[1,1])
			Return .F.
		Endif

		This.GetInfoTableFields(@aInfoTable1Fields, aClusterTables[1,1], .T.)

		* True if we have a single table with a valid key
		If ALEN(aClusterTables,1) = 1
			Return IIF(EMPTY(aInfoTable1Fields[1,1]), .F., .T.)
		Endif

		* we have at least two tables here and first table has a valid key
		For m.I = 2 TO ALEN(aClusterTables,1)
			This.GetInfoTableFields(@aInfoTableFields, aClusterTables[m.i], .T.)

			* keys for both clusters should match in number of fields, type and size
			If EMPTY(aInfoTableFields[1,1]) OR ;
					ALEN(aInfoTableFields,1) != ALEN(aInfoTable1Fields,1)
				Return .F.
			Endif

			For m.j = 1 TO ALEN(aInfoTable1Fields,1)
				If (aInfoTable1Fields[m.j,2] = aInfoTableFields[m.j,2] AND ;
						aInfoTable1Fields[m.j,3] = aInfoTableFields[m.j,3] AND ;
						aInfoTable1Fields[m.j,4] = aInfoTableFields[m.j,4])
					Loop
				Else
					Return .F.
				Endif
			Endfor
		Endfor

		Return .T.
	Endproc


	Procedure GetDefaultMapping
		Parameters aPassedArray
		Local lnOldArea, lcServerConstraint

		lnOldArea=SELECT()
		If NOT USED("TypeMap")
			Select 0
			Use TypeMap EXCLUSIVE
		Else
			Select TypeMap
		Endif

		*Didn't foresee a problem, thus this cheezy snippet
		If this.ServerType=="SQL Server95" THEN
			lcServerConstraint="SQL Server"
		Else
			If this.ServerType=="SQL Server" THEN
				lcServerConstraint="SQL Server4x"
			Else
				lcServerConstraint=RTRIM(this.ServerType)
			Endif
		Endif

		Select LocalType, RemoteType, VarLength, FullLocal FROM TypeMap ;
			WHERE  TypeMap.Default=.T. AND TypeMap.Server=lcServerConstraint ;
			INTO ARRAY aPassedArray

		Select(lnOldArea)

	Endfunc


	#If SUPPORT_ORACLE
	Procedure DealWithTypeLong
		Local lcEnumFieldsTbl, lnOldArea

		*
		*Oracle tables only allow one field to be Long or LongRaw; this warns
		*the user about the problem.  The DefaultMapping routine deals with it
		*

		This.AnalyzeFields

		lcEnumFieldsTbl=this.EnumFieldsTbl
		lnOldArea=SELECT()
		Select 0
		lcCursor=this.UniqueCursorName("_foo")
		Select COUNT(*) FROM (lcEnumFieldsTbl) ;
			where RTRIM(DataType)=="M" or ;
			RTRIM(DataType)=="G" or ;
			RTRIM(DataType)=="P" ;
			GROUP BY TblName ;
			INTO CURSOR &lcCursor
		Select COUNT(*) FROM (lcCursor) WHERE cnt>1 INTO ARRAY aMemoCount
		Use

		If aMemoCount>0 THEN
			lcMsg=STRTRAN(LONG_TYPE_LOC,'|1',LTRIM(STR(aMemoCount)))
			lcMsg=STRTRAN(lcMsg,'|2',IIF(aMemoCount>1,TABLES_HAVE_LOC,TABLE_HAS_LOC))
			=MESSAGEBOX(lcMsg,ICON_EXCLAMATION,TITLE_TEXT_LOC)
		Endif

		Select (lnOldArea)

	Endproc
#Endif


#If SUPPORT_ORACLE
	Function TwoLongs
		Parameters lcTableName, lcFirstLong, lcOtherLong
		Local lcEnumFieldsTbl, lnOldArea

		*Checks to see if a field in a table already has a type of Long or Long Raw
		*Returns the name of the field if there is one

		lcEnumFieldsTbl=this.EnumFieldsTbl
		lnOldArea=SELECT()
		Select (lcEnumFieldsTbl)
		Locate FOR RTRIM(TblName)==lcTableName AND RmtType="long"
		If RTRIM(FldName)==lcFirstLong THEN
			Continue
			If FOUND() THEN
				lcOtherLong=FldName
			Endif
		Else
			lcOtherLong=FldName
		Endif

		Select (lnOldArea)
		Return !EMPTY(lcOtherLong)

	Endfunc
#Endif


	Function Upsizable
		Parameters lcTableName, lcTablePath, llAlreadyOpen, lcCursorName, aOpenTables
		Local lnOldArea, I, lcNewCursName

		*
		*This function checks to see that a table is actually marked as part of the
		*selected database
		*
		*It also opens all tables exclusively if they aren't already
		*

		*Substitute underscores for any spaces (as FoxPro does)

		*See if the table is already open, possibly with an alias different from the table name
		If !EMPTY(aOpenTables) THEN
			For I=1 TO ALEN(aOpenTables,1)
				If DBF(aOpenTables[i,2])==RTRIM(UPPER(lcTablePath)) THEN
					lcCursorName=aOpenTables[i,1]
					Exit
				Endif
			Next
		Endif

		*If it's not open already, handle table names with spaces
		If EMPTY(lcCursorName) THEN
			lcCursorName=RTRIM(STRTRAN(lcTableName,CHR(32),"_"))
			*Handle the case of table name being an important Fox keyword
			*Note the base wizard class ensures that no tables are already open
			*with these keywords, so we only worry about opening them here
			If INLIST(UPPER(lcCursorName),"THIS","THISFORMSET","OWIZARD","OENGINE")
				lcCursorName=LEFT(lcCursorName,MAX_FIELDNAME_LEN-1)+"_"
			Endif
		Endif

		lnOldArea=SELECT()
		If !FILE(lcTablePath) THEN
			Select (lnOldArea)
			Return .F.
		Endif
		If !USED(lcCursorName) THEN
			This.SetErrorOff=.T.
			This.HadError=.F.
			llAlreadyOpened=.F.
			Select 0
			Use (lcTableName) ALIAS (lcCursorName) EXCLUSIVE
			This.SetErrorOff=.F.
			If this.HadError
				Select (lnOldArea)
				Return .F.
			Endif
		Else
			*Make sure that if a table's open, it belongs to the database
			*to be upsized
			Select (lcCursorName)
			If !LOWER(CURSORGETPROP('database'))==LOWER(ALLTRIM(this.SourceDB)) THEN
				lcCursorName=this.UniqueTorVName("Namewithmanycharacters")
				This.SetErrorOff=.T.
				This.HadError=.F.
				Select 0
				Use (lcTableName) EXCLUSIVE ALIAS (lcCursorName)
				This.SetErrorOff=.F.
				If this.HadError
					Use
					Select (lnOldArea)
					Return .F.
				Endif
			Else
				llAlreadyOpened=.T.
			Endif

			*If it's open, make sure it's open exclusive
			Select (lcCursorName)
			If !ISFLOCKED()
				Use
				This.SetErrorOff=.T.
				This.HadError=.F.
				Use (lcTableName) EXCLUSIVE
				This.SetErrorOff=.F.
				If this.HadError
					Use (lcTableName) SHARED
					Select (lnOldArea)
					Return .F.
				Endif
			Endif

		Endif

		Select (lnOldArea)

	Endfunc


	#If SUPPORT_ORACLE
	Procedure RemoveCluster
		Parameters lcClusterName
		Local lcClusterNamesTbl, lcClusterKeysTbl, lcEnumTablesTbl, lnOldArea

		*Called by "Remove" button on Create Cluster screen and by Table Selection screen

		lcClusterNamesTbl=this.ClusterNamesTbl
		lcClusterKeysTbl=this.ClusterKeysTbl
		lcEnumTablesTbl=this.EnumTablesTbl
		lnOldArea=SELECT()

		*delete the record for the cluster from the cluster names table
		Select (lcClusterNamesTbl)
		Delete ALL FOR &lcClusterNamesTbl..ClustName=lcClusterName

		*delete any related records in the cluster keys table
		Select (lcClusterKeysTbl)
		Delete ALL FOR &lcClusterKeysTbl..ClustName=lcClusterName

		*Mark any tables that were in the cluster as available
		Select (lcEnumTablesTbl)
		Replace ALL &lcEnumTablesTbl..lcClusterName WITH ""

		Select (lnOldArea)

	Endproc
#Endif


#If SUPPORT_ORACLE
	Function ChangeClusterStatus
		Parameters lcRel,lcClustName, lcClustType, lnHashKeys
		Local lcEnumTables, lnOldArea, lcEnumIndexesTbl, aClustTables, lcParent, ;
			lcChild, lnDupeID

		*Called from cluster creation page when user adds or removes a cluster

		lnOldArea=SELECT()
		lcEnumTables=this.EnumTablesTbl
		lcEnumIndexesTbl=this.EnumIndexesTbl
		lcEnumRelsTbl=this.EnumRelsTbl
		If EMPTY(lnHashKeys) THEN
			lnHashKeys=0
		Endif

		*Parse the relation
		lcParent=""
		lcChild=""
		lnDupeID=0
		This.ParseRel(lcRel,@lcParent,@lcChild,@lnDupeID)
		Select (lcEnumRelsTbl)

		*If the clustertype wasn't passed, the cluster is being added or deleted
		*so see if the name is already in use
		If TYPE("lcClustType")="L" THEN
			If !lcClustName=="" THEN
				Set ORDER TO ClustName
				Seek RTRIM(lcClustName)
				If FOUND() THEN
					*Give error message if cluster name already exists
					lcMessage=STRTRAN(DUP_CLUSTNAME_LOC,"|1",RTRIM(this.UserInput))
					=MESSAGEBOX(lcMessage,ICON_EXCLAMATION,TITLE_TEXT_LOC)
					Set ORDER TO
					Return .F.
				Endif
				Set ORDER TO
			Endif
		Endif

		*If it's not in use or we're just changing the cluster type, find the right record
		*and toss the values in

		Locate for DD_CHILD=lcChild and DD_PARENT=lcParent and Duplicates=lnDupeID
		If TYPE("lcClustType")="L" THEN
			lcClustType=IIF(lcClustName=="","","INDEX")
			Replace ClustName WITH lcClustName, ClustType WITH lcClustType, ;
				HashKeys WITH lnHashKeys

			*Now associate the cluster name ("" if table is being removed)
			*with the tables in the cluster and store default cluster type of " INDEX"
			Select (lcEnumTables)
			Replace &lcEnumTables..ClustName WITH lcClustName FOR TblName=lcParent OR TblName=lcChild
		Else
			Replace ClustType WITH lcClustType, HashKeys WITH lnHashKeys
		Endif

		Select (lnOldArea)


	Endfunc
#Endif


#If SUPPORT_ORACLE
	Procedure RemoveTableFromClust
		Parameters lcClustName

		*Called by page 6 when a user deselects a table that was going to be exported

		Local lcEnumRelsTbl, lcEnumTablesTbl, lnOldArea, lnRecNo
		lcEnumTablesTbl=this.EnumTablesTbl
		lcEnumRelsTbl=this.EnumRelsTbl
		lnOldArea=SELECT()

		Select (lcEnumTablesTbl)
		lnRecNo=RECNO()
		Replace ClustName WITH "" FOR RTRIM(ClustName)==RTRIM(lcClustName)
		Go lnRecNo

		Select (lcEnumRelsTbl)
		Replace ClustName WITH "", ClustType WITH "" FOR RTRIM(ClustName)==RTRIM(lcClustName)

		Select (lnOldArea)

	Endproc
#Endif


#If SUPPORT_ORACLE
	Function InOneCluster
		Parameters lcRel
		Local lcParent, lcChild, lnDupeID, lcEnumTablesTbl, lcMsg

		*
		*Checked when the user creates a cluster; ensures that a given table is only
		*in one relation
		*

		*Parse the relation
		lcParent=""
		lcChild=""
		lnDupeID=0
		This.ParseRel(lcRel,@lcParent,@lcChild,@lnDupeID)

		*See if the tables are already in a cluster
		lcEnumTablesTbl=this.EnumTablesTbl
		Select (lcEnumTablesTbl)

		For I=1 to 2
			Locate FOR RTRIM(TblName)==lcParent
			If !EMPTY(ClustName) THEN
				lcMsg=STRTRAN(ONE_CLUSTER_LOC,"|1",lcParent)
				lcMsg=STRTRAN(lcMsg,"|2",RTRIM(ClustName))
				=MESSAGEBOX(lcMsg,48,TITLE_TEXT_LOC)
				Return .F.
			Endif
			lcParent=lcChild
		Next

	Endfunc
#Endif


	Function InIndex
		Parameters aIndexes, lcFldName, lcTableName
		Local lcEnumIndexesTbl, lnOldArea, lcTagName, llInIndex

		*
		*Returns array of tag names where a given field is part of the tag expression
		*

		lcEnumIndexesTbl=this.EnumIndexesTbl
		lnOldArea=SELECT()
		Select (lcEnumIndexesTbl)
		Locate FOR RTRIM(IndexName)=lcTableName
		llInIndex=.F.
		Do WHILE FOUND()
			If lcFldName $ LclExpr THEN
				lcTagName=RTRIM(TagName)
				This.InsaItem(@aIndexes,lcTagName)
				llInIndex=.T.
			Endif
			Continue
		Enddo

		Select (lnOldArea)
		Return llInIndex

	Endfunc


	Function InKey
		Parameters lcRmtFieldName, lcTableName
		Local lcEnumRelsTbl, lnOldArea, aRels

		*
		*Checks to see if a given field is in a key (primary or foreign)
		*

		lcTableName=LOWER(lcTableName)
		lcEnumRelsTbl=this.EnumRelsTbl
		lnOldArea=SELECT()
		Select (lcEnumRelsTbl)
		Locate FOR RTRIM(DD_PARENT)==lcTableName OR RTRIM(DD_CHILD)==lcTableName
		llInKey=.F.
		Do WHILE FOUND()
			If lcRmtFieldName $ DD_CHIEXPR
				lcRelatedTable=IIF(RTRIM(DD_PARENT)=lcTableName,RTRIM(DD_CHILD),RTRIM(DD_PARENT))
				llInKey=.T.
				Exit
			Endif
			Continue
		Enddo

		Select (lnOldArea)
		Return llInKey

	Endfunc


	Procedure DontIndex
		Parameters lcFieldName, lcTableName
		Local lnOldArea, lcEnumIndexsTbl

		*
		*If user changed data type to something unindexable, don't create the indexes
		*that include the unindexable field
		*

		lnOldArea=SELECT()
		lcEnumIndexsTbl=this.EnumIndexesTbl
		Select (lcEnumIndexsTbl)
		Locate FOR RTRIM(IndexName)==RTRIM(lcTableName) AND lcFieldName $ LclExpr
		Do WHILE FOUND()
			Replace IdxError WITH STRTRAN(IDX_NOT_CREATED_LOC,"|1",lcFieldName), ;
				Exported WITH .F., ;
				DontCreate WITH .T.
			Continue
		Enddo

		Select (lnOldArea)

	Endproc


	Procedure DefaultsAndRules

		*
		*This proc converts FoxPro defaults and rules to server equivalents
		*
		*In the case of SQL Server, defaults are converted to defaults and rules to stored
		*procedures which are then called from insert and update triggers
		*
		*In the case of Oracle, defaults become ALTER TABLE statements and rules are
		*converted to SQL statements that will wind up in one trigger that executes on
		*the update or insert event
		*
		* If llOraFieldRules, create Oracle field rules to become part of CREATE TABLE

		Local lcEnumTables, lcTableName, lcTableRule, lcRmtTableName, ;
			lcRuleExpression, lcRemoteRule, lcRuleText, lcFldName, ;
			lcDefaultExpression, lcRemoteDefault, lcEnumFields, llRuleSprocCreated, ;
			llDefaultCreated, llDefaultBound, llTableExported, lcRemoteRuleName, ;
			lcRemoteDefaultName, lcFldType, lcRuleError, lcDefaError, lcRmtFldName, ;
			lcConstName, lnTableCount, lcThermMsg, lnError, llShowTherm, llRuleCreated


		lcEnumTables = this.EnumTablesTbl
		Select (lcEnumTables)

		* thermometer
		Select COUNT(*) FROM (lcEnumTables) WHERE Export = .T. INTO ARRAY aTableCount
		If this.ExportValidation THEN
			lcThermMsg =  CONVERT_RULE_LOC
		Endif
		If this.ExportDefaults THEN
			If EMPTY(lcThermMsg) THEN
				lcThermMsg = CONVERT_DEFAS_LOC
			Else
				lcThermMsg = lcThermMsg + AND_LOC + CONVERT_DEFAS_LOC
			Endif
		Endif
		If !this.ExportDefaults and !this.ExportValidation THEN
			If this.ServerType = "Oracle" THEN
				Return
			Else
				lcThermMsg = BIND_DEFAS_LOC
			Endif
		Else
			lcThermMsg = CONVERT_STEM_LOC + lcThermMsg
		Endif
		This.InitTherm(lcThermMsg,aTableCount,0)
		lnTableCount = 0

		Scan FOR &lcEnumTables..Export = .T.
			llTableExported = &lcEnumTables..Exported
			lcTableName = RTRIM(&lcEnumTables..TblName)
			lcRmtTableName = RTRIM(&lcEnumTables..RmtTblName)

			lcThermMsg = STRTRAN(THIS_TABLE_LOC, '|1', lcTableName)
			This.UpDateTherm(lnTableCount, lcThermMsg)
			lnTableCount = lnTableCount + 1

			lcRuleError=""
			lcDefaultError=""
			lcRemoteRuleName=""
			lcRemoteRule=""
			lcRuleText=""
			lcRemoteDefault=""
			llRuleSprocCreated=.F.
			llDefaultCreated=.F.
			llDefaultBound=.F.
			lcRemoteDefaultName=""
			lcDefaError=""
			lnError=.F.

			*Turn table rules into stored procedures (SQL Server) or constraints (Oracle)
			*Grab the rule

			If this.ExportValidation
				lcRuleExpression = DBGETPROP(lcTableName, "Table", "RuleExpression")
				lcRuleText = DBGETPROP(lcTableName, "Table", "RuleText")

				*If there is a rule, convert it
				If !EMPTY(lcRuleExpression) THEN

					*For Oracle, convert rules to trigger code
					If this.ServerType = ORACLE_SERVER THEN
						lcConstName = ORA_CONST_TAB_PREFIX + LEFT(lcRmtTableName, MAX_NAME_LENGTH - LEN(ORA_CONST_TAB_PREFIX))
						lcConstName = this.UniqueOraName(lcConstName, .T.)
						lcRemoteRule = this.ConvertToConstraint(lcRuleExpression, lcTableName, lcRmtTableName, lcConstName)

						* Create table constraint if user is upsizing and has create constraint permissions
						If this.DoUpsize AND llTableExported && AND this.Perm_default
							If this.ExecuteTempSPT(lcRemoteRule, @lnError, @lcDefaError)
								lcRemoteRuleName = lcConstName
							Else
								Replace RuleErrNo WITH lnError
								This.StoreError(lnError, lcRuleError, lcRemoteRule, CONVTO_TRIG_ERR_LOC, lcTableName, TABLE_RULE_LOC)
							Endif
						Endif

						Replace &lcEnumTables..LocalRule WITH lcRuleExpression, ;
							&lcEnumTables..RRuleName WITH lcRemoteRuleName, ;
							&lcEnumTables..RmtRule WITH lcRemoteRule, ;
							&lcEnumTables..RuleError WITH lcRuleError
					Else

						*For SQL Server, create a sproc
						lcRemoteRule=this.ConvertToSproc(lcRuleExpression,lcRuleText,lcTableName,;
							lcRmtTableName, "Table", @lcRemoteRuleName)

						*Create the rule if user is upsizing and has sproc permission
						If this.DoUpsize AND llTableExported AND this.Perm_Sproc THEN
							*Might have to drop existing sproc
							If this.MaybeDrop(lcRemoteRuleName,"procedure") THEN
								llRuleSprocCreated=this.ExecuteTempSPT(lcRemoteRule, @lnError, @lcRuleError)
								If !llRuleSprocCreated THEN
									Replace &lcEnumTables..RuleErrNo WITH lnError
									This.StoreError(lnError,lcRuleError,lcRemoteRule, SPROC_ERR_LOC,lcTableName,TABLE_RULE_LOC)
								Endif
							Else
								lcRuleError=CANT_DROP_SPROC_LOC
							Endif
						Endif

						*Store the information for the upsizing report
						Replace &lcEnumTables..LocalRule WITH lcRuleExpression, ;
							&lcEnumTables..RRuleName WITH lcRemoteRuleName, ;
							&lcEnumTables..RmtRule WITH lcRemoteRule, ;
							&lcEnumTables..RuleExport WITH llRuleSprocCreated, ;
							&lcEnumTables..RuleError WITH lcRuleError

						lcRuleError=""
						lnError=.F.

					Endif

				Endif

			Endif

			*
			*Deal with field rules: change to sprocs (SQL Server) or constraints (Oracle)
			lcEnumFields=this.EnumFieldsTbl

			Select (lcEnumFields)

			If this.ExportValidation THEN

				Scan FOR RTRIM(TblName)==lcTableName
					lcFldName = RTRIM(&lcEnumFields..FldName)
					lcRmtFldName = RTRIM(&lcEnumFields..RmtFldname)
					lcRuleExpression = DBGETPROP(lcTableName+"."+lcFldName,"Field","RuleExpression")
					lcRuleText = DBGETPROP(lcTableName+"."+lcFldName,"Field","RuleText")

					*do nothing if there's no local rule
					If !EMPTY(lcRuleExpression) THEN

						* For Oracle, convert rules to table constraints
						If this.ServerType = ORACLE_SERVER
							lcConstName = ORA_CONST_COL_PREFIX + LEFT(lcRmtFldName, MAX_NAME_LENGTH - LEN(ORA_CONST_COL_PREFIX))
							lcConstName = this.UniqueOraName(lcConstName, .T.)
							lcRemoteRule = this.ConvertToConstraint(lcRuleExpression, lcTableName, lcRmtTableName, lcConstName)

							* Create table constraint if user is upsizing and has create constraint permissions
							If this.DoUpsize AND llTableExported && AND this.Perm_default
								If this.ExecuteTempSPT(lcRemoteRule, @lnError, @lcDefaError)
									lcRemoteRuleName = lcConstName
								Else
									Replace &lcEnumFields..RuleErrNo WITH lnError
									This.StoreError(lnError, lcRuleError, lcRemoteRule, CONVTO_TRIG_ERR_LOC, lcTableName+"."+lcFldName, FIELD_RULE_LOC)
								Endif
							Endif

							Replace &lcEnumFields..LocalRule WITH lcRuleExpression, ;
								&lcEnumFields..RRuleName WITH lcRemoteRuleName, ;
								&lcEnumFields..RmtRule WITH lcRemoteRule, ;
								&lcEnumFields..RuleError WITH lcRuleError
						Else

							lcRemoteRule=this.ConvertToSproc(lcRuleExpression,lcRuleText,lcTableName,;
								lcRmtTableName, "Field", @lcRemoteRuleName, lcRmtFldName)

							*Create the sprocs if the user is actually upsizing and has permissions
							If this.DoUpsize AND llTableExported AND this.Perm_Sproc THEN

								*Create the sproc if there's a rule
								If !EMPTY(lcRuleExpression) THEN
									*Might have to drop existing sproc
									If this.MaybeDrop(lcRemoteRuleName,"procedure") THEN
										llRuleSprocCreated=this.ExecuteTempSPT(lcRemoteRule, @lnError, @lcRuleError)
										If !llRuleSprocCreated THEN
											Replace &lcEnumFields..RuleErrNo WITH lnError
											This.StoreError(lnError,lcRuleError,lcRemoteRule,SPROC_ERR_LOC,lcTableName+"."+lcFldName,FIELD_RULE_LOC)
										Endif
									Else
										lcRuleError=CANT_DROP_SPROC_LOC
									Endif
								Endif

							Endif

							*Store all this stuff
							Replace &lcEnumFields..LocalRule WITH lcRuleExpression, ;
								&lcEnumFields..RmtRule WITH lcRemoteRule, ;
								&lcEnumFields..RRuleName WITH lcRemoteRuleName, ;
								&lcEnumFields..RuleExport WITH llRuleSprocCreated, ;
								&lcEnumFields..RuleError WITH lcRuleError

							lcRuleError=""
							lnError=.F.

						Endif

					Endif

				Endscan

			Endif

			* Deal with defaults (depends on server type)
			*
			* Unlike the above code, the difference between Oracle and SQL Server is handled
			* in the procedure ConvertToDefault rather than here

			Scan FOR RTRIM(TblName) == lcTableName
				lcFldName = RTRIM(&lcEnumFields..FldName)
				llBitType = IIF(RTRIM(&lcEnumFields..RmtType) = "bit", .T., .F.)
				lcDefaultExpression = DBGETPROP(lcTableName + "." + lcFldName, "Field", "DefaultValue")

				If (this.ExportDefaults AND !EMPTY(lcDefaultExpression)) OR llBitType THEN

					*Convert Fox default to server default
					If this.ExportDefaults AND !EMPTY(lcDefaultExpression) THEN
						lcRemoteDefault = this.ConvertToDefault(lcDefaultExpression, lcFldName, ;
							lcTableName, lcRmtTableName, @lcRemoteDefaultName)
					Else
						lcRemoteDefault = "0"
					Endif

					*If the default expression is 0 or.F., bind the zero default to field
					If  this.SQLServer and ;
							(ALLTRIM(lcRemoteDefault) == "0" OR lcDefaultExpression = "0" OR lcDefaultExpression=".F.")
						llZD_field=.T.
						lcRemoteDefault="0"
						lcRemoteDefaultName=ZERO_DEFAULT_NAME
						This.ZDUsed=.T.
					Else
						llZD_field=.F.
					Endif

					If !this.ExportDefaults AND !llZD_field AND EMPTY(lcDefaultExpression) THEN
						Loop
					Endif

					* Create the default if user is upsizing and has create default permissions
					If this.DoUpsize AND llTableExported AND this.Perm_Default THEN
						If llZD_field THEN
							llDefaultCreated = this.ZeroDefault()
						Else
							* If we're Oracle or a non-zero default, just create the default
							* (for SQL Server) or alter the table (Oracle)
							* Might have to drop existing default
							If this.ServerType = "Oracle" OR this.MaybeDrop(lcRemoteDefaultName, "default") THEN
								llDefaultCreated = this.ExecuteTempSPT(lcRemoteDefault, @lnError, @lcDefaError)
								If !llDefaultCreated THEN
									Replace &lcEnumFields..DefaErrNo WITH lnError
									This.StoreError(lnError,lcDefaError,lcRemoteDefault, DEFA_ERR_LOC,lcTableName+"."+lcFldName,DEFAULT_LOC)
								Endif
							Else
								lcDefaError = CANT_DROP_DEFA_LOC
							Endif
						Endif

						*If we're upsizing to SQL Server, need to bind default if successfully created
						If llDefaultCreated and this.SQLServer THEN
							llDefaultBound = this.BindDefault(lcRemoteDefaultName, lcRmtTableName, lcFldName)
						Else
							llDefaultBound=.F.
						Endif

					Endif

					Replace &lcEnumFields..Default with lcDefaultExpression, ;
						&lcEnumFields..RmtDefault with lcRemoteDefault, ;
						&lcEnumFields..RDName with lcRemoteDefaultName, ;
						&lcEnumFields..DefaExport WITH llDefaultCreated, ;
						&lcEnumFields..DefaBound WITH llDefaultBound, ;
						&lcEnumFields..DefaError WITH lcDefaError

					lcDefaultError=""
					lnError=.F.
				Endif
			Endscan
			Select (lcEnumTables)
		Endscan
		This.ThermRef.Complete

	Endproc


	Function MungeXbase
		Parameters lcLocalExpression, lcObjectType, lcLocalTableName, lcRemoteTableName

		*Takes an Xbase expression and replaces as many mappable keywords as possible
		*This leaves tons of potential keywords that will not work on SQL Server or Oracle

		Local lcServerSQL, lcRemoteExpression, lnOldArea, lcSetTalk, lcDelimiter, ;
			lnPos, lnPos1, lnPos2, lnPosMax

		*select expression mapping table
		lnOldArea = SELECT()
		lcSetTalk = SET('TALK')
		Set TALK OFF

		If !USED("ExprMap") THEN
			Select 0
			Use ExprMap EXCLUSIVE
			If this.ServerType = "Oracle" THEN
				Set FILTER TO !EMPTY(ExprMap.Oracle)
			Else
				Set FILTER TO !EMPTY(ExprMap.SQLServer)
			Endif
		Else
			Select ExprMap
		Endif

		lcRemoteExpression = ''
		Do WHILE !empty(lcLocalExpression)

			* find next language string (i.e. smallest positive lnPos or 0)
			lnPos  = AT("'", lcLocalExpression)
			lnPos1 = AT('"', lcLocalExpression)
			lnPos2 = AT('[', lcLocalExpression)
			lnMax  = LEN(lcLocalExpression) + 1
			lnPos = MIN(IIF(lnPos > 0, lnPos, lnMax), IIF(lnPos1 > 0, lnPos1, lnMax), IIF(lnPos2 > 0, lnPos2, lnMax))
			lnPos = IIF(lnPos = lnMax, 0, lnPos)

			If lnPos = 0
				lcLanguageString = lcLocalExpression
				lcLocalExpression = ''
			Else
				lcLanguageString = LEFT(lcLocalExpression, lnPos - 1)
				lcDelimiter = SUBSTR(lcLocalExpression, lnPos, 1)
				lcLocalExpression = SUBSTR(lcLocalExpression, lnPos + 1)
			Endif

			* convert language string to server native syntax
			If (!EMPTY(lcLanguageString))
				lcRemoteExpression = lcRemoteExpression + this.ConvertLanguageString(lcLanguageString, lcObjectType, ;
					lcLocalTableName, lcRemoteTableName)
			Endif

			* find next constant string
			If !EMPTY(lcLocalExpression)
				lcDelimiter = IIF(lcDelimiter == '[', ']', lcDelimiter)
				lnPos = AT(lcDelimiter, lcLocalExpression)
				If lnPos = 0
					lcConstantString = lcLocalExpression
					lcLocalExpression = ''
				Else
					lcConstantString = LEFT(lcLocalExpression, lnPos - 1)
					lcLocalExpression = SUBSTR(lcLocalExpression, lnPos + 1)
				Endif

				* convert language string to server native syntax
				If (!EMPTY(lcConstantString))
					lcRemoteExpression = lcRemoteExpression + "'" + this.ConvertConstantString(lcConstantString) + "'"
				Endif
			Endif

		Enddo

		Select (lnOldArea)
		Set TALK &lcSetTalk
		Return ALLTRIM(lcRemoteExpression)

	Endfunc

	Function ConvertLanguageString
		Parameters lcLocalExpression, lcObjectType, lcLocalTableName, lcRemoteTableName

		* Takes an Xbase expression and replaces mappable keywords, functions, names and date constants.
		* Fox function replacement is case-insensitive; Fox name replacement is case-sensitive.
		* This leaves some potential keywords that will not work on SQL Server or Oracle.

		Local lcServerSQL, lnOldArea, lcServerType, lcXbase, lcEnumFields, ;
			aFieldNames, lcExpression, lnOccurence, lnPos, I

		* go through all the keywords for the appropriate server type
		lcLocalExpression = LOWER(lcLocalExpression)
		lcLocalTableName = LOWER(RTRIM(lcLocalTableName))
		lcRemoteTableName = LOWER(RTRIM(lcRemoteTableName))
		lcMapField = IIF(this.ServerType = ORACLE_SERVER, "Oracle", "SqlServer")

		lcExpression = chr(1)+lcLocalExpression
		Scan
			If !ExprMap.Pad
				lcServerSQL = RTRIM(ExprMap.&lcMapField.)
			Else
				lcServerSQL = " "+ RTRIM(ExprMap.&lcMapField.) + " "
			Endif
			lcXbase = LOWER(RTRIM(ExprMap.FoxExpr))
			lcExpression = STRTRAN(lcExpression, lcXbase, LOWER(lcServerSQL))
		Endscan
		lcExpression = SUBSTR(lcExpression,2)

		*create an array of local and remote field names (where the two are different)
		lcEnumFields = RTRIM(this.EnumFieldsTbl)
		Dimension aFieldNames[1,2]
		Select LOWER(FldName), LOWER(RmtFldname) FROM (lcEnumFields) WHERE ;
			RTRIM(&lcEnumFields..TblName)=lcLocalTableName AND ;
			&lcEnumFields..FldName<>&lcEnumFields..RmtFldname ;
			INTO ARRAY aFieldNames

		*replace field names with remotized names in table validation rules
		If !EMPTY(aFieldNames) THEN
			For I=1 TO ALEN(aFieldNames,1)
				lcExpression = STRTRAN(lcExpression, RTRIM(aFieldNames[i,1]), RTRIM(aFieldNames[i,2]))
			Next
		Endif

		* replace table name with remotized table name
		lcExpression = STRTRAN(lcExpression, lcLocalTableName, lcRemoteTableName)

		* Convert and format date constants
		lcExpression = this.ConvertDates(lcExpression)

		Return ALLTRIM(lcExpression)

	Endfunc

	Function ConvertConstantString
		Parameters lcString
		Local lnPos, lnOccurrence

		* Takes a constant string expression that should be delimited by single quotes
		* in the remote expression. Replaces all internal single quotes (') with two single quotes ('')

		lnOccurence=1
		Do WHILE AT("'",lcString, lnOccurence) <> 0
			*Just add another chr(39) in front of each one we find
			lnPos = AT("'", lcString, lnOccurence)
			lcString = STUFF(lcString, lnPos, 1, CHR(39)+CHR(39))
			lnOccurence = lnOccurence+2
		Enddo

		Return lcString

	Endfunc

	Function HandleQuotes
		Parameters lcExpr, llNoContractions
		Local lnPos, lnOccurrence

		*Chr(39) is always a contraction in validation rule expressions, default
		*expressions, and validation messages.
		*Start with : "don't" ==> "'don''t'"
		*"create default foo_defa2 as 'don''t'"

		*If I know the string has no contractions, just replace doubles with singles

		If PARAMETERS()=1
			lnOccurence=1
			Do WHILE ATCC("'",lcExpr,lnOccurence)<>0
				*Just add another chr(39) in front of each one we find
				lnPos=ATCC("'",lcExpr,lnOccurence)
				lcExpr=STUFF(lcExpr,lnPos,1,CHR(39)+CHR(39))
				lnOccurence=lnOccurence+2
			Enddo
		Endif

		lcExpr=STRTRAN(lcExpr,CHR(34),CHR(39))
		Return lcExpr

	Endfunc

	Function ConvertDates
		Parameters lcExpression
		Local lcOccurence, lnPos1, lnPos2, ltDateTime, lcLocalDTString, lcRemoteDTString, ;
			lcCentury, lcDate, lnHour, lcSeconds, lcMark

		lnOccurence = 1
		Do WHILE .T.

			* find next date string
			lnPos1 = AT("{", lcExpression, lnOccurence)
			lnPos2 = AT("}", lcExpression, lnOccurence)
			If (lnPos1 = 0 or lnPos2 = 0 or lnPos1 > lnPos2)
				Exit
			Endif

			lcLocalDTString = SUBSTR(lcExpression, lnPos1, lnPos2 - lnPos1 + 1)
			ltDateTime = CTOT(SUBSTR(lcExpression, lnPos1 + 1, lnPos2 - lnPos1 -1))

			lcCentury = SET('CENTURY')
			lcDate = SET('DATE')
			lnHour = SET('HOUR')
			lcSeconds = SET('SECONDS')
			lcMark = SET('MARK')

			Set CENTURY ON
			Set DATE TO AMERICAN
			Set HOURS TO 12
			Set SECONDS ON
			Set MARK TO '/'

			lcRemoteDTString = DTOC(ltDateTime)

			Set CENTURY &lcCentury
			Set DATE TO &lcDate
			Set HOURS TO lnHour
			Set SECONDS &lcSeconds
			Set MARK TO lcMark

			* need exact format for Oracle
			If (this.ServerType == ORACLE_SERVER)
				lcRemoteDTString = "TO_DATE('" + lcRemoteDTString + "','MM/DD/YYYY HH:MI:SS AM')"
			Endif

			* need quotes for SqlServer
			If (this.SQLServer)
				lcRemoteDTString = "'" + lcRemoteDTString + "'"
			Endif

			lcExpression = STRTRAN(lcExpression, lcLocalDTString, lcRemoteDTString)
			lnOccurence	= lnOccurence + 1
		Enddo

		Return lcExpression

	Endfunc

	#If SUPPORT_ORACLE
	Function ConvertToTrigger
		Parameters lcRemoteExpression,lcRuleText,lcTableName,lcRmtTableName,lcRmtFldName
		Local lcCRLF, lcEnumFieldsTbl

		lcCRLF=CHR(10)+CHR(13)

		*Try to make expression Oracle-ish
		lcRemoteExpression=this.MungeXbase(lcRemoteExpression, "foo", lcTableName, lcRmtTableName)

		*make sure the user doesn't have stuff of the form <tblname>.<fldname> in there
		lcRemoteExpression=STRTRAN(lcRemoteExpression,lcRmtTableName+".")

		If EMPTY(lcRuleText) THEN
			If !EMPTY(lcRmtFldName) THEN
				*Oracle wants error messages to look like this:
				*'Value entered violates rule for field 'cust' in table 'customer'."
				*Note the use of single and double quotes is the exact opposite of SQL Server
				lcRuleText=STRTRAN(DEFLT_FLDMSG_LOC,"'|1'", gc2QT + lcRmtFldName + gc2QT)
				lcRuleText=STRTRAN(lcRuleText,"'|2'", gc2QT + lcRmtTableName + gc2QT)
			Else
				lcRuleText=STRTRAN(DEFLT_TBLMSG_LOC,"'|1'", gc2QT + lcRmtTableName + gc2QT)
			Endif
			lcRuleText="'"+lcRuleText+"'"
		Else

			*Replace existing single quotes with two single quotes (they should then appear as one single quote mark)
			lcSingle=CHR(39)
			lcRuleText=STRTRAN(lcRuleText,"'",lcSingle+lcSingle)
			*Replace all double quote marks with single quote marks
			lcRuleText=STRTRAN(lcRuleText, gcQT, "'")
		Endif

		*Build comment
		If !EMPTY(lcRmtFldName) THEN
			*We're dealing with a field validation rule
			*Need to replace <table>.<fldname> name with ":new.<fldname>"
			lcRemoteExpression=STRTRAN(lcRemoteExpression,lcRmtFldName,":new." + lcRmtFldName)
			lcSQL=this.BuildComment(FTRIG_COMMENT_LOC,lcRmtFldName)
		Else
			*Table validation rule
			lcSQL=this.BuildComment(TTRIG_COMMENT_LOC,"blah blah blah")

			*Get array of field names
			lcEnumFieldsTbl=this.EnumFieldsTbl
			Select RmtFldname FROM (lcEnumFieldsTbl) WHERE RTRIM(TblName)==lcTableName ;
				INTO ARRAY aFieldNames

			*Need to replace <fldname> name with ":new.<fldname>"
			For I=1 to ALEN(aFieldNames,1)
				lcRemoteExpression=STRTRAN(lcRemoteExpression,RTRIM(aFieldNames[i]),":new." + RTRIM(aFieldNames[i]))
			Next

		Endif

		*Complete SQL string
		lcSQL=lcSQL +	"IF NOT (" + lcRemoteExpression + ")" + lcCRLF
		lcSQL=lcSQL + 	"     THEN raise_application_error(" + ERR_SVR_RULEVIO_ORA + ", " + lcRuleText + ");" + lcCRLF
		lcSQL=lcSQL + 	"END IF ; " + lcCRLF

		Return lcSQL

	Endfunc
#Endif


#If SUPPORT_ORACLE
	Function TestTrigger
		Parameters lcTrigger, lcTable, lcFieldName, lnError, lcErrMsg

		*
		*Checks to see if a rule can be successfully converted to an Oracle trigger
		*

		*If user is just generating a script, just return .T.
		If !this.DoUpsize THEN
			Return .T.
		Endif

		*Put the trigger together
		lcSQL="CREATE TRIGGER " + lcTable + TRIG_NAME
		lcSQL=lcSQL+" BEFORE INSERT OR UPDATE "
		If !EMPTY(lcFieldName) THEN
			lcSQL=lcSQL+" OF " + lcFieldName
		Endif
		lcSQL=lcSQL + " ON " + lcTable + " FOR EACH ROW BEGIN "
		lcSQL=lcSQL + lcTrigger + "END;"

		*Run it up the flag pole...

		If !this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg) THEN
			Return .F.
		Else
			*Drop the trigger
			lcSQL="DROP TRIGGER " + lcTable + TRIG_NAME
			=this.ExecuteTempSPT(lcSQL)
			Return .T.
		Endif

	Endfunc
#Endif


	Function ConvertToSproc
		Parameters lcExpression, lcMessage, lcTableName, lcRmtTableName,  lcObjectType, lcSprocName, lcFldName

		*
		*Takes an Xbase rule and turns it into a stored procedure
		*

		*Do what you can to make the Xbase expression work on the server
		lcExpression=this.MungeXbase(lcExpression, lcObjectType, lcTableName, lcRmtTableName)

		Local lcSQL, lcCRLF
		lcCR=CHR(10)
		lcCRLF=CHR(10)+CHR(13)

		*if there's no error message, build a default one
		If EMPTY(lcMessage) THEN
			If lcObjectType="Field" THEN
				lcMessage=STRTRAN(DEFLT_FLDMSG_LOC,'|1',lcFldName)
				lcMessage=STRTRAN(lcMessage,'|2',lcTableName)
			Else
				lcMessage=STRTRAN(DEFLT_TBLMSG_LOC,'|1',lcTableName)
			Endif
		Endif

		*need to operate on error message to make sure quotes are right
		lcMessage=this.HandleQuotes(lcMessage)
		If LEFT(lcMessage,1)<>CHR(39)
			lcMessage=chr(39)+ lcMessage + chr(39)
		Endif

		*Operate on the sproc name
		If lcObjectType="Field" THEN
			*For field validation sprocs, the aim is to get something
			*like "vrf_customer_lname"
			lcSprocName=this.NameObject(lcRmtTableName,lcFldName,FLD_SPROC_PREFIX,MAX_NAME_LENGTH)
		Else
			lcSprocName=TBL_SPROC_PREFIX + LEFT(lcRmtTableName,MAX_NAME_LENGTH-LEN(FLD_SPROC_PREFIX))
		Endif

		lcSQL=        "CREATE PROCEDURE " + lcSprocName + " @status char(10) output AS" + lcCRLF
		lcSQL=lcSQL + "/*" + lcCR
		lcSQL=lcSQL + " * TABLE VALIDATION RULE FOR " + gcQT + lcRmtTableName + gcQT + lcCR
		lcSQL=lcSQL + " */"  + lcCRLF + lcCRLF
		lcSQL=lcSQL + "IF @status='Failed'"+lcCR
		lcSQL=lcSQL + "      RETURN" +lcCRLF
		lcSQL=lcSQL + "IF (SELECT Count(*) FROM " + lcRmtTableName + " WHERE NOT (" + lcExpression + ")) > 0" + lcCR
		lcSQL=lcSQL + "      BEGIN" + lcCR
		lcSQL=lcSQL + "           RAISERROR " + ERR_SVR_RULEVIO_SQL +  " " + lcMessage +  lcCR
		lcSQL=lcSQL + "           SELECT @status='Failed'" + lcCR
		lcSQL=lcSQL + "      END" + lcCR
		lcSQL=lcSQL + "ELSE" + lcCR
		lcSQL=lcSQL + "      BEGIN" + lcCR
		lcSQL=lcSQL + "          SELECT @status='Succeeded'" + lcCR
		lcSQL=lcSQL + "      END" + lcCRLF

		Return lcSQL

	Endfunc


	Function ConvertToDefault
		Parameters lcDefaultExpression, lcFieldName, lcTableName, lcRemTableName, lcRemoteDefaultName
		Local lcSQL

		* Defaults become ALTER TABLE statements for Oracle and Defaults on SQL Server
		* Try to make Xbase expression more server like

		lcDefaultExpression = this.MungeXbase(lcDefaultExpression, "Field", lcTableName, "")

		* 1/8/01 jvf, Bug ID 155006, VFP7:Upsizing Wizard Does not Create Default Value
		* If the defaul tvalue = [""] (without brackets) then an error occurs
		* because 'lcDefaultExpression' will be empty...
		* (eg, "CREATE DEFAULT <lcRemoteDefaultName> AS <lcDefaultExpression>")
		* so checking for this and setting 'lcDefaultExpression' to "''" will solve the problem.
		IF EMPTY(lcDefaultExpression) THEN
           lcDefaultExpression = "''"
		ENDIF

		If this.ServerType = ORACLE_SERVER THEN
			lcSQL = "ALTER TABLE " + lcRemTableName + " MODIFY (" + lcFieldName + " DEFAULT " + lcDefaultExpression + ")"
		Endif

		If this.SQLServer THEN
			lcRemoteDefaultName = this.NameObject(lcTableName, lcFieldName, DEFAULT_PREFIX,MAX_NAME_LENGTH)
			lcSQL = "CREATE DEFAULT " + lcRemoteDefaultName + " AS " + lcDefaultExpression
		Endif

		Return lcSQL

	Endfunc


	Function ConvertToConstraint
		Parameters lcRuleExpression, lcTableName, lcRemTableName, lcConstName
		Local lcSQL

		* Convert rules into table and field constraints for Oracle and SQL Server
		lcRuleExpression = this.MungeXbase(lcRuleExpression, "Field", lcTableName, "")

		If this.ServerType = ORACLE_SERVER
			lcSQL = "ALTER TABLE " + lcRemTableName + ;
				" ADD (CONSTRAINT " + lcConstName + " CHECK(" + lcRuleExpression + "))"
		Endif

		* For future use
		If this.SQLServer THEN
		Endif

		Return lcSQL
	Endfunc


	Function BindDefault
		Parameters lcRemoteDefaultName, lcRmtTableName,lcFldName
		Local lcSQL, llRetVal

		*bind a default to a field

		lcSQL="sp_bindefault " + lcRemoteDefaultName + ", " ;
			+ "'" + lcRmtTableName + "." + lcFldName + "'"

		llRetVal=this.ExecuteTempSPT(lcSQL)

		Return llRetVal

	Endfunc


	Function ZeroDefault
		Local lcSQL, llRetVal, llDefaultExists, dummy,lcSQT

		If this.ZeroDefaultCreated THEN
			Return .T.
		Else
			lcSQT=CHR(39)
			lcSQL="select uid from sysobjects where name =" + lcSQT + ZERO_DEFAULT_NAME + lcSQT
			llDefaultExists=this.SingleValueSPT(lcSQL, dummy, "uid")
			*Only create it if it doesn't exist already
			If !llDefaultExists THEN
				lcSQL= "CREATE DEFAULT " + ZERO_DEFAULT_NAME + " AS 0"
				llRetVal=this.ExecuteTempSPT(lcSQL)
				This.ZeroDefaultCreated=llRetVal
				Return llRetVal
			Else
				Return .T.
			Endif
		Endif

	Endfunc


	Procedure BuildRiCode

		*
		* Generates an ALTER TABLE statement for Oracle, code for trigger for SQL Server
		* for all relations between tables that are being upsized
		*

		Local lcEnumTables, lnOldArea, lcTableName, aFldNames, lcCRLF, ;
			aNewForeign, aNewPrimary, llRetVal, lcErr, llSkipChildTbl, ;
			lcEnumRelsTbl,lcEnum_Indexes, lcUpdateType, lcDeleteType, ;
			lcInsertType, lnTableCount, lcThermMsg, lcXPkey, ;
			lcParentLoc, lcChildLoc, lnError, lcErrMsg, lcOParen, lcCParen

		lcCRLF = CHR(13)
		lnOldArea = SELECT()
		lcEnumTables = this.EnumTablesTbl

		* Go grab all the relation information for tables in the source database
		This.GetRiInfo
		lcEnumRelsTbl = this.EnumRelsTbl
		lcEnum_Indexes = this.EnumIndexesTbl

		* We only want to deal with relations where both tables were successfully upsized or,
		* if we're generating a script, relations where both tables were selected to upsize
		Select (lcEnumRelsTbl)
		Scan
			If this.TableUpsized(RTRIM(&lcEnumRelsTbl..DD_PARENT)) ;
					AND this.TableUpsized(RTRIM(&lcEnumRelsTbl..DD_CHILD)) THEN
				Replace Export WITH .T.
			Else
				Replace Export WITH .F.
			Endif
		Endscan

		Select COUNT(*) FROM (lcEnumRelsTbl) WHERE Export=.T. INTO ARRAY aTableCount
		lnTableCount=0
		This.InitTherm(BUILDING_RI_LOC,aTableCount,0)

		Scan FOR Export = .T.
			lcParent=RTRIM(&lcEnumRelsTbl..Dd_RmtPar)
			lcChild=RTRIM(&lcEnumRelsTbl..Dd_RmtChi)
			lcParentLoc=RTRIM(&lcEnumRelsTbl..DD_PARENT)
			lcChildLoc=RTRIM(&lcEnumRelsTbl..DD_CHILD)
			lcNewPrimary=RTRIM(&lcEnumRelsTbl..DD_PAREXPR)
			lcNewForeign=RTRIM(&lcEnumRelsTbl..DD_CHIEXPR)
			llClustIdxOK=.T.

			* Therm stuff
			lcThermMsg = STRTRAN(RI_THIS_LOC,'|1',lcParentLoc)
			lcThermMsg = STRTRAN(lcThermMsg,'|2',lcChildLoc)
			This.UpDateTherm(lnTableCount,lcThermMsg)
			lnTableCount = lnTableCount+1

			* Pick up what kind of relation type this is
			lcUpdateType = &lcEnumRelsTbl..dd_update
			lcDeleteType = &lcEnumRelsTbl..dd_delete
			lcInsertType = &lcEnumRelsTbl..dd_insert

			* For report
			If lcUpdateType = "I" AND lcDeleteType = "I" AND lcInsertType = "I" ;
					AND EMPTY(&lcEnumRelsTbl..ClustName) THEN
				Replace &lcEnumRelsTbl..Exported WITH .F.
			Else
				Replace &lcEnumRelsTbl..Exported WITH .T.
			Endif

			* Turn fields in keys into an array (used later all over the place)
			Dimension aNewForeign[1], aNewPrimary[1]
			aNewForeign[1]=""
			aNewPrimary[1]=""
			This.KeyArray(lcNewForeign,@aNewForeign)
			This.KeyArray(lcNewPrimary,@aNewPrimary)

			* do simple comparison of keys in case they won't match up
			If ALEN(aNewForeign,1)<>ALEN(aNewPrimary,1) THEN
				*mark the relation as unupsizable and move to the next relation
				This.StoreError(.NULL.,"", "", KEYS_MISMATCH_LOC,lcParent+":"+lcChild,RI_LOC)
				Replace RIError WITH KEYS_MISMATCH_LOC, Exported WITH .F.
				Loop
			Endif

			* Make sure keyfields are less than 17
			If ALEN(aNewForeign,1)>MAX_INDEX_FIELDS THEN
				*mark the relation as unupsizable and move to the next relation
				Replace RIError WITH TOO_MANY_FIELDS_LOC, Exported WITH .F.
				This.StoreError(.NULL.,"", "", TOO_MANY_FIELDS_LOC,lcParent+":"+lcChild,RI_LOC)
				Loop
			Endif

			* Here's the RI plan:
			*SQL Server: use triggers for everything
			*Oracle: create two triggers that enforces RI via SQL *OR*
			*use DRI (which won't cascade updates)
			*SQL '95: create triggers for everything *OR*
			*use DRI (which won't cascade updates or deletes)
			*note: this code currently is not aware of SQL '95

			*
			* This block of code handles DRI for SQL '95 and Oracle
			* For SQL '95 it implements Update-restrict and Delete-restrict
			* For Oracle, it also implements Delete-cascades
			*

			If this.ExportDRI AND ;
					(this.ServerType = "Oracle" OR this.ServerType = "SQL Server95")
				*Implement RI constraints at table level since foreign key may be compound

				*Deal with parent table first (or child constraints will fail)

				*See if the table already has a primary key that's correct for RI purposes
				*(i.e. the same as the one we'd create anyway)

				Select (lcEnumTables)
				Locate FOR RTRIM(TblName)==lcParent

				*Here are the cases handled below:
				*has no primary key: add pkey, convert old non-pkey index to type pkey,
				*mark as already created so it doesn't get recreated
				*has primary key, it's right: create the pkey now and mark the index
				*as created
				*has primary key, it's wrong: log error

				lcXPkey=RTRIM(&lcEnumTables..PkeyExpr)
				lcTagName=RTRIM(&lcEnumTables..PKTagName)
				If lcXPkey==lcNewPrimary OR EMPTY(lcXPkey)THEN

					If lcTagName=="" THEN
						lcConstraintName=STRTRAN(lcNewPrimary,",")
						lcConstraintName=PRIMARY_KEY_PREFIX + LEFT(lcConstraintName, MAX_NAME_LENGTH-LEN(PRIMARY_KEY_PREFIX))
					Else
						lcConstraintName=lcTagName
					Endif
					lcConstraintName=this.UniqueOraName(lcConstraintName)

					If this.ServerType="Oracle" THEN
						lcOParen="("
						lcCParen=")"
					Else
						lcOParen=""
						lcCParen=""
					Endif

					*Add primary key constraint
					lcSQL="ALTER TABLE " + lcParent
					lcSQL=lcSQL + " ADD " + lcOParen + "CONSTRAINT "
					lcSQL=lcSQL + lcConstraintName + " PRIMARY KEY"
					lcSQL=lcSQL + " (" + lcNewPrimary + ")" + lcCParen

					*Execute the statement if appropriate

					If this.DoUpsize THEN
						llRetVal=this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg)
						If !llRetVal THEN
							This.StoreError(lnError, lcErrMsg, lcSQL, DRI_ERR_LOC,lcParent,RI_LOC)
						Endif
					Endif

					Select (lcEnum_Indexes)
					Locate FOR UPPER(RTRIM(IndexName))==UPPER(lcParentLoc) ;
						AND UPPER(RTRIM(RmtExpr))==UPPER(lcNewPrimary)
					If EMPTY(lcXPkey) THEN
						*If the table had no true primary key, change the index acting
						*as primary key to a real primary key (even though we just created it)
						*This is done just for the purposes of the report and the SQL script
						Replace &lcEnum_Indexes..RmtType WITH "PRIMARY KEY", ;
							&lcEnum_Indexes..Exported WITH llRetVal, ;
							&lcEnum_Indexes..IndexSQL WITH lcSQL, ;
							&lcEnum_Indexes..RmtName WITH lcConstraintName
					Else
						*Mark the index as already created
						Replace &lcEnum_Indexes..Exported WITH llRetVal, ;
							&lcEnum_Indexes..IndexSQL WITH lcSQL
					Endif
					Select (lcEnumTables)
					llSkipChildTbl=.F.

				Else

					*log error that this rel couldn't be created because table has
					*more than one primary key
					lcErr=STRTRAN(MULTIPLE_PKEYS_LOC,"|1",lcParent)
					Select (lcEnumRelsTbl)
					Replace RIError WITH lcErr ADDITIVE
					llSkipChildTbl=.T.

				Endif

				*Deal with child table
				If !llSkipChildTbl THEN

					lcConstraintName=STRTRAN(lcNewForeign,",")
					lcConstraintName=FOREIGN_KEY_PREFIX + LEFT(lcConstraintName, MAX_NAME_LENGTH-LEN(FOREIGN_KEY_PREFIX))
					lcConstraintName=this.UniqueOraName(lcConstraintName)

					lcSQL="ALTER TABLE " + lcChild
					lcSQL=lcSQL + " ADD " +lcOParen + "CONSTRAINT "
					lcSQL=lcSQL + lcConstraintName +  " FOREIGN KEY "
					lcSQL=lcSQL + " (" + lcNewForeign + ")"
					lcSQL=lcSQL + " REFERENCES " + lcParent + " (" + lcNewPrimary +")"

					*SQL95 does not support cascading deletes
					*Neither Oracle nor SQL95 support cascading updates via DRI
					If lcDeleteType=CASCADE_CHAR_LOC AND this.ServerType="Oracle" THEN
						lcSQL=lcSQL + " ON DELETE CASCADE)"
					Else
						lcSQL=lcSQL + lcCParen
					Endif

					*Execute the statement if appropriate
					If this.DoUpsize AND llRetVal THEN
						llRetVal=this.ExecuteTempSPT(lcSQL,@lnError, @lcErrMsg)
						If !llRetVal THEN
							This.StoreError(lnError, lcErrMsg, lcSQL, DRI_ERR_LOC,lcChild,RI_LOC)
						Endif
					Endif

					*Add comment and tack on to existing table definition sql
					lcSQL = lcCRLF + lcCRLF + ORA_FKEY_COMMENT_LOC + lcCRLF + lcSQL
					This.StoreRiCode(lcChild,"TableSQL",lcSQL,"FKeyCrea",llRetVal)

					Select (lcEnumRelsTbl)

				Endif

				Loop	&& continue after DRI code

			Endif
			*End of DRI code

			* PARENT DELETE RI
			* Prevents deleting a PARENT record for which CHILD records exist,
			* or deletes dependent CHILD records (cascading).

			* PARENT DELETE for SQL 4.x or SQL '95 and cascade delete
			If (this.SQLServer AND lcDeleteType <> IGNORE_CHAR_LOC) THEN

				lcRestr = this.BuildRestr(@aNewPrimary, "deleted", @aNewForeign, lcChild, "AND")
				If lcDeleteType = CASCADE_CHAR_LOC THEN
					lcSQL = this.BuildComment(CASCADE_DELETES_LOC, lcChild)
					lcSQL = lcSQL + "DELETE " + lcChild + " FROM deleted, " + lcChild +  " WHERE " + lcRestr + lcCRLF
				Else
					lcErrMsg = this.HandleQuotes(gcQT + STRTRAN(DEPENDENT_ROWS_LOC,"|1",lcChild) + gcQT)
					lcSQL= this.BuildComment(PREVENT_DELETES_LOC, lcChild)
					lcSQL= lcSQL + "IF (SELECT COUNT(*) FROM deleted, " + lcChild + " WHERE (" + lcRestr + ")) > 0" + lcCRLF
					lcSQL= lcSQL + "    BEGIN" + lcCRLF
					lcSQL= lcSQL + "    RAISERROR " + ERR_SVR_DELREFVIO + " " + lcErrMsg + lcCRLF
					lcSQL= lcSQL + "    SELECT @status='Failed'" + lcCRLF
					lcSQL= lcSQL + "    END" + lcCRLF
				Endif

				*save this code
				This.StoreRiCode(lcParent,"DeleteRI",lcSQL)
			Endif

			* PARENT DELETE for Oracle
			If this.ServerType = "Oracle" AND lcDeleteType <> IGNORE_CHAR_LOC

				lcRestr = this.BuildRestr(@aNewForeign, lcChild, @aNewPrimary, ":old", "AND")
				If lcDeleteType = CASCADE_CHAR_LOC THEN
					lcSQL = this.BuildComment(CASCADE_DELETES_LOC, lcChild)
					lcSQL = lcSQL + "IF DELETING THEN " + lcCRLF
					lcSQL = lcSQL + "    DELETE FROM " + lcChild +  " WHERE " + lcRestr + ";" + lcCRLF
					lcSQL = lcSQL + "END IF;" + lcCRLF
				Else
					lcErrMsg = "'" + STRTRAN(DEPENDENT_ROWS_LOC, "'|1'", gc2QT + lcChild + gc2QT) + "'"
					lcSQL = this.BuildComment(PREVENT_DELETES_LOC, lcChild)
					lcSQL = lcSQL + "IF DELETING THEN " + lcCRLF
					lcSQL = lcSQL + "    SELECT COUNT(*) INTO " + REC_COUNT_VAR + " FROM " + lcChild + " WHERE (" + lcRestr + ");" + lcCRLF
					lcSQL = lcSQL + "    IF " + REC_COUNT_VAR + " > 0 THEN " + lcCRLF
					lcSQL = lcSQL + "        raise_application_error(" + ERR_SVR_DELREFVIO_ORA + ", " + lcErrMsg + ");" + lcCRLF
					lcSQL = lcSQL + "    END IF;" + lcCRLF
					lcSQL = lcSQL + "END IF;" + lcCRLF
				Endif

				* save this code
				This.StoreRiCode(lcParent, "DeleteRI", lcSQL)

			Endif

			* PARENT UPDATE trigger
			* Prevents changing a PARENT key for which CHILD records exist,
			* or keeps CHILD keys in sync with PARENT keys (cascading).
			* Executed only if SQL Server or if Oracle or SQL '95 when updates are cascaded
			* Handle SQL Server (4.x or '95) case here

			* PARENT UPDATE for Sql Server
			If this.SQLServer AND lcUpdateType <> IGNORE_CHAR_LOC

				lcRestr = this.BuildRestr(@aNewPrimary, "deleted", @aNewForeign, lcChild, "AND")
				If lcUpdateType = CASCADE_CHAR_LOC THEN
					lcSQL = this.BuildComment(CASCADE_UPDATES_LOC,lcChild)
				Else
					lcSQL = this.BuildComment(PREVENT_M_UPDATES_LOC,lcChild)
				Endif
				lcSQL = lcSQL + "IF " + this.BuildUpdateTest(@aNewPrimary)
				lcSQL = lcSQL + " AND @status<>'Failed'" + lcCRLF
				lcSQL = lcSQL + "    BEGIN" + lcCRLF
				If lcUpdateType=CASCADE_CHAR_LOC THEN
					lcSetKeys = this.BuildRestr(@aNewForeign, lcChild, @aNewPrimary, "inserted", ",")
					lcSQL = lcSQL + "         UPDATE " + lcChild + lcCRLF
					lcSQL = lcSQL + "         SET " + lcSetKeys + lcCRLF
					lcSQL = lcSQL + "         FROM " + lcChild + ", deleted, inserted" + lcCRLF
					lcSQL = lcSQL + "         WHERE " + lcRestr + lcCRLF
				Else
					lcErrMsg=this.HandleQuotes(gcQT+STRTRAN(DEPENDENT_ROWS_LOC,"|1",lcChild)+ gcQT)
					lcSQL = lcSQL + "    IF (SELECT COUNT(*) FROM deleted, " + lcChild + " WHERE (" + lcRestr + ")) > 0" + lcCRLF
					lcSQL = lcSQL + "        BEGIN" + lcCRLF
					lcSQL = lcSQL + "            RAISERROR " + ERR_SVR_DELREFVIO + " " + lcErrMsg + lcCRLF
					lcSQL = lcSQL + "            SELECT @status='Failed'" + lcCRLF
					lcSQL = lcSQL + "            END" + lcCRLF
				Endif
				lcSQL = lcSQL + "    END" + lcCRLF

				*save this code
				This.StoreRiCode(lcParent, "UpdateRI", lcSQL)
			Endif

			* PARENT UPDATE for Oracle
			If this.ServerType = "Oracle" AND lcUpdateType <> IGNORE_CHAR_LOC

				lcRestr = this.BuildRestr(@aNewForeign, lcChild, @aNewPrimary, ":old", "AND")
				lcUpdTest = this.BuildRestr(@aNewForeign, ":old", @aNewPrimary, ":new", "OR")
				lcUpdTest = STRTRAN(lcUpdTest,"=","!=")
				If lcUpdateType = CASCADE_CHAR_LOC THEN
					lcSQL = this.BuildComment(CASCADE_UPDATES_LOC, lcChild)
				Else
					lcSQL = this.BuildComment(PREVENT_M_UPDATES_LOC, lcChild)
				Endif
				If lcUpdateType = CASCADE_CHAR_LOC THEN
					lcSetKeys = this.BuildRestr(@aNewForeign, lcChild, @aNewPrimary, ":new", ",")
					lcSQL = lcSQL + "IF UPDATING AND " + lcUpdTest + " THEN" + lcCRLF
					lcSQL = lcSQL + "    UPDATE " + lcChild + lcCRLF
					lcSQL = lcSQL + "    SET " + lcSetKeys + lcCRLF
					lcSQL = lcSQL + "    WHERE " + lcRestr + ";" + lcCRLF
					lcSQL = lcSQL + "END IF;" + lcCRLF
				Else
					lcErrMsg = "'" + STRTRAN(DEPENDENT_ROWS_LOC, "'|1'", gc2QT + lcChild + gc2QT) +  "'"
					lcSQL = lcSQL + "IF UPDATING AND " + lcUpdTest + " THEN" + lcCRLF
					lcSQL = lcSQL + "    SELECT COUNT(*) INTO " + REC_COUNT_VAR + " FROM " + lcChild + " WHERE (" + lcRestr + ");" + lcCRLF
					lcSQL = lcSQL + "    IF " + REC_COUNT_VAR + " > 0 THEN" + lcCRLF
					lcSQL = lcSQL + "        raise_application_error(" + ERR_SVR_UPDREFVIO_ORA + ", " + lcErrMsg + ");" + lcCRLF
					lcSQL = lcSQL + "    END IF;" + lcCRLF
					lcSQL = lcSQL + "END IF;" + lcCRLF
				Endif

				This.StoreRiCode(lcParent, "UpdateRI", lcSQL)

			Endif

			* CHILD UPDATE trigger
			* Prevents changing or adding a CHILD record to a key not in the PARENT table
			* CHILD INSERT trigger
			* Prevents adding a CHILD record for which no PARENT record exists

			* CHILD UPDATE AND INSERT for SQL Server 4.x and 95
			If this.SQLServer THEN

				* CHILD UPDATE trigger
				If lcUpdateType = RESTRICT_CHAR_LOC THEN
					lcRestr = this.BuildRestr(@aNewPrimary, lcParent, @aNewForeign, "inserted", "AND")
					lcErrMsg = this.HandleQuotes(gcQT + STRTRAN(CANT_ORPHAN_LOC, "|1",lcParent) + gcQT)

					lcSQL = this.BuildComment(PREVENT_C_UPDATES_LOC, lcParent)
					lcSQL = lcSQL + "IF " + this.BuildUpdateTest(@aNewForeign)
					lcSQL =lcSQL + " AND @status<>'Failed'" + lcCRLF
					lcSQL = lcSQL + "    BEGIN" + lcCRLF
					lcSQL = lcSQL + "IF (SELECT COUNT(*) FROM inserted) !=" + lcCRLF
					lcSQL = lcSQL + "           (SELECT COUNT(*) FROM " + lcParent + ", inserted WHERE (" + lcRestr + "))" + lcCRLF
					lcSQL = lcSQL + "            BEGIN" + lcCRLF
					lcSQL = lcSQL + "                RAISERROR " + ERR_SVR_UPDREFVIO + " " + lcErrMsg + lcCRLF
					lcSQL = lcSQL + "                SELECT @status = 'Failed'" + lcCRLF
					lcSQL = lcSQL + "            END" + lcCRLF
					lcSQL = lcSQL + "    END" + lcCRLF

					*save this code
					This.StoreRiCode(lcChild,"UpdateRI",lcSQL)

				Endif

				* CHILD INSERT trigger
				If lcInsertType = RESTRICT_CHAR_LOC
					lcErrMsg = this.HandleQuotes(gcQT+ STRTRAN(CANT_ORPHAN_LOC,"|1",lcParent) + gcQT)
					lcRestr = this.BuildRestr(@aNewPrimary, lcParent, @aNewForeign, "inserted", "AND")
					lcSQL = this.BuildComment(PREVENT_INSERTS_LOC, lcParent)
					lcSQL = lcSQL + "IF @status<>'Failed'" + lcCRLF
					lcSQL = lcSQL + "    BEGIN" + lcCRLF
					lcSQL = lcSQL + "    IF(SELECT COUNT(*) FROM inserted) !=" + lcCRLF
					lcSQL = lcSQL + "   (SELECT COUNT(*) FROM " + lcParent + ", inserted WHERE (" + lcRestr + "))" + lcCRLF
					lcSQL = lcSQL + "        BEGIN" + lcCRLF
					lcSQL = lcSQL + "            RAISERROR " + ERR_SVR_UPDREFVIO + " " + lcErrMsg + lcCRLF
					lcSQL = lcSQL + "            SELECT @status='Failed'" + lcCRLF
					lcSQL = lcSQL + "        END" + lcCRLF
					lcSQL = lcSQL + "    END" + lcCRLF

					*save this code
					This.StoreRiCode(lcChild,"InsertRI",lcSQL)

				Endif
			Endif

			* CHILD UPDATE AND INSERT for Oracle
			If this.ServerType = "Oracle" AND ;
					(lcUpdateType = RESTRICT_CHAR_LOC OR lcInsertType = RESTRICT_CHAR_LOC)

				lcUpdTest = this.BuildRestr(@aNewForeign, ":old", @aNewPrimary, ":new", "OR")
				lcUpdTest = STRTRAN(lcUpdTest, "=", "!=")

				lcRestr = this.BuildRestr(@aNewPrimary, lcParent, @aNewForeign, ":new", "AND")
				lcErrMsg = "'" + STRTRAN(CANT_ORPHAN_LOC, "'|1'", gc2QT + lcParent + gc2QT) + "'"
				lcSQL = this.BuildComment(PREVENT_SELF_O_LOC, lcParent)
				lcSQL = lcSQL + "IF (UPDATING AND " + lcUpdTest + ") OR INSERTING THEN" + lcCRLF
				lcSQL = lcSQL + "    SELECT COUNT(*) INTO " + REC_COUNT_VAR + " FROM " + lcParent + " WHERE (" + lcRestr + ");" + lcCRLF
				lcSQL = lcSQL + "    IF " + REC_COUNT_VAR + " = 0 THEN" + lcCRLF
				lcSQL = lcSQL + "        raise_application_error(" + ERR_SVR_UPDREFVIO_ORA + ", " + lcErrMsg + ");" + lcCRLF
				lcSQL = lcSQL + "    END IF;" + lcCRLF
				lcSQL = lcSQL + "END IF;" + lcCRLF

				*save this code
				This.StoreRiCode(lcChild,"UpdateRI",lcSQL)
			Endif

			*If we're dealing with SQL Server, run sp_primarykey, sp_foreignkey
			If this.ServerType <> "Oracle" AND ALEN(aNewPrimary,1) <= 8 AND !this.ExportDRI THEN
				*Check if the table is in multiple rels
				Select COUNT(*) FROM (lcEnumRelsTbl) WHERE RTRIM(DD_PARENT)==lcParent ;
					AND !DD_CHIEXPR=="" and !DD_PAREXPR=="" INTO ARRAY aDupeCount
				If aDupeCount>1 THEN
					*check to see if the local table has a primary key index
					Select RmtExpr FROM (lcEnum_Indexes) WHERE RTRIM(IndexName)==lcParent ;
						AND LclIdxType="Primary key" INTO ARRAY aIndexExpr
					*If primary key index expression is same as RI primary key, run sp_primary key
					If RTRIM(aIndexExpr)==lcNewPrimary THEN
						This.SetPKey(lcParent,lcNewPrimary)
						This.SetFKey(lcChild,lcNewForeign,lcParent)
					Else
						This.SetCommonKey(lcParent,@aNewPrimary,lcChild,@aNewForeign)
					Endif
				Else
					This.SetPKey(lcParent,lcNewPrimary)
					This.SetFKey(lcChild,lcNewForeign,lcParent)
				Endif
			Endif

		Endscan
		This.ThermRef.complete
		Select (lnOldArea)

	Endproc


	Procedure SetCommonKey
		Parameters lcTable1, aNewPrimary, lcTable2, aNewForeign
		Local lcSQL
		lcSQL="sp_commonkey " + lcTable1 + ", " + lcTable2
		For I=1 to ALEN(aNewPrimary,1)
			lcSQL=lcSQL + ", " + aNewPrimary[i] + ", " + aNewForeign[i]
		Next
		=this.ExecuteTempSPT(lcSQL)
	Endproc


	Procedure SetPKey
		Parameters lcTable, lcKey
		Local lcSQL
		lcSQL="sp_primarykey " + lcTable + ", " + lcKey
		=this.ExecuteTempSPT(lcSQL)
	Endproc


	Procedure SetFKey
		Parameters lcChild, lcChildKey, lcParent
		Local lcSQL
		lcSQL="sp_foreignkey " + lcChild +", " + lcParent + ", " + lcChildKey
		=this.ExecuteTempSPT(lcSQL)
	Endproc


	Function BuildComment
		Parameters lcMainComment, lcToInsert
		Local lcCRLF
		#Define SEARCH_TOKEN "|1"

		lcCRLF = CHR(13)
		lcMainComment = STRTRAN(lcMainComment, SEARCH_TOKEN, lcToInsert)
		lcComment= lcCRLF + "/* " + lcMainComment + " */" + lcCRLF
		Return lcComment

	Endfunc


	Procedure KeyArray
		Parameters lcKeyString, aKeyArray

		*Takes comma separated list of fields in a key and converts it to an array

		lcKeyString=lcKeyString+ ","
		Do WHILE !lcKeyString==""
			This.InsaItem(@aKeyArray,ALLTRIM(LEFT(lcKeyString,AT(",",lcKeyString)-1)))
			lcKeyString=SUBSTR(lcKeyString,AT(",",lcKeyString)+1)
		Enddo

	Endproc


	Function BuildRestr
		Parameters aNewPrimary, lcParent, aNewForeign, lcChild, lcConjunction
		Local lcBuildRestr

		*Creates a restriction string, e.g. "customer.cust.id=order.cust_id"

		lcBuildRestr=""
		For I=1 to ALEN(aNewPrimary,1)
			If I>1 THEN
				lcBuildRestr=lcBuildRestr + " " + lcConjunction + " "
			Endif
			lcBuildRestr=lcBuildRestr + lcParent + "." + aNewPrimary[i] + " = " + 	;
				lcChild + "." + aNewForeign[i]
		Next
		Return lcBuildRestr

	Endfunc


	Function BuildUpdateTest
		Parameters aKeyFields
		Local lcSQL, I
		lcSQL=""

		For I = 1 To ALEN(aKeyFields,1)
			If I > 1 THEN
				lcSQL= lcSQL + " OR "
			Endif
			lcSQL= lcSQL + "UPDATE(" + aKeyFields[i] + ")"
		Next
		Return lcSQL

	Endfunc


	Procedure StoreRiCode
		Parameters lcRmtTblName, lcFldName1, lcSQL, lcFldName2, llRetVal
		Local lnOldArea

		lnOldArea=SELECT()
		lcEnumTablesTbl=this.EnumTablesTbl
		Select (lcEnumTablesTbl)
		Locate FOR RTRIM(RmtTblName)==RTRIM(lcRmtTblName)

		Replace &lcEnumTablesTbl..&lcFldName1 WITH lcSQL ADDITIVE

		If PARAM()=4 THEN
			Replace &lcEnumTablesTbl..&lcFldName2 WITH llRetVal
		Endif

		Select (lnOldArea)

	Endproc


	Procedure CreateTriggers
		Local lcTableName, lcCRLF, lcDeleteRI,lcInsertRI,lcUpdateRI, lcSproc, ;
			lcEnumFields, lnOldArea, lnTableCount, lcTrigName, lnError, lcErrMsg, ;
			lcUpdateType, lcDeleteType, lcInsertType
		lnOldArea = SELECT()
		llRetVal = .F.
		lcCRLF = CHR(13)

		lcEnumTables = RTRIM(this.EnumTablesTbl)
		lcEnumRelsTbl = RTRIM(this.EnumRelsTbl)

		Select (lcEnumTables)
		lnTableCount = 0

		If !this.ExportRelations AND !this.ExportDefaults AND !this.ExportValidation THEN
			Return
		Endif

		*Thermometer stuff
		Select COUNT(*) FROM (lcEnumTables) WHERE &lcEnumTables..Export=.T. ;
			INTO ARRAY aTableCount
		This.InitTherm(CREA_TRIGGERS_LOC,aTableCount,0)
		lnTableCount=0

		If this.ServerType = "Oracle"
			#If SUPPORT_ORACLE
				* Oracle: Create up to two row triggers
				* before update and insert: insert ri, restrict update ri, restrict delete ri (AT)
				* after update or delete: cascade update ri, cascade delete ri (AT)

				Scan FOR Export = .T. AND (!EMPTY(InsertRI) OR !EMPTY(UpdateRI) OR !EMPTY(DeleteRI))
					lcTableName = RTRIM(&lcEnumTables..RmtTblName)

					* Thermometer stuff
					lcThermMsg = STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
					This.UpDateTherm(lnTableCount,lcThermMsg)
					lnTableCount = lnTableCount+1

					* Grab RI and validation rule code (Note that all the validation rule
					* SQL has already been placed in the InsertRI field)
					lcInsertRI = &lcEnumTables..InsertRI
					lcUpdateRI = &lcEnumTables..UpdateRI
					lcDeleteRI = &lcEnumTables..DeleteRI

					*if update code is restrict, need to
					*toss in a variable declaration at the top of the trigger
					*(it can't come inside of the BEGIN...END commands)
					If AT(REC_COUNT_VAR, lcDeleteRI) <> 0 OR AT(REC_COUNT_VAR, lcUpdateRI) <> 0 THEN
						lcDecl= "DECLARE " + REC_COUNT_VAR + " NUMBER;" + lcCRLF
					Else
						lcDecl=""
					Endif

					*Assemble before trigger
					If !EMPTY(lcInsertRI) OR !EMPTY(lcUpdateRI) OR !EMPTY(lcDeleteRI)
						lcTrigName = ORA_BIUD_TRIG_PREFIX + LEFT(lcTableName, MAX_NAME_LENGTH-LEN(ORA_BIUD_TRIG_PREFIX))
						lcTrigName = this.UniqueOraName(lcTrigName)

						lcSQL = "CREATE TRIGGER " + lcTrigName + lcCRLF
						lcSQL = lcSQL + "BEFORE INSERT OR UPDATE OR DELETE"
						lcSQL = lcSQL + " ON " + lcTableName + " FOR EACH ROW " + lcCRLF
						lcSQL = lcSQL + lcDecl + "BEGIN " + lcCRLF
						lcSQL = lcSQL + lcInsertRI + lcUpdateRI + lcDeleteRI + lcCRLF + "END;"

						If this.DoUpsize AND this.Perm_Trigger THEN
							llRetVal = this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg)
							If !llRetVal THEN
								This.StoreError(lnError, lcErrMsg, lcSQL, TRIG_ERR_LOC,lcTableName,TRIGGER_LOC)
								Replace &lcEnumTables..RIError WITH lcErrMsg ADDITIVE, ;
									RIErrNo WITH lnError
							Endif

						Endif
						Replace &lcEnumTables..InsertRI WITH lcSQL, ;
							&lcEnumTables..ItrigName WITH lcTrigName, ;
							&lcEnumTables..InsertX WITH llRetVal

						* Trigger sql is appended in the script, so clean it up
						Replace &lcEnumTables..UpdateRI WITH "", ;
							&lcEnumTables..DeleteRI WITH ""
					Endif

					*Assemble after trigger
					If 	.F.
						lcTrigName = ORA_AUD_TRIG_PREFIX + LEFT(lcTableName, MAX_NAME_LENGTH-LEN(ORA_AUD_TRIG_PREFIX))
						lcTrigName = this.UniqueOraName(lcTrigName)
						lcSQL =         "CREATE TRIGGER " + lcTrigName + lcCRLF
						lcSQL = lcSQL + "AFTER UPDATE OR DELETE"
						lcSQL = lcSQL + " ON " + lcTableName + " FOR EACH ROW " + lcCRLF
						lcSQL  =lcSQL + lcDecl + "BEGIN " + lcCRLF
						lcSQL = lcSQL + lcUpdateRI + lcDeleteRI + lcCRLF + "END;"

						If this.DoUpsize AND this.Perm_Trigger THEN
							llRetVal = this.ExecuteTempSPT(lcSQL, @lnError, @lcErrMsg)
							If !llRetVal THEN
								This.StoreError(lnError, lcErrMsg, lcSQL, TRIG_ERR_LOC,lcTableName,TRIGGER_LOC)
								Replace &lcEnumTables..RIError WITH lcErrMsg ADDITIVE, ;
									RIErrNo WITH lnError
							Endif
						Endif
						Replace &lcEnumTables..DeleteRI WITH lcSQL, ;
							&lcEnumTables..DtrigName WITH lcTrigName, ;
							&lcEnumTables..DeleteX WITH llRetVal, ;
							&lcEnumTables..UpdateRI WITH ""
					Endif

				Endscan

			#Endif

		Else

			*SQL Server: Create up to three triggers
			*update trigger: updateRI, rules/sprocs
			*insert trigger: insertRI, rules/sprocs
			*delete trigger: deleteRI

			Scan FOR &lcEnumTables..Export=.T.
				lcSproc=""
				lcSQL=""
				lcTableName=RTRIM(&lcEnumTables..RmtTblName)

				lcThermMsg=STRTRAN(THIS_TABLE_LOC,'|1',lcTableName)
				This.UpDateTherm(lnTableCount,lcThermMsg)
				lnTableCount=lnTableCount+1

				*Build sproc string which will be used in Insert and Update triggers

				*Grab table validation rules (i.e. sprocs) that were successfully created
				*Grab them regardless if the user is just generating a script
				If &lcEnumTables..RuleExport =.T. ;
						OR (!this.DoUpsize AND !EMPTY(&lcEnumTables..RmtRule)) THEN
					lcSproc=TBLRULE_COMMENT_LOC
					lcSproc=lcSproc+ "execute "+RTRIM(&lcEnumTables..RRuleName)  ;
						+ " @status output" + lcCRLF
				Endif

				*Grab RI code
				lcInsertRI=&lcEnumTables..InsertRI
				lcUpdateRI=&lcEnumTables..UpdateRI
				lcDeleteRI=&lcEnumTables..DeleteRI

				*Grab field validation sprocs
				lcEnumFields=RTRIM(this.EnumFieldsTbl)
				Select (lcEnumFields)
				Scan FOR RTRIM(&lcEnumFields..TblName)==lcTableName
					lcFieldName=RTRIM(&lcEnumFields..RmtFldname)

					*Only add it to the string if the sproc was successfully created

					If &lcEnumFields..RuleExport =.T. ;
							OR (!this.DoUpsize AND !EMPTY(&lcEnumFields..RmtRule)) THEN
						lcSproc=lcSproc + STRTRAN(FLDRULE_COMMENT_LOC,"|1",lcFieldName)
						lcSproc=lcSproc + "execute " + RTRIM(&lcEnumFields..RRuleName) + " @status output" + lcCRLF
					Endif

				Endscan

				Select (lcEnumTables)

				*Strings used in all the triggers:
				lcStatus="DECLARE @status char(10)  " + STATUS_COMMENT_LOC + lcCRLF
				lcStatus=lcStatus + "SELECT @status='Succeeded'" + lcCRLF
				lcRollBack=ROLLBACK_LOC + lcCRLF + "IF @status='Failed'" + lcCRLF +;
					"ROLLBACK TRANSACTION" + lcCRLF

				If !EMPTY(lcInsertRI) OR !EMPTY(lcSproc) THEN

					*Create insert trigger
					lcTrigName=ITRIG_PREFIX + LEFT(lcTableName,MAX_NAME_LENGTH-LEN(ITRIG_PREFIX))
					lcSQL="CREATE TRIGGER " + lcTrigName
					lcSQL=lcSQL + " ON " + lcTableName + " FOR INSERT AS " + lcCRLF
					lcSQL=lcSQL + lcStatus + lcSproc + lcInsertRI
					lcSQL=lcSQL + lcRollBack
					If this.DoUpsize THEN
						llRetVal=this.ExecuteTempSPT(lcSQL, @lnError,@lcErrMsg)
						If !llRetVal THEN
							This.StoreError(lnError, lcErrMsg, lcSQL, TRIG_ERR_LOC,lcTableName,TRIGGER_LOC)
							Replace &lcEnumTables..RIError WITH lcErrMsg ADDITIVE, ;
								RIErrNo WITH lnError
						Endif
					Endif
					Replace &lcEnumTables..InsertRI WITH lcSQL, ;
						&lcEnumTables..ItrigName WITH lcTrigName, ;
						&lcEnumTables..InsertX WITH llRetVal
				Endif

				If !EMPTY(lcUpdateRI) OR !EMPTY(lcSproc) THEN

					*Create update trigger
					lcTrigName=UTRIG_PREFIX + LEFT(lcTableName,MAX_NAME_LENGTH-LEN(UTRIG_PREFIX))
					lcSQL="CREATE TRIGGER " + lcTrigName
					lcSQL=lcSQL + " ON " + lcTableName + " FOR UPDATE AS " + lcCRLF
					lcSQL=lcSQL + lcStatus + lcSproc + lcUpdateRI
					lcSQL=lcSQL + lcRollBack
					If this.DoUpsize THEN
						llRetVal=this.ExecuteTempSPT(lcSQL, @lnError,@lcErrMsg)
						If !llRetVal THEN
							This.StoreError(lnError, lcErrMsg, lcSQL, TRIG_ERR_LOC,lcTableName,TRIGGER_LOC)
							Replace &lcEnumTables..RIError WITH lcErrMsg ADDITIVE, ;
								RIErrNo WITH lnError
						Endif
					Endif
					Replace &lcEnumTables..UpdateRI WITH lcSQL, ;
						&lcEnumTables..UtrigName WITH lcTrigName, ;
						&lcEnumTables..UpdateX WITH llRetVal
				Endif

				If !EMPTY(lcDeleteRI) THEN

					*Create delete trigger
					lcTrigName=DTRIG_PREFIX + LEFT(lcTableName,MAX_NAME_LENGTH-LEN(DTRIG_PREFIX))
					lcSQL="CREATE TRIGGER " + lcTrigName
					lcSQL=lcSQL + " ON " + lcTableName + " FOR DELETE AS " + lcCRLF
					lcSQL=lcSQL + lcStatus + lcDeleteRI
					lcSQL=lcSQL + lcRollBack
					If this.DoUpsize THEN
						llRetVal=this.ExecuteTempSPT(lcSQL, @lnError,@lcErrMsg)
						If !llRetVal THEN
							This.StoreError(lnError, lcErrMsg, lcSQL, TRIG_ERR_LOC,lcTableName,TRIGGER_LOC)
							Replace &lcEnumTables..RIError WITH lcErrMsg ADDITIVE, ;
								RIErrNo WITH lnError
						Endif
					Endif
					Replace &lcEnumTables..DeleteRI WITH lcSQL, ;
						&lcEnumTables..DtrigName WITH lcTrigName, ;
						&lcEnumTables..DeleteX WITH llRetVal
				Endif

			Endscan

		Endif
		This.ThermRef.complete
		Select (lnOldArea)

	Endproc


	Procedure GetRiInfo
		Local lcEnumRelsTbl,lnOldArea, p_dbc, l_rmtchitable, l_rmtpartable, lcTableName
		Private aDupeCount

		*Thanks, George Goley, for the heart of this code
		If !this.GetRiInfoRecalc THEN
			Return
		Endif

		#Define KEY_CHILDTAG		13	&& For RELATION objects: name of child (from) index tag
		#Define KEY_RELTABLE		18	&& For RELATION objects: name of related table
		#Define KEY_RELTAG			19	&& For RELATION objects: name of related index tag
		#Define d_updatespot		1
		#Define d_deletespot		2
		#Define d_insertspot		3

		*Make sure that all tables selected for upsizing have had their
		*indexes analyzed

		lnOldArea=select()
		*Make sure index info is up-to-date
		If this.AnalyzeIndexesRecalc THEN
			This.AnalyzeIndexes
		Endif

		p_dbc=RTRIM(this.SourceDB)

		lcEnumIndexesTbl=this.EnumIndexesTbl
		Select (lcEnumIndexesTbl)
		lcEnumRelsTbl=this.CreateWzTable("Relation")
		This.EnumRelsTbl=lcEnumRelsTbl

		Use (p_dbc) in 0 again alias mydbc
		Use (p_dbc) in 0 again alias mydbcpar
		Select mydbc
		lcExact=SET("EXACT")
		Set EXACT ON
		Locate for lower(objecttype)="table" and trim(lower(objectname))=="ridd"

		Scan for upper(objecttype)="RELATION"

			Goto (mydbc.parentid) in mydbcpar
			l_chitable=lower(mydbcpar.objectname)
			l_start=1
			Do while l_start<=len(property)
				l_size=asc(substr(property,l_start,1))+;
					(asc(substr(property,l_start+1,1))*256)+;
					(asc(substr(property,l_start+2,1))*256^2)+;
					(asc(substr(property,l_start+3,1))*256^3)
				l_key=substr(property,l_start+6,1)
				l_value=substr(property,l_start+7,l_size-8)
				Do case
				Case l_key==chr(KEY_CHILDTAG)
					l_chitag=l_value
				Case l_key==chr(KEY_RELTABLE)
					l_partable=lower(l_value)
				Case l_key==chr(KEY_RELTAG)
					l_partag=l_value
				Endcase
				l_start=l_start+l_size
			Enddo

			l_area=select(1)

			*Grab tag expression
			Select (lcEnumIndexesTbl)

			*Parent table
			Locate FOR IndexName=rtrim(l_partable) AND TagName=RTRIM(l_partag)
			l_parexpr=&lcEnumIndexesTbl..RmtExpr

			*Child table
			Locate FOR IndexName=rtrim(l_chitable) AND TagName=RTRIM(l_chitag)
			l_chiexpr=&lcEnumIndexesTbl..RmtExpr

			*Translate ri characters (RCI) into words (Restrict, Cascade, Ignore)
			l_delete=upper(substr(mydbc.riinfo,d_deletespot,1))
			l_delete=iif(l_delete<>CASCADE_CHAR_LOC and l_delete<>RESTRICT_CHAR_LOC,;
				IGNORE_CHAR_LOC,l_delete)
			l_update=upper(substr(mydbc.riinfo,d_updatespot,1))
			l_update=iif(l_update<>CASCADE_CHAR_LOC and l_update<>RESTRICT_CHAR_LOC,;
				IGNORE_CHAR_LOC,l_update)
			l_insert=upper(substr(mydbc.riinfo,d_insertspot,1))
			l_insert=iif(l_insert<>CASCADE_CHAR_LOC and l_insert<>RESTRICT_CHAR_LOC,;
				IGNORE_CHAR_LOC,l_insert)

			l_rmtpartable=this.RemotizeName(l_partable)
			l_rmtchitable=this.RemotizeName(l_chitable)

			*See if there are multiple relations between the same two tables
			Select count(*) from (lcEnumRelsTbl) ;
				where RTRIM(Dd_RmtPar)==RTRIM(l_rmtpartable) ;
				and RTRIM(Dd_RmtChi)==RTRIM(l_rmtchitable) ;
				into array aDupeCount

			Insert into &lcEnumRelsTbl (DD_CHILD,Dd_RmtChi,DD_PARENT,Dd_RmtPar,;
				DD_CHIEXPR,DD_PAREXPR,Duplicates, dd_update, dd_insert, dd_delete) ;
				values (l_chitable,l_rmtchitable, l_partable, l_rmtpartable, ;
				l_chiexpr,l_parexpr, aDupeCount, l_update, l_insert, l_delete)

			Select mydbc

		Endscan

		*clean up
		Use
		Select mydbcpar
		Use
		Set EXACT &lcExact
		This.GetRiInfoRecalc=.F.

		Select(lnOldArea)

	Endproc


	#If SUPPORT_ORACLE
	Procedure GetEligibleRels
		Parameters aEligibleRels, llChoices
		Local lcEnumRelsTbl, lcEnumTablesTbl, lnOldArea, lcDupeString, lcConstraint, ;
			aExportTables, lcExact

		lnOldArea=SELECT()
		lcEnumRelsTbl=RTRIM(this.EnumRelsTbl)
		lcEnumTablesTbl=RTRIM(this.EnumTablesTbl)
		*This determines if we return relations that have cluster names or that don't
		*If we want the choices of rels for clusters, we want the rels w/o cluster names
		If llChoices THEN
			lcConstraint="Export =.T. AND EMPTY(ClustName)"
		Else
			lcConstraint="Export =.T. AND !EMPTY(ClustName)"
		Endif

		Dimension aExportTables[1]
		Select LOWER(TblName) FROM (lcEnumTablesTbl) WHERE &lcConstraint INTO ARRAY aExportTables

		If !EMPTY(aExportTables) THEN
			Select (lcEnumRelsTbl)
			I=1
			lcExact=SET('EXACT')
			Set EXACT ON
			Scan
				*check to see if both parent and child table are being exported
				*also make sure it's not a self-join
				If ASCAN(aExportTables,rtrim(DD_CHILD))<>0 ;
						AND ASCAN(aExportTables,rtrim(DD_PARENT))<>0 ;
						AND !DD_PARENT==DD_CHILD THEN
					*Make sure number of fields in primary and foreign keys is the same
					Dimension aParentKeys[1], aChildKeys[1]
					This.KeyArray(DD_PAREXPR,@aParentKeys)
					This.KeyArray(DD_CHIEXPR,@aChildKeys)

					If ALEN(aParentKeys,1)=ALEN(aChildKeys,1) THEN
						Dimension aEligibleRels [i,2]
						If &lcEnumRelsTbl..Duplicates <> 0 THEN
							lcDupeString = "(" + LTRIM(STR(Duplicates+1)) + ")"
						Else
							lcDupeString=""
						Endif
						aEligibleRels[i,1]=RTRIM(DD_PARENT) + ":" + RTRIM(DD_CHILD) + lcDupeString
						aEligibleRels[i,2]=aEligibleRels[i,1]
						I=I+1
					Endif
				Endif
			Endscan
			Set EXACT &lcExact
		Endif
		Select (lnOldArea)

	Endproc
#Endif


#If SUPPORT_ORACLE
	Procedure DispRelInfo
		Parameters lcRelName, llInCluster
		Local lnOldArea, lcEnumRelsTbl, lcParent, lcChild, lnDupeID

		lnOldArea=SELECT()
		lcEnumRelsTbl=RTRIM(this.EnumRelsTbl)

		*All this would be easier if we could index on the dd_rmtparent and dd_rmtchild
		*fields and perform seeks, but their combined lengths exceeds 255, so we're
		*stuck parsing and locating

		lcParent=""
		lcChild=""
		lnDupeID=0
		This.ParseRel(lcRelName, @lcParent, @lcChild, @lnDupeID)

		*Find the relation record
		Select (lcEnumRelsTbl)
		If lnDupeID<>0 THEN
			lnDupeID=lnDupeID-1
		Endif
		Locate FOR DD_CHILD=lcChild AND DD_PARENT=lcParent AND Duplicates=lnDupeID

		*Set values appropriately
		If llInCluster THEN
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblClustName.caption=RTRIM(&lcEnumRelsTbl..ClustName)
			*Make labels that display primary and foreign keys wider if cluster name
			*and cluster type stuff is not displayed
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblParentExpr.width=359
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblChildExpr.width=359
		Else
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblParentExpr.width=153
			OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblChildExpr.width=153
		Endif

		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblClustName.visible=llInCluster
		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblClustLabel.visible=llInCluster
		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblClustType.visible=llInCluster
		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.opgClustType.visible=llInCluster

		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblParentExpr.caption=&lcEnumRelsTbl..DD_PAREXPR
		OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.lblChildExpr.caption=&lcEnumRelsTbl..DD_CHIEXPR

		*Deal with cluster type option group
		*If a key is composite, you can't create a hash cluster from the relation
		*Composite keys will have a comma in them
		If llInCluster THEN
			If AT(",",&lcEnumRelsTbl..DD_CHIEXPR)<>0 THEN
				OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.opgClustType.Option2.enabled=.F.
			Else
				OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.opgClustType.Option2.enabled=.T.
			Endif

			If &lcEnumRelsTbl..ClustType="INDEX" THEN
				OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.opgClustType.value=1
			Else
				OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.opgClustType.value=2
			Endif
		Endif

		Select (lnOldArea)

	Endproc
#Endif


#If SUPPORT_ORACLE
	Procedure ParseRel
		Parameters lcRelName, lcParent, lcChild, lnDupID
		Local lnOPos, lnCPos, lnColPos

		*
		*Takes a string of the form "customer:orders" and parses it into table names
		*Handles case where two tables may have multiple relations between each other
		*

		*Check if the rel is one of several with duplicate parent and child tables
		lnOPos=AT("(",lcRelName)
		lnCPos=AT(")",lcRelName)
		If lnOPos<>0 THEN
			lnDupID=VAL(SUBSTR(lcRelName,lnOPos+1,lnCPos-lnOPos-1))
			lcRelName=LEFT(lcRelName,lnOPos-1)
		Else
			lnDupID=0
		Endif

		*Separate parent and child tablenames out of relation name
		lnColPos=AT(":",lcRelName)
		lcParent=LEFT(lcRelName,lnColPos-1)
		lcChild=SUBSTR(lcRelName,lnColPos+1)

	Endproc
#Endif


	Procedure RedirectApp
		Local lnDispLogin, lcOldConnString, lcRenamedUserConn, llRenamed

		*All the renaming gyrations are to avoid the problem of the user
		*getting a login dialog when remote views are created

		If !EMPTY(OEngine.UserConnection) AND !OEngine.PwdInDef
			*create new conndef; name is placed into this.ViewConnection
			This.CreateConnDef
			DBSetProp(this.ViewConnection,"connection","ConnectString",OEngine.ConnectString)
			lcRenamedUserConn=this.UniqueConnDefName()
			*rename old connection
			Rename CONNECTION (OEngine.UserConnection) TO (lcRenamedUserConn)
			DBSetProp(lcRenamedUserConn,"connection","ConnectString",OEngine.ConnectString)
			*give new connection the original's name
			Rename CONNECTION (OEngine.ViewConnection) TO (OEngine.UserConnection)
			OEngine.ViewConnection=OEngine.UserConnection
			llRenamed=.T.
		Else
			llRenamed=.F.
		Endif

		If this.ExportViewToRmt AND this.DoUpsize THEN
			This.RemotizeViews
		Endif

		If this.ExportTableToView AND this.DoUpsize THEN
			This.CreateRmtViews
		Endif

		*need to take out password if conndef created and user doesn't want pwd saved
		If !this.ViewConnection=="" AND !this.ExportSavePwd AND !llRenamed THEN
			lcRConnString=DBGETPROP(this.ViewConnection,"connection","connectstring")
			lcRPwd=this.ParseConnectString(lcRConnString,"pwd=")
			lcRConnString=STRTRAN(lcRConnString,"PWD="+lcRPwd+";")
			lcRConnString=STRTRAN(lcRConnString,"PWD="+lcRPwd)
			lcRConnString=STRTRAN(lcRConnString,"pwd="+lcRPwd+";")
			lcRConnString=STRTRAN(lcRConnString,"pwd="+lcRPwd)
			=DBSETPROP(this.ViewConnection,"connection","connectstring",lcRConnString)
		Endif

		If llRenamed
			*Delete temporary connection definition
			Delete CONNECTION (OEngine.ViewConnection)
			Rename CONNECTION (lcRenamedUserConn) TO (OEngine.UserConnection)
		Endif

	Endproc

	Procedure TrimDBCNameFromTables(lcTables)
		* trim off "tastrade!" from "tastrade!customer,tastrade!orders"
		Local P,q,m.RetVal
		m.RetVal = ""
		Do WHILE "!" $ m.lcTables
			m.P = AT("!",m.lcTables)
			m.q = AT(",",m.lcTables)
			If m.q > 0
				m.RetVal = m.RetVal + SUBSTRC(m.lcTables,m.P+1,m.q - m.P)
				m.lcTables = SUBSTRC(m.lcTables,m.q+1)
			Else
				m.RetVal = m.RetVal + SUBSTRC(m.lcTables,m.P+1)
				m.lcTables = ""
			Endif
		Enddo
		Return m.RetVal
	Endproc

	Procedure ProcessFromClause
		* parses the FROM clause, adds the odbc oj escape to the Sql statement and
		* returns the list of tables participating in this view
		Parameters cStr, cTables
		Local lcTalk, lcPath, llResult, aTables[1], lcLen

		* disable errors
		This.SetErrorOff = .T.
		This.HadError = .F.

		* needed by substr() to return empty strings at eos
		lcTalk = set('talk')
		Set talk off
		lcProc = set('proc')
		Set procedure to "wizjoin.prg"
		llResult = ParseFromClause(@cStr, @aTables)
		Set procedure to &lcProc
		Set talk &lcTalk

		* bail on error
		This.SetErrorOff = .F.
		If OEngine.HadError
			Return .F.
		Endif

		* build table list
		If llResult
			cTables = ""
			lcLen = alen(aTables, 1)
			For m.I = 1 to lcLen
				cTables = cTables + aTables[m.i] + iif(m.I < lcLen, ", ", "")
			Endfor
		Endif

		Return llResult
	Endproc

	Procedure RemotizeViews
		Local aTableNames, lcEnumTables, lcTablesInView, lcTablesNotUpsized, ;
			lcNewTableString, lcViewSQL, lcRmtViewSQL, lnOldArea, lcViewsTbl, ;
			llTableUpsized, aWhip, lcEnumFieldsTbl, aFldArray, lcNewViewName, lcDBCAlias, ;
			aFieldsInView, mm, ii, jj, I, llSendUpdates, lcDelStatus, lcViewErr, lcCRLF, ;
			lcErrString, lnParentRec, lnViewCount, lnServerError, lcErrMsg, lcRCursor, ;
			lcRCursor,lcViewParms,llShareConnection,lcDatatype, lcRmtViewSQL2

		Private aViews

		*
		*Views that consist of tables which were upsized are modified so they point to
		*remote data and are executed on the back end
		*

		*If the user isn't upsizing, bail
		If !this.DoUpsize THEN
			Return
		Endif

		lnOldArea=SELECT()
		lcCRLF=CHR(10)+CHR(13)
		*Check each view; see if all its tables were upsized
		*Get array of views; if no views, bail
		lnViewCount=aDBObjects(aViews,"View")
		If lnViewCount=0 THEN
			Return
		Endif
		For I =1 to ALEN(aViews,1)
			aViews[i] = LOWER(aViews[i])
		Endfor
		This.InitTherm(RMTZING_VIEW_LOC,lnViewCount,0)
		lnViewCount=0

		*Create array of tables that were successfully exported, local names and remote names)
		*Sort them so the longest fields are first, otherwise string replacements could
		*get messed up
		lcEnumTables=this.EnumTablesTbl
		Dimension aTableNames[1]
		Select LOWER(TblName), ;
			LOWER(RmtTblName), ;
			IsNull(TblName), ;
			1/LEN(ALLTRIM(TblName)) as foo ;
			from &lcEnumTables where Exported=.T. ;
			order by foo ;
			into array aTableNames
		If EMPTY(aTableNames)
			This.ThermRef.Complete
			Return
		Endif

		lcViewsTbl=this.CreateWzTable("Views")
		This.ViewsTbl=lcViewsTbl
		llViewConnCreated=.F.

		llShareConnection = .F.
		oReg = NewObject("FoxReg","registry.vcx")
		cOptionValue = ""
		cOptionName = "CrsShareConnection"
		m.nErrNum = oReg.GetFoxOption(m.cOptionName,@cOptionValue)
		If nErrNum=0 AND cOptionValue="1"
			llShareConnection = .T.
		Endif

		For I=1 to ALEN(aViews,1)

			*Thermometer stuff
			lcMessage=STRTRAN(THIS_VIEW_LOC,"|1",LOWER(RTRIM(aViews[i])))
			This.UpDateTherm(lnViewCount,lcMessage)
			lnViewCount=lnViewCount+1

			*If this is a remote view, skip it
			If DBGETPROP(aViews[i],"View","SourceType")=2 THEN
				Loop
			Endif

			*flag set true if at least one table in a view was upsized;
			*we can ignore the view if this stays .F.
			llTableUpsized=.F.

			*Grab the view's SQL string (may need to change table names to remote versions)
			lcViewSQL=LOWER(DBGETPROP(aViews[i],"View","SQL"))

			* Get parameter list
			lcViewParms=LOWER(DBGETPROP(aViews[i],"View","Parameterlist"))

			* try parsing the from clause to get the tables and remotize oj
			* on error get table list from Tables property
			If !this.ProcessFromClause(@lcViewSQL, @lcTablesInView)
				lcTablesInView = LOWER(DBGETPROP(aViews[i],"View","Tables"))
			Endif

			lcTablesInView = lcTablesInView + ","
			* add comma so there's no confusing strings like "dupe" and "dupe1"

			*will not remove free tables from the view list
			lcDBName=LOWER(this.JustStem2(this.SourceDB))
			lcTablesNotUpsized = STRTRAN(m.lcTablesInView,lcDBName+"!")

			*Remove local database name from sql string
			*If it has a space in it, it will be enclosed in quotes
			If AT(lcDBName," ")<>0 THEN
				lcRmtViewSQL=STRTRAN(lcViewSQL,gcQT+lcDBName+"!"+gcQT)
			Else
				lcRmtViewSQL=STRTRAN(lcViewSQL,lcDBName+"!")
			Endif

			*Check which (if any) tables were upsized
			lcNewTableString=""

			Dimension aFieldsInView[1,2]
			aFieldsInView=.F.

			For ii=1 to ALEN(aTableNames,1)
				If LOWER(RTRIM(aTableNames[ii,1])) + "," $ lcTablesInView THEN
					*set flag
					llTableUpsized=.T.

					*replace all field names changed by remotizing names
					lcEnumFieldsTbl=this.EnumFieldsTbl
					Dimension aFldArray[1,2]
					aFldArray=.F.
					Select FldName, RmtFldname from (lcEnumFieldsTbl) ;
						where TblName=RTRIM(aTableNames[ii,1]) ;
						and FldName<>RmtFldname into array aFldArray

					If !EMPTY(aFldArray) THEN
						For jj=1 to ALEN(aFldArray,1)
							If RTRIM(aFldArray[jj,1]) $ lcRmtViewSQL THEN
								lcRmtViewSQL=STRTRAN(lcRmtViewSQL,RTRIM(aFldArray[jj,1]),RTRIM(aFldArray[jj,2]))
							Endif
						Next jj
					Endif

					*Replace table names with remotized table names
					*First look for stuff of the form "from me" (change to "from_me")
					*then look for "from" (change to "from_").  This prevent "from me"
					*becoming "from__me".

					lcTablesNotUpsized=STRTRAN(lcTablesNotUpsized,gcQT+RTRIM(aTableNames[ii,1])+","+gcQT)
					lcTablesNotUpsized=STRTRAN(lcTablesNotUpsized,RTRIM(aTableNames[ii,1])+",")
					lcRmtViewSQL=STRTRAN(lcRmtViewSQL,gcQT+RTRIM(aTableNames[ii,1])+gcQT,;
						RTRIM(aTableNames[ii,2]))
					lcRmtViewSQL=STRTRAN(lcRmtViewSQL," " + RTRIM(aTableNames[ii,1]),;
						" " + RTRIM(aTableNames[ii,2]))

					If !lcNewTableString=="" THEN
						lcNewTableString=lcNewTableString+","
					Endif
					lcNewTableString=lcNewTableString + RTRIM(aTableNames[ii,2])

					aTableNames[ii,3]=.T.	&&Table is part of view

				Endif
			Next ii

			*Go on to the next view if this one has no tables upsized in it
			If !llTableUpsized THEN
				Loop
			Endif

			*If all the tables were upsized, then remotize the view
			If ALLTRIM(STRTRAN(lcTablesNotUpsized,","))=="" THEN

				*Need a connection to associate with remote view
				*create one if user didn't connect with one
				*or if they created a new database
				If this.ViewConnection=="" THEN
					If this.UserConnection=="" OR this.CreateNewDB THEN
						This.CreateConnDef
					Else
						This.ViewConnection=this.UserConnection
					Endif
				Endif

				*Rename local view
				lcNewViewName=this.UniqueTorVName(aViews[i])
				RENAME VIEW (RTRIM(aViews[i])) TO (lcNewViewName)

				* Check for "==" used in SQL Server which is not allowed and replace with "="
				lcRmtViewSQL2 = lcRmtViewSQL
				If THIS.SQLServer AND ATCC("==",lcRmtViewSQL)#0
					lcRmtViewSQL2 = STRTRAN(lcRmtViewSQL,"==","=")
				Endif

				*Create remote view with same name
				This.SetErrorOff=.T.
				This.HadError=.F.
				Create SQL VIEW RTRIM(aViews[i]) REMOTE CONNECT RTRIM(this.ViewConnection) ;
					AS &lcRmtViewSQL2
				This.SetErrorOff=.F.
				If this.HadError THEN
					*If the view creation fails, store the error and loop
					=AERROR(aErrArray)
					lnServerError=aErrArray[1]
					lcErrMsg=aErrArray[2]
					If lnServerError=1526 THEN
						lnServerError=aErrArray[5]
					Endif

					*Put things back and store error info
					Rename VIEW (lcNewViewName) TO (RTRIM(aViews[i]))
					lcViewErr=aErrArray[2]
					Select (lcViewsTbl)
					Append BLANK
					Replace ViewName WITH aViews[i], NewName WITH aViews[i], ;
						ViewSQL WITH lcViewSQL, RmtViewSQL WITH lcRmtViewSQL, ;
						Remotized WITH .F., ViewErr with lcErrMsg, ;
						ViewErrNo WITH lnServerError
					This.StoreError(lnServerError,lcErrMsg,lcRmtViewSQL,RMTIZE_VIEW_FAILED_LOC,aViews[i],VIEW_LOC)
					Loop I
				Endif

				*Set various and sundry view properties
				llSendUpdates=DBGETPROP(lcNewViewName,"view","SendUpdates")
				lcViewErr=""
				If !DBSETPROP(RTRIM(aViews[i]),"view","SendUpdates",llSendUpdates)
					This.AddToError(@lcViewErr,UPDATE_PROP_FAILED_LOC)
				Endif
				If !DBSETPROP(RTRIM(aViews[i]),"view","Tables",lcNewTableString)
					This.AddToError(@lcViewErr,TABLES_PROP_FAILED_LOC)
				Endif
				If !EMPTY(lcViewParms) AND !DBSETPROP(RTRIM(aViews[i]),"view","Parameterlist",lcViewParms)
					This.AddToError(@lcViewErr,TABLES_PROP_FAILED_LOC)
				Endif

				If llShareConnection AND !DBSETPROP(RTRIM(aViews[i]),"view","ShareConnection",llShareConnection)
					This.AddToError(@lcViewErr,TABLES_PROP_FAILED_LOC)
				Endif

				*Get properties of fields in local view; set remote field properties to same

				*Get cursors of fields in local view and for remote view
				lcDBCAlias=this.UniqueCursorName("dbcalias")
				lcDelStatus=set("deleted")
				Set DELETED ON
				Use RTRIM(this.SourceDB) IN 0 AGAIN ALIAS &lcDBCAlias
				Select (lcDBCAlias)

				Locate FOR RTRIM(LOWER(objectname))==RTRIM(LOWER(lcNewViewName))
				lcParent=&lcDBCAlias..ObjectID
				lcLCursor=this.UniqueCursorName("localfields")
				Select 0
				Select objectname, recno() FROM (lcDBCAlias) WHERE parentid=lcParent AND objecttype="Field" ;
					INTO cursor &lcLCursor
				Select(lcLCursor)
				lnLFields=reccount()

				*Find the record for the remote view
				Select (lcDBCAlias)
				Locate FOR LOWER(RTRIM(objectname))==LOWER(RTRIM(aViews[i]))
				lcParent=&lcDBCAlias..ObjectID
				lcRCursor=this.UniqueCursorName("remotefields")
				Select 0
				*Only get fields which aren't timestamps added by the wizard
				Select objectname, recno() FROM (lcDBCAlias) ;
					WHERE parentid=lcParent ;
					AND objecttype="Field" ;
					AND ATC(IDENTCOL_LOC, rtrim(objectname)) == 0 ;
					AND ATC(TIMESTAMP_LOC, rtrim(objectname)) == 0 ;
					INTO CURSOR &lcRCursor
				Select(lcRCursor)
				lnRFields=reccount()

				If lnRFields<>lnLFields
					This.AddToErr(@lcViewErr,FIELDS_UNEQUAL_LOC)
				Else
					Select (lcLCursor)
					Scan
						llKeyField=DBGETPROP(lcNewViewName+"."+RTRIM(objectname),"field","keyfield")
						llUpdatable=DBGETPROP(lcNewViewName+"."+RTRIM(objectname),"field","updatable")
						lcUpdateName=DBGETPROP(lcNewViewName+"."+RTRIM(objectname),"field","updatename")
						lcDatatype=DBGETPROP(lcNewViewName+"."+RTRIM(objectname),"field","datatype")

						Select (lcRCursor)
						If !DBSETPROP(RTRIM(aViews[i])+"."+ RTRIM(objectname),"field","keyfield",llKeyField)
							lcRmtViewField=RTRIM(objectname)
							lcErrString=STRTRAN(KEYFIELD_PROP_FAILED_LOC,'|1',lcRmtViewField)
							This.AddToErr(@lcViewErr,lcErrString)
						Endif
						If !DBSETPROP(RTRIM(aViews[i])+"."+ RTRIM(objectname),"field","updatable",llUpdatable)
							lcRmtViewField=RTRIM(objectname)
							lcErrString=STRTRAN(UPDATABLE_PROP_FAILED_LOC,'|1',lcRmtViewField)
							This.AddToErr(@lcViewErr,lcErrString)
						Endif

						*Since we map Date->DateTime field in SQL Server, we need to make sure the new
						*remote view resets DateTime->Date.
						If lcDatatype="D" AND !DBSETPROP(RTRIM(aViews[i])+"."+ RTRIM(objectname),"field","datatype",lcDatatype)
							This.AddToErr(@lcViewErr,lcErrString)
						Endif
						Skip
						Select (lcLCursor)
					Endscan
				Endif
				Use
				Set DELETED &lcDelStatus
				Use IN (lcDBCAlias)
				If USED(m.lcRCursor)
					Use IN (m.lcRCursor)
				Endif

				*store all this stuff
				Select (lcViewsTbl)
				Append BLANK
				Replace ViewName WITH aViews[i], NewName WITH lcNewViewName, ;
					ViewSQL WITH lcViewSQL, RmtViewSQL WITH lcRmtViewSQL, ;
					Connection WITH this.ViewConnection, Remotized WITH .T., ;
					ViewErr with lcViewErr, TblsUpszd WITH lcNewTableString
				If !lcViewErr=="" THEN
					This.StoreError(.NULL.,"","",VIEW_PROPS_FAILED_LOC,aViews[i],VIEW_LOC)
				Endif
			Else
				*create remote views of tables that were upsized and leave the current view alone
				*Don't create remote view here if the user wants all upsized tables
				*to have remote views created for them
				If !this.ExportTableToView THEN
					For zz=1 to ALEN(aTableNames,1)
						If aTableNames[zz,3]=.T. THEN
							*Function expects array even though we'll always pass just one element from here
							Dimension aWhip[1,2]
							aWhip[1,1]=aTableNames[zz,1]
							aWhip[1,2]=aTableNames[zz,2]
							This.CreateRmtViews(@aWhip)
						Endif
					Next zz
				Endif

				*Store stuff for report
				Select (lcViewsTbl)
				Append BLANK
				Replace ViewName WITH aViews[i], NewName WITH "", ;
					Remotized WITH .F., TblsUpszd WITH lcNewTableString, ;
					NotUpszd WITH LTRIM(STRTRAN(lcTablesNotUpsized,","))

			Endif

		Next I
		This.ThermRef.Complete

		*Get rid of table if no records were added; report will not be added either
		If RECCOUNT()=0 THEN
			This.DisposeTable(lcViewsTbl,"Delete")
			This.ViewsTbl=""
		Endif

		Select (lnOldArea)

	Endproc


	Procedure AddToErr
		Parameters lcErrString, lcAddToString

		If lcErrString==""
			lcErrString=lcAddToString
		Else
			lcErrString=CHR(10)+CHR(13)+lcAddToString
		Endif

	Endproc


	Function UniqueConnDefName
		Local lcConnName, I,lcExact

		*Make sure name is unique
		lcConnName=CONN_NAME_LOC
		=ADBOBJECTS(aConnDefs,"connection")
		I=1
		lcExact=SET('EXACT')
		Set EXACT ON
		Do WHILE ASCAN(aConnDefs,UPPER(lcConnName))<>0
			lcConnName=CONN_NAME_LOC+LTRIM(STR(I))
			I=I+1
		Enddo
		Set EXACT &lcExact
		Return lcConnName

	Endfunc


	Procedure CreateConnDef
		Local I, llFound, lcConnString, lcConnName, lcNewConnString

		lcConnName=this.UniqueConnDefName()
		This.ViewConnection=lcConnName
		If this.UserConnection=="" THEN

			*If the user didn't connect with a connection definition, we
			*need to create one from scratch based on the connection string
			*created when they logged into ODBC

			lcConnString=RTRIM(this.ConnectString)

			*parse connection string to get user id, password, and database
			lcNewConnString="dsn="+RTRIM(this.DataSourceName)+";"

			llFound=.F.
			lcUserID=this.ParseConnectString(this.ConnectString,"uid=",@llFound)

			If llFound THEN
				lcNewConnString=lcNewConnString+"uid="+RTRIM(lcUserID)+";"
			Endif

			lcPassword=this.ParseConnectString(this.ConnectString,"pwd=",llFound)
			If llFound THEN
				lcNewConnString=lcNewConnString+"pwd="+RTRIM(lcPassword)+";"
			Endif

			*add database name only for SQL Server
			If this.ServerType <> ORACLE_SERVER
				lcNewConnString=lcNewConnString+"database="+RTRIM(this.ServerDBName)+";"
			Endif
			*Create new connection and set its connection string property
			Create CONNECTION &lcConnName DataSource RTRIM(this.DataSourceName)
			=DBSETPROP(lcConnName,"connection","ConnectString",lcNewConnString)

		Else

			*user specified a connection def so new conndef should be just like it
			*except for the database specified

			*Get all properties (except datasource which we already know)
			llAsynchronous=		DBGETPROP(this.UserConnection,"connection","Asynchronous")
			llBatchMode=		DBGETPROP(this.UserConnection,"connection","BatchMode")
			lcConnectString=	DBGETPROP(this.UserConnection,"connection","ConnectString")
			lcConnectTimeOut=	DBGETPROP(this.UserConnection,"connection","ConnectTimeOut")
			lnDispLogin=		DBGETPROP(this.UserConnection,"connection","DispLogin")
			llDispWarnings=		DBGETPROP(this.UserConnection,"connection","DispWarnings")
			lnIdleTimeOut=		DBGETPROP(this.UserConnection,"connection","IdleTimeOut")
			lcPassword=			DBGETPROP(this.UserConnection,"connection","PassWord")
			lnQueryTimeout=		DBGETPROP(this.UserConnection,"connection","QueryTimeout")
			lnTransactions=		DBGETPROP(this.UserConnection,"connection","Transactions")
			lcUserID=			DBGETPROP(this.UserConnection,"connection","UserID")
			lnWaitTime=			DBGETPROP(this.UserConnection,"connection","WaitTime")

			*Create bare-bones connection
			Create CONNECTION &lcConnName DataSource RTRIM(this.DataSourceName)

			*Hack connection string so it points at new database
			lcOldDatabase=this.ParseConnectString(lcConnectString,"database=")
			If !lcOldDatabase=="" THEN
				lcConnectString=STRTRAN(lcConnectString,lcOldDatabase,RTRIM(this.ServerDBName))
			Endif

			*Make new connection's properties just like this.UserConnection's
			=DBSETPROP(this.ViewConnection,"connection","Asynchronous",llAsynchronous)
			=DBSETPROP(this.ViewConnection,"connection","BatchMode",llBatchMode)
			=DBSETPROP(this.ViewConnection,"connection","ConnectString",lcConnectString)
			=DBSETPROP(this.ViewConnection,"connection","ConnectTimeOut",lcConnectTimeOut)
			=DBSETPROP(this.ViewConnection,"connection","DispLogin",lnDispLogin)
			=DBSETPROP(this.ViewConnection,"connection","DispWarnings",llDispWarnings)
			=DBSETPROP(this.ViewConnection,"connection","IdleTimeOut",lnIdleTimeOut)
			=DBSETPROP(this.ViewConnection,"connection","PassWord",lcPassword)
			=DBSETPROP(this.ViewConnection,"connection","QueryTimeout",lnQueryTimeout)
			=DBSETPROP(this.ViewConnection,"connection","Transactions",lnTransactions)
			=DBSETPROP(this.ViewConnection,"connection","UserID",lcUserID)
			=DBSETPROP(this.ViewConnection,"connection","WaitTime",lnWaitTime)

		Endif

		This.ViewConnection=lcConnName

	Endfunc


	Function ParseConnectString
		Parameters lcConnString, lcStringPart, llFound
		Local lcLowConnString, lnStartPos

		*Takes a connection string; returns the part of string asked for

		lcStringPart=LOWER(lcStringPart)
		lcLowConnString=LOWER(lcConnString)
		lnStartPos=AT(lcStringPart,lcLowConnString)
		If lnStartPos<>0 THEN
			lcFoundString=SUBSTR(lcConnString,lnStartPos+LEN(lcStringPart))
			If AT(";",lcFoundString)<>0 THEN
				lcFoundString=LEFT(lcFoundString,AT(";",lcFoundString)-1)
			Endif
			llFound=.T.
		Else
			lcFoundString=""
			llFound=.F.
		Endif

		Return lcFoundString

	Endfunc


	Procedure CreateRmtViews
		Parameters aTableNames

		*
		*Creates remote views for tables passed in or all tables that were upsized
		*

		Local lcEnumTablesTbl, lcNewTblName, lnOldArea, lcSQL, lcEnumIndexesTbl, ;
			aPkey, lcEnumFieldsTbl, lcViewErr, lcTblError, lnErrNo, llShowTherm, lnTableCount, I, ;
			lcCRLF, lcViewExtension, lcViewName
		lnOldArea=SELECT()
		lcEnumTablesTbl=this.EnumTablesTbl
		lcEnumIndexesTbl=this.EnumIndexesTbl
		lcEnumFieldsTbl=this.EnumFieldsTbl
		lcCRLF=CHR(10)+CHR(13)

		If EMPTY(aTableNames)
			Dimension aTableNames[1]
			Select TblName, RmtTblName FROM (lcEnumTablesTbl) WHERE Exported=.T. ;
				INTO ARRAY aTableNames

			If EMPTY(aTableNames)
				Return	&& no tables were actually upsized
			Endif

			lnTableCount=ALEN(aTableNames,1)
			llShowTherm=.T.
		Endif

		If llShowTherm THEN
			*Only display thermometer if this method is called by ProcessOutput;
			*otherwise the thermometer will be showing the progress
			*for the RemotizeView method already
			This.InitTherm(RMTZING_TABLE_LOC,lnTableCount,0)
			lnTableCount=0
		Endif

		If this.ViewConnection=="" THEN
 			If this.UserConnection=="" OR this.CreateNewDB THEN
				This.CreateConnDef
			Else
				This.ViewConnection=this.UserConnection
			Endif
		Endif

		Select (lcEnumTablesTbl)
		For I=1 TO ALEN(aTableNames,1)
			If llShowTherm THEN
				lcMessage=STRTRAN(THIS_TABLE_LOC,"|1",RTRIM(aTableNames[i,1]))
				This.UpDateTherm(lnTableCount,lcMessage)
				lnTableCount=lnTableCount+1
			Endif

			This.HadError=.F.
			This.MyError=0
			lcViewErr=""
			lcTblError="" && jvf 9/25/99 for table drop
			lnTblErrNo=0 && jvf 9/25/99 for drop table
			lcViewExtension=IIF(this.ViewPrefixOrSuffix=3, "", RTRIM(this.ViewNameExtension))

			* rename or drop the original table
			* jvf: 08/16/99 Added drop functionality
			lcNewTblName=RTRIM(aTableNames[i,1])
			If this.DropLocalTables
				* jvf 9/15/99
				* Can't drop table unless we drop its relation first. 
				* But we can't easily tell if it's in a relation. If the table to drop is on the 
				* child side, easy to see that in the dbc and drop if needed. But if the table's the 
				* parent side of the relation, like customer is to orders, it's hard to know what relation 
				* to delete. You actually have to delete the relation of the order on cust_id. So, we'll just 
				* trap for error on drop, log it, and move on.
				DROP TABLE (RTRIM(aTableNames[i,1]))
				If This.HadError && probably error 1577: table is in a relation
					lcTblError=CANT_DROP2_LOC+" "+Message()
					lnTblErrNo=This.MyError
				Else
					lcNewTblName = DROPPED_TABLE_STATUS_LOC  && Table Dropped
				Endif
			Endif
			* If couldn't drop table, rename it if they didn't choose a prefix/suffix for
			* the new remote view name.
			* If the user chose not to drop tables, but did not to give the view a suffix/prefix, 
			* need to add _local to the table name to prevent duplicate object names in dbc.
			If (Not this.DropLocalTables OR lnTblErrNo>0) AND EMPTY(lcViewExtension)
				lcNewTblName=this.UniqueTorVName(RTRIM(aTableNames[i,1]))
				RENAME TABLE (RTRIM(aTableNames[i,1])) TO (lcNewTblName)
			Endif

			lcSQL="SELECT * FROM " + aTableNames[i,2]
			*create the view
			* jvf 08/16/99 Add prefix/suffix to new view name

			lcViewName = IIF(this.ViewPrefixOrSuffix=1,lcViewExtension+RTRIM(aTableNames[i,1]),;
				RTRIM(aTableNames[i,1])+lcViewExtension)

			Create SQL VIEW &lcViewName REMOTE CONNECT RTRIM(this.ViewConnection) ;
				AS &lcSQL

			*See if table has primary key or candidate
			Dimension aPkey[1]
			aPkey=.F.
			Select RmtExpr FROM (lcEnumIndexesTbl) WHERE RTRIM(IndexName)==RTRIM(aTableNames[i,1]) ;
				AND LclIdxType="Primary key" INTO ARRAY aPkey

			*If not but unique index is available, use that
			If EMPTY(aPkey) THEN
				Select RmtExpr FROM (lcEnumIndexesTbl) WHERE RTRIM(IndexName)==RTRIM(aTableNames[i,1]) ;
					AND RmtType="UNIQUE" ;
					INTO ARRAY aPkey
			Endif

			If !EMPTY(aPkey) THEN
				*Make the whole thing updatable
				* jvf 08/16/99 just using var here now instead of array element
				If !DBSETPROP(lcViewName,"view","SendUpdates",.T.) THEN
					lcViewErr=UPDATE_PROP_FAILED_LOC
				Endif

				*Set the keyfields
				Dimension aKeyFields[1]
				aKeyFields=.F.
				This.KeyArray(aPkey,@aKeyFields)
				For ii=1 TO ALEN(aKeyFields,1)
					* jvf 08/16/99 just using lcViewName var here now instead of array element
					If !DBSETPROP(lcViewName+"."+RTRIM(aKeyFields[ii]),"field","keyfield",.T.) THEN
						lcErrString=STRTRAN(KEYFIELD_PROP_FAILED_LOC,'|1',RTRIM(aKeyFields[ii]))
						lcViewErr=lcViewErr+lcCRLF+lcErrString
					Endif
				Next ii

				*Make all the fields updatable
				Dimension aFldNames[1]
				aFldNames=.F.
				Select RmtFldname FROM (lcEnumFieldsTbl) WHERE RTRIM(TblName)==RTRIM(aTableNames[i,1]) ;
					INTO ARRAY aFldNames
				If !EMPTY(aFldNames) THEN
					For ii=1 TO ALEN(aFldNames,1)
						* jvf 08/16/99 just using lcViewName var here now instead of array element
						If !DBSETPROP(lcViewName+"."+RTRIM(aFldNames[ii]),"field","updatable",.T.) THEN
							lcErrString=STRTRAN(UPDATABLE_PROP_FAILED_LOC,'|1',RTRIM(aKeyFields[ii]))
							lcViewErr=lcViewErr+lcCRLF+lcErrString
						Endif
					Next ii
				Endif

			Else

				lcViewErr=NO_UNIQUEKEY_LOC

			Endif

			*store these table and view names somewhere
			Locate FOR LOWER(RTRIM(&lcEnumTablesTbl..TblName))==LOWER(RTRIM(aTableNames[i,1]))
			* jvf 08/16/99 just using lcNewTblName var here now instead of array element
			Replace NewTblName WITH lcNewTblName, RmtView WITH lcViewName, ;
				ViewErr WITH lcViewErr, TblError With lcTblError, TblErrNo With lnTblErrNo

			lcViewErr=""
			lcTblError=""
			lnTblErrNo=0

		Next I

		Select (lnOldArea)

		This.ThermRef.complete

	Endproc


	Function UniqueTorVName
		Parameters lcTableName
		Local lcNewTableName, lcOldTableName, I, lcExact

		*Need to make sure that when renaming tables and views that we don't overwrite
		*existing ones; this function returns a unique name

		Dimension aViewsArr[1]
		=ADBOBJECTS(aViewsArr,'view')
		=ADBOBJECTS(aTablesArr,'table')
		lcOldTableName=lcTableName
		lcNewTblName=LEFT(RTRIM(lcTableName),MAX_FIELDNAME_LEN-LEN(LOCAL_SUFFIX_LOC))+LOCAL_SUFFIX_LOC
		I=1
		lcExact = SET('EXACT')
		Set EXACT ON
		Do WHILE ASCAN(aViewsArr,UPPER(lcNewTblName))<>0 ;
				OR ASCAN(aTablesArr,UPPER(lcNewTblName))<>0
			If LEN(lcNewTblName)+ LEN(LTRIM(STR(I)))>=MAX_FIELDNAME_LEN THEN
				lcOldTableName=LEFT((lcTableName),LEN(LTRIM(STR(I))))
				lcNewTblName=RTRIM(lcOldTableName)+LTRIM(STR(I))+ LOCAL_SUFFIX_LOC
			Else
				*Just stick a number on the end
				lcNewTblName=RTRIM(lcOldTableName)+LOCAL_SUFFIX_LOC+LTRIM(STR(I))
			Endif
			I=I+1
		Enddo
		Set EXACT &lcExact

		Return lcNewTblName

	Endfunc


	Procedure BuildReport
		Local I, lcNewDB, lcNewProj, lcMisc, lcErrTblName, lcPath, lcPathAndFile, ;
			aRepArray
		*
		*Creates a project with report or just export error tables if the user
		*didn't ask for a report
		*
		If (this.DataErrors OR !this.ErrTbl=="") AND !this.DoReport THEN
			If !MESSAGEBOX(DATA_ERRORS_LOC,ICON_EXCLAMATION+YES_NO_BUTTONS,TITLE_TEXT_LOC)=USER_YES
				This.SaveErrors=.F.
			Else
				This.SaveErrors=.T.
			Endif
		Else
			If this.DoReport THEN
				This.SaveErrors=.T.
			Else
				This.SaveErrors=.F.
			Endif
		Endif

		*Bail if nothing to do
		If !this.DoReport AND !this.SaveErrors AND !this.DoScripts THEN
			Return
		Endif

		If this.DoReport THEN
			This.InitTherm(BUILDING_REPORT_LOC,0,0)

			*Can't use table name as primary and foreign keys because it's too long
			*Stuff integers into fields
			This.PurgeTable(this.EnumTablesTbl,"Export=.F. OR Upsizable = .F.")
			This.ReorderTable
			This.Integerize

			*Close analysis tables
			This.DisposeTable(this.MappingTable,"close")
			This.DisposeTable(this.ViewsTbl,"close")

			*Get rid of records where stuff wasn't chosen for upsizing by user
			This.PurgeTable2	&&Deals with this.EnumFieldsTbl
			Use IN (this.EnumTablesTbl)

			If !this.EnumRelsTbl=="" THEN
				This.PurgeTable(this.EnumRelsTbl,"Exported=.F.")
			Endif
			If !this.EnumIndexesTbl=="" THEN
				This.PurgeTable(this.EnumIndexesTbl,"TblUpszd=.F.")
			Endif

		Else
			If this.DoScripts THEN
				This.InitTherm(SCRIPT_INDB_LOC,0,0)
			Else
				This.InitTherm(PREP_ERR_LOC,0,0)
			Endif
		Endif

		*Create new database
		lcNewDB=this.UniqueFileName(NEWDB_NAME_LOC,"dbc")
		Create DATABASE &lcNewDB
		Set DATABASE TO &lcNewDB

		If this.DoReport THEN
			*Create table that contains 'one time only' data and put the data in it
			lcMisc=this.CreateWzTable(MISC_NAME_LOC)
			This.PutDataInMisc(lcMisc)

			*Add analysis tables to database
			Add TABLE (RTRIM(this.EnumFieldsTbl)) NAME FIELD_NAME_LOC
			Add TABLE (RTRIM(this.EnumTablesTbl)) NAME TABLE_NAME_LOC
			If this.ExportIndexes THEN
				Add TABLE (RTRIM(this.EnumIndexesTbl)) NAME INDEX_NAME_LOC
			Endif

			If this.ExportRelations THEN
				Add TABLE (RTRIM(this.EnumRelsTbl)) NAME REL_NAME_LOC
			Endif
			If !this.ViewsTbl=="" THEN
				Add TABLE (RTRIM(this.ViewsTbl)) NAME VIEW_NAME_LOC
			Endif

			*Set relations between them
			Alter TABLE TABLE_NAME_LOC ALTER COLUMN TblID I PRIMARY KEY
			*This "tables" table needs to be open for cleanup later on
			Use
			Use TABLE_NAME_LOC ALIAS (this.EnumTablesTbl)
			Select 0
			Alter TABLE FIELD_NAME_LOC ALTER COLUMN TblID I REFERENCES TABLE_NAME_LOC TAG TblID
			Use
			If this.ExportIndexes
				Alter TABLE INDEX_NAME_LOC ALTER COLUMN TblID I REFERENCES TABLE_NAME_LOC TAG TblID
				Use
			Endif

		Endif

		If this.DoScripts THEN
			This.DisposeTable(this.ScriptTbl,"close")
			Add TABLE (RTRIM(this.ScriptTbl))NAME SCRIPT_NAME_LOC
		Endif

		*Toss in error table
		If this.SaveErrors AND !this.ErrTbl=="" THEN
			This.DisposeTable(this.ErrTbl,"close")
			Add TABLE (RTRIM(this.ErrTbl)) NAME ERROR_NAME_LOC
		Endif

		*Add tables that contain failed data exports
		If this.SaveErrors AND !EMPTY(aDataErrTbls) THEN
			For I=1 to ALEN(aDataErrTbls,1)
				lcErrTblName=ERR_TBL_PREFIX_LOC + ;
					LEFT(aDataErrTbls[i,1],MAX_NAME_LENGTH-LEN(ERR_TBL_PREFIX_LOC))
				Add TABLE (RTRIM(aDataErrTbls[i,2])) NAME (lcErrTblName)
			Next
		Endif

		*
		*Create new project
		*

		lcNewProj=this.UniqueFileName(NEWPROJ_NAME_LOC, "pjx")
		This.NewProjName=lcNewProj
		Use Project1.PJX
		Copy TO lcNewProj+".pjx"
		Use lcNewProj+".pjx"

		*change project path to its new directory
		lcPath=DBC()
		lcPath=STRTRAN(lcPath,SET('DATA')+".DBC")
		lcPathAndFile=lcPath+lcNewProj+".PJX" + CHR(0)
		lcPath=lcPath+CHR(0)

		Replace Name WITH lcPathAndFile, ;
			Homedir WITH lcPath, ;
			Object WITH lcPath, ;
			Reserved1 WITH lcPathAndFile

		*Add database to project
		Locate FOR LOWER(Type)="d"
		Replace NAME WITH LOWER(lcNewDB)+".dbc", KEY WITH UPPER(lcNewDB)

		*Create reports and add report records to project
		If this.DoReport
			Dimension aRepArray[1,2]
			This.AddToRepArray(FIELDS_REPORT_LOC,@aRepArray)
			This.AddToRepArray(TABLES_REPORT_LOC,@aRepArray)
			If !this.ErrTbl=="" AND this.SaveErrors THEN
				This.AddToRepArray(ERR_REPORT_LOC,@aRepArray)
			Endif
			If this.ExportIndexes THEN
				This.AddToRepArray(INDEX_REPORT_LOC,@aRepArray)
			Endif
			If this.ExportRelations THEN
				This.AddToRepArray(RELS_REPORT_LOC,@aRepArray)
			Endif
			If this.ExportViewToRmt AND !this.ViewsTbl=="" THEN
				This.AddToRepArray(VIEWS_REPORT_LOC,@aRepArray)
			Endif

			For I=1 TO ALEN(aRepArray,1)

				*Create copy of each upsizing report
				aRepArray[i,2]=this.UniqueFileName(aRepArray[i,1],"frx")
				Select 0
				Use (aRepArray[i,1]) + ".frx"
				Copy TO aRepArray[i,2] + ".frx"
				Use (aRepArray[i,2]) + ".frx"
				Locate FOR Name="cursor"
				*Need to fiddle with the DE
				Do WHILE FOUND()
					Replace Expr WITH STRTRAN(Expr,"upsize1",DBC())
					Continue
				Enddo
				Use

				*Add to project table
				Select (lcNewProj)
				Append BLANK
				Replace NAME WITH LOWER(aRepArray[i,2])+".frx", ;
					KEY WITH UPPER(aRepArray[i,2]), ;
					EXCLUDE WITH .F., ;
					TYPE WITH "R"

			Endfor

		Endif
		Use

		This.ThermRef.complete

		lcNewProj = ADDBS(FULLPATH(SYS(5))) + lcNewProj
		_Shell=[MODIFY PROJECT "&lcNewProj" NOWAIT]
		This.KeepNewDir=.T.

	Endproc


	Procedure Integerize

		Local lcEnumTablesTbl, lcEnumFieldsTbl, lcEnumIndexesTbl, lcTemp, lcTemp1

		*Add unique IDs to table names and propagate to child tables
		lcEnumTablesTbl=this.EnumTablesTbl
		lcEnumFieldsTbl=this.EnumFieldsTbl
		lcEnumIndexesTbl=this.EnumIndexesTbl

		Select (lcEnumTablesTbl)
		Replace ALL TblID WITH RECNO()
		Scan
			lcTemp =&lcEnumTablesTbl..TblID
			lcTemp1 = &lcEnumTablesTbl..TblName
			Update (lcEnumFieldsTbl);
				SET &lcEnumFieldsTbl..TblID=lcTemp ;
				WHERE &lcEnumFieldsTbl..TblName==lcTemp1

			If this.ExportIndexes
				lcTemp =&lcEnumTablesTbl..TblID
				lcTemp1 =&lcEnumTablesTbl..TblName
				Update (lcEnumIndexesTbl);
					SET &lcEnumIndexesTbl..TblID=lcTemp ;
					WHERE &lcEnumIndexesTbl..IndexName==lcTemp1
			Endif

		Endscan

	Endproc

	Procedure AddToRepArray
		Parameters lcRepName, aRepArray
		Local lnArrayLen
		*This method assumes that the passed array is 2D; the string passed is placed
		*in the first column

		If EMPTY(aRepArray) THEN
			aRepArray[1,1]=lcRepName
		Else
			lnArrayLen=ALEN(aRepArray,1)
			Dimension aRepArray[lnArrayLen+1,2]
			aRepArray[lnArrayLen+1,1]=lcRepName
		Endif

	Endproc


	Procedure PutDataInMisc
		Parameters lcMisc

		Insert INTO &lcMisc ;
			(SvType, ;
			DataSourceName, ;
			UserConnection, ;
			ViewConnection, ;
			DeviceDBName, ;
			DeviceDBPName, ;
			DeviceDBSize,;
			DeviceDBNumber, ;
			DeviceLogName, ;
			DeviceLogPName, ;
			DeviceLogSize, ;
			DeviceLogNumber, ;
			ServerDBName, ;
			ServerDBSize, ;
			ServerLogSize, ;
			SourceDB, ;
			ExportIndexes, ;
			ExportValidation, ;
			ExportRelations, ;
			ExportStructureOnly, ;
			ExportDefaults, ;
			ExportTimeStamp, ;
			ExportTableToView, ;
			ExportViewToRmt, ;
			ExportDRI, ;
			ExportSavePwd, ;
			DoUpsize, ;
			DoScripts, ;
			DoReport) ;
			VALUES ;
			(this.ServerType, ;
			this.DataSourceName, ;
			this.UserConnection, ;
			this.ViewConnection, ;
			this.DeviceDBName, ;
			this.DeviceDBPName, ;
			this.DeviceDBSize, ;
			this.DeviceDBNumber, ;
			this.DeviceLogName, ;
			this.DeviceLogPName, ;
			this.DeviceLogSize, ;
			this.DeviceLogNumber, ;
			this.ServerDBName, ;
			this.ServerDBSize, ;
			this.ServerLogSize, ;
			this.SourceDB, ;
			this.ExportIndexes, ;
			this.ExportValidation, ;
			this.ExportRelations, ;
			this.ExportStructureOnly, ;
			this.ExportDefaults, ;
			this.ExportTimeStamp, ;
			this.ExportTableToView, ;
			this.ExportViewToRmt, ;
			this.ExportDRI, ;
			this.ExportSavePwd, ;
			this.DoUpsize, ;
			this.DoScripts, ;
			this.DoReport)

		Use

	Endproc


	Procedure ReorderTable
		Local lcNewName, lcAlias

		*Copy to new table sorted by table name (can't index on 128 character field
		*using general code page)

		*		lcNewName=SUBSTR(SYS(2015),3,10)
		lcNewName="_"+SUBSTR(SYS(2015),4,10)
		Rename (this.EnumTablesTbl)+".dbf" TO (lcNewName)+".dbf"
		Rename (this.EnumTablesTbl)+".fpt" TO (lcNewName)+".fpt"
		Select 0
		Use (lcNewName)
		lcAlias=ALIAS()

		Select * FROM (lcNewName);
			ORDER BY TblName;
			INTO TABLE (this.EnumTablesTbl)

		Use IN (lcAlias)

		Delete FILE (lcNewName)+".dbf"
		Delete FILE (lcNewName)+".fpt"

	Endproc


	Procedure PurgeTable
		Parameters lcTableName, lcCondition
		*This removes objects which were analyzed but not selected for upsizing

		Select (lcTableName)
		Set FILTER TO
		Delete FOR &lcCondition
		Pack
		Use

	Endproc


	Procedure PurgeTable2
		Local lcTableName

		*Gets rid of field info related to tables not selected for upsizing
		*(This info gets added if the user selects a table, changes pages, and
		*then deselects the table)

		Select (this.EnumTablesTbl)
		Scan FOR Export=.F.
			lcTableName=RTRIM(TblName)
			Select (this.EnumFieldsTbl)
			Delete FOR RTRIM(TblName)==lcTableName
			Select (this.EnumTablesTbl)
		Endscan

		Select (this.EnumFieldsTbl)
		Pack
		Use

	Endproc


	Procedure CreateScript
		Local lcEnumRelsTbl, lcEnumTablesTbl, lcCRLF, lcComment, lcEnumIndexesTbl, ;
			lcEnumFieldsTbl, lnTableCount, lcEnumClustersTbl

		*Device and database sql (if any) are already in the script memo field by now
		If !this.DoScripts THEN
			Return
		Endif
		lcCRLF = CHR(13)
		lcEnumClustersTbl = this.EnumClustersTbl
		lcEnumTablesTbl = this.EnumTablesTbl
		lcEnumIndexesTbl = this.EnumIndexesTbl
		lcEnumRelsTbl = this.EnumRelsTbl
		lcEnumFieldsTbl = this.EnumFieldsTbl

		Select COUNT(*) FROM (lcEnumTablesTbl) WHERE Export=.T. INTO ARRAY aTableCount
		This.InitTherm(BUILDING_SCRIPT_LOC, aTableCount,0)
		lnTableCount = 0
		This.UpDateTherm(lnTableCount, "")

		If this.ServerType = "Oracle"
			* Grab cluster SQL (if any)
			If !EMPTY(lcEnumClustersTbl)
				Select (lcEnumClustersTbl)
				Scan FOR !EMPTY(ClustName)

					* Get cluster SQL
					lcClustName = RTRIM(ClustName)
					lcSQL = this.BuildComment(CLUST_COMMENT_LOC, lcClustName)
					lcSQL = lcSQL + ClusterSQL
					This.StoreSQL(lcSQL, "")
					lcSQL = ""

					*Grab cluster index SQL
					Select (lcEnumIndexesTbl)
					Locate FOR RTRIM(RmtTable) == lcClustName
					If FOUND()
						lcSQL = this.BuildComment(CLUST_INDEX_LOC, RmtName)
						lcSQL = lcSQL + IndexSQL
						This.StoreSQL(lcSQL,"")
					Endif
					lcSQL = ""

					* Grab SQL of tables (and their triggers) in cluster
					Select (lcEnumTablesTbl)
					Scan FOR RTRIM(ClustName) == lcClustName
						lcTableName = RTRIM(TblName)
						lcRmtTblName = RTRIM(RmtTblName)
						This.OracleScript(lcTableName, lcRmtTblName)
						lnTableCount = lnTableCount + 1
						This.UpDateTherm(lnTableCount)
					Endscan
					Select (lcEnumClustersTbl)
				Endscan
			Endif
			* Deal with tables not in clusters
			* Grab SQL of tables (and their triggers) in cluster
			Select (lcEnumTablesTbl)
			Scan FOR EMPTY(ClustName) AND Export=.T.
				lcTableName = RTRIM(TblName)
				lcRmtTblName = RTRIM(RmtTblName)
				This.OracleScript(lcTableName, lcRmtTblName)
				lnTableCount = lnTableCount + 1
				This.UpDateTherm(lnTableCount)
			Endscan
		Else
			* Deal with SQL Server
			Select (lcEnumTablesTbl)
			If this.ZDUsed THEN
				lcSQL = ZD_DESC_LOC + lcCRLF
				lcSQL=lcSQL + "CREATE DEFAULT " + ZERO_DEFAULT_NAME + " AS 0" + lcCRLF
				This.StoreSQL(lcSQL,"")
			Endif

			Scan FOR Export=.T.

				*Grab table SQL
				lcTableName=RTRIM(TblName)
				lcRmtTblName=RTRIM(RmtTblName)
				lcSQL = this.BuildComment(TABLE_COMMENT_LOC,lcRmtTblName) + TableSQL
				This.StoreSQL(lcSQL,"")

				*Triggers
				lcSQL=""
				If !EMPTY(InsertRI) THEN
					lcSQL = InsertRI
				Endif
				If !EMPTY(UpdateRI) THEN
					lcSQL = IIF(EMPTY(lcSQL), UpdateRI, lcSQL + UpdateRI + lcCRLF)
				Endif
				If !EMPTY(DeleteRI) THEN
					lcSQL = IIF(EMPTY(lcSQL), DeleteRI, lcSQL + DeleteRI + lcCRLF)
				Endif
				If !lcSQL=="" THEN
					This.StoreSQL(lcSQL, TRIGGER_COMMENT_LOC)
				Endif

				*Grab index SQL
				If !EMPTY(lcEnumIndexesTbl)
					Select (lcEnumIndexesTbl)
					lcSQL = lcCRLF + INDEX_COMMENT_LOC + lcCRLF
					Scan FOR RTRIM(IndexName)==lcTableName AND DontCreate=.F.
						lcSQL=lcSQL+ IndexSQL
						This.StoreSQL(lcSQL,"")
						lcSQL=""
					Endscan
				Endif

				*Grab default SQL
				Select (lcEnumFieldsTbl)
				lcSQL = lcCRLF + DEFAULT_COMMENT_LOC + lcCRLF
				Scan FOR RTRIM(TblName)==lcTableName AND !EMPTY(RmtDefault)
					If RmtDefault<>"0" THEN
						lcSQL = lcSQL + RmtDefault + lcCRLF
					Endif
					lcSQL = lcSQL + "sp_bindefault " + RTRIM(RDName) + ", '" + RTRIM(TblName) + "." + RTRIM(FldName) +"'" + lcCRLF
					This.StoreSQL(lcSQL,"")
					lcSQL=""

				Endscan

				*Stored procedures
				lcSQL=SPROC_COMMENT_LOC
				Scan FOR RTRIM(TblName)==lcTableName AND !EMPTY(RmtRule)
					lcSQL=lcSQL + RmtDefault
					This.StoreSQL(lcSQL,"")
					lcSQL=""
				Endscan

				Select (lcEnumTablesTbl)
				lnTableCount=lnTableCount+1
				This.UpDateTherm(lnTableCount)

			Endscan

		Endif

		This.ThermRef.complete

	Endproc


	Procedure OracleScript
		Parameters lcTableName, lcRmtTblName
		Local lcEnumTablesTbl, lcEnumIndexsTbl, lcEnumFieldsTbl, lcCRLF

		*
		*Called by CreateScript; puts together all the sql for a table
		*including the table, triggers, indexes and defaults
		*

		lcEnumTablesTbl = this.EnumTablesTbl
		lcEnumIndexesTbl = this.EnumIndexesTbl
		lcEnumFieldsTbl = this.EnumFieldsTbl
		lcCRLF = CHR(13)

		* Grab SQL of tables (and their triggers)
		lcSQL = this.BuildComment(TABLE_COMMENT_LOC, lcRmtTblName) + lcCRLF + TableSQL
		This.StoreSQL(lcSQL, "")

		* Triggers
		lcSQL = ""
		If !EMPTY(InsertRI) THEN
			lcSQL = InsertRI + lcCRLF
		Endif
		If !EMPTY(UpdateRI) THEN
			lcSQL = lcSQL + UpdateRI + lcCRLF
		Endif
		If !EMPTY(DeleteRI) THEN
			lcSQL = lcSQL + DeleteRI + lcCRLF
		Endif
		If !EMPTY(lcSQL)
			This.StoreSQL(lcSQL, TRIGGER_COMMENT_LOC)
		Endif

		* Grab index sql
		Select (lcEnumIndexesTbl)
		lcSQL = lcCRLF + INDEX_COMMENT_LOC + lcCRLF + lcCRLF
		Scan FOR RTRIM(IndexName) == lcTableName AND !EMPTY(IndexSQL)
			lcSQL = lcSQL + IndexSQL
			This.StoreSQL(lcSQL, "")
			lcSQL = ""
		Endscan

		*Grab default sql
		Select (lcEnumFieldsTbl)
		lcSQL = lcCRLF + DEFAULT_COMMENT_LOC + lcCRLF + lcCRLF
		Scan FOR RTRIM(TblName) == lcTableName AND !EMPTY(RmtDefault)
			lcSQL = lcSQL + RmtDefault
			This.StoreSQL(lcSQL,"")
			lcSQL = ""
		Endscan

		Select (lcEnumTablesTbl)

	Endproc


	Function UniqueFileName
		Parameters lcFileName, lcExtension
		Local I, lcNewName

		lcNewName=lcFileName
		I=1
		Do WHILE FILE(lcNewName + "." + lcExtension)
			lcNewName=LEFT(lcFileName,MAX_DOSNAME_LEN-LEN(LTRIM(STR(I)))) + LTRIM(STR(I))
			I=I+1
		Enddo
		Return lcNewName

	Endfunc


	Procedure JustStem2

		* Return just the stem name from "filname"
		* Unlike JustStem, this returns file name in same case it came in as

		Lparameters m.filname
		If RAT('\',m.filname) > 0
			m.filname = SUBSTR(m.filname,RAT('\',m.filname)+1,255)
		Endif
		If RAT(':',m.filname) > 0
			m.filname = SUBSTR(m.filname,RAT(':',m.filname)+1,255)
		Endif
		If AT('.',m.filname) > 0
			m.filname = SUBSTR(m.filname,1,AT('.',m.filname)-1)
		Endif
		Return ALLTRIM(m.filname)

	Endproc


	Function RemotizeName
		Parameters lcLocalName
		Local lcResult, lnLength, I, lcChar, lnOldArea, lnAsc, lcExact, lcServerConstraint

		*all expressions and objects everywhere in the Upsizing Wizard are
		*lower cased, otherwise STRTRAN transformations won't work reliably
		lcExact=SET('EXACT')
		Set EXACT ON
		lcResult = LOWER(ALLTRIM(lcLocalName))
		lnOldArea=SELECT()

		* Check keyword table
		If !USED("Keywords")
			Select 0
			Use Keywords
			Set ORDER TO Keyword
		Else
			Select Keywords
		Endif
		If RTRIM(this.ServerType)=="SQL Server95" THEN
			lcServerConstraint="SQL Server"
		Else
			lcServerConstraint=RTRIM(this.ServerType)
		Endif
		Set FILTER TO ServerType=lcServerConstraint

		Seek lcResult

		If FOUND() THEN
			lcResult = lcResult + "_"

		Else

			*if it starts with a number, stick a "_" in front of it
			If LEFT(lcLocalName, 1) >= "0" AND LEFT(lcLocalName, 1) <= "9" THEN
				lcResult= "_" + lcResult
			Endif

			lnLength = LEN(lcResult)
			lcChar = LEFT(lcResult, 1)
			lnAsc = ASC(lcChar)

			*ISALPHA() will return true but SQL Server will reject when...
			*Codepage 1252 (US): 156, 207
			*Codepage 1250 (E.Eur.): 156, 190, 207
			*Codepage ???? (Russia): 220
			*So these characters are always (on all code pages) turned to underscores
			*Skip for DBCS
			If lnLength = LENC(lcResult)
				For I = 1 TO lnLength
					lcChar = SUBSTR(lcResult, I, 1)
					If  (!ISALPHA(lcChar)) AND !(lcChar  >= "0" AND lcChar  <= "9") ;
							OR (lnAsc=156 OR lnAsc=190 OR lnAsc=207 OR lnAsc=220)
						lcResult=STUFF(lcResult, I, 1, "_")
					Endif
				Next I
			Else
				lcResult=STRTRAN(lcResult,CHR(32),"_")
			Endif
		Endif

		Set EXACT &lcExact
		Select (lnOldArea)
		Return lcResult

	Endfunc


	Function UniqueTableName
		Parameters lcStem
		Local lcTest, lcResult, I, lnLength

		lcStem=ALLTRIM(lcStem)
		lcResult=lcStem
		lcTest=lcResult + ".dbf"
		lnLength=LEN(lcStem)
		For I=1 TO 10^lnLength-1
			If file(lcTest) THEN
				lcResult=LEFT(lcStem,lnLength-LEN(ALLTRIM(STR(I)))) + ALLTRIM(STR(I))
				lcTest=lcResult + ".dbf"
			Else
				Exit
			Endif
		Next
		Return lcResult

	Endfunc


	Function UniqueCursorName
		Parameters lcStem
		Local lcResult, I, lnLength

		lcStem=ALLTRIM(lcStem)
		lcResult=lcStem
		lnLength=LEN(lcStem)
		For I=1 TO lnLength-1
			If USED(lcResult) THEN
				lcResult=LEFT(lcStem,lnLength-LEN(ALLTRIM(STR(I)))) + ALLTRIM(STR(I))
			Else
				Exit
			Endif
		Next
		Return lcResult

	Endfunc


	Procedure CreateTypeArrays
		*Creates an array for each FoxPro datatype; each array of possible remote datatypes
		*has the same name as the local FoxPro datatype
		Private aArrays
		Local lcServerConstraint, I

		If RTRIM(this.ServerType)=="SQL Server95" THEN
			lcServerConstraint="SQL Server"
		Else
			If this.ServerType="SQL Server" THEN
				lcServerConstraint="SQL Server4x"
			Else
				lcServerConstraint=RTRIM(this.ServerType)
			Endif
		Endif

		*Find all the local types
		Select LocalType,"this." + LocalType from TypeMap ;
			where Default=.T. and Server=lcServerConstraint ;
			into array aArrays

		For I=1 TO ALEN(aArrays,1)
			Select RemoteType from TypeMap where LocalType=aArrays[i,1] and Server=lcServerConstraint ;
				into array &aArrays[i,2]
		Next

	Endproc


	Function ValidName
		Parameters lcName
		Local lcNewName

		lcNewName=this.RemotizeName(lcName)
		If LOWER(lcNewName)<>LOWER(lcName) THEN
			*display error message
			=MESSAGEBOX(INVALID_NAME_LOC, ICON_EXCLAMATION, TITLE_TEXT_LOC)
			lcName=lcNewName
			Return .F.
		Endif
		Return .T.

	Endfunc


	Function NameObject
		Parameters lcRmtTableName,lcFldName,lcPrefix, lnMaxLength
		Local lnTblNameLength,lnFldNameLength,lnCharsLeft

		lnTblNameLength=LEN(lcRmtTableName)
		lnFldNameLength=LEN(lcFldName)
		lnCharsLeft=(lnMaxLength)-LEN(lcPrefix)-LEN(SEP_CHARACTER)

		*If all the components of the string are too big, clip
		*the table and/or field names

		If lnCharsLeft<lnTblNameLength+lnFldNameLength THEN
			Do CASE
				*If each name is bigger than half of what's left, clip them both
			Case lnTblNameLength>(lnCharsLeft/2) AND lnFldNameLength>(lnCharsLeft/2)
				lcRmtTableName=LEFT(lcRmtTableName,(lnCharsLeft/2))
				lcFldName=LEFT(lcFldName,(lnCharsLeft/2))

				*If the field name is super long, clip it
			Case lnTblNameLength<=(lnCharsLeft/2) AND lnFldNameLength>(lnCharsLeft/2)
				lcFldName=LEFT(lcFldName,(lnCharsLeft-lnTblNameLength))

				*If the table name is super long, clip it
			Case lnTblNameLength>(lnCharsLeft/2) AND lnFldNameLength<=(lnCharsLeft/2)
				lcTmpTblName=LEFT(lcRmtTableName,(lnCharsLeft-lnFldNameLength))

			Endcase
		Endif

		lcSprocName=lcPrefix+lcRmtTableName + SEP_CHARACTER + lcFldName

		Return lcSprocName

	Endfunc


	Procedure MaybeDrop
		Parameters lcObjectName, lcObjectType
		Local llObjectExists, lcSQL, dummy,lcSQT

		*This is called in several places by this.DefaultsAndRules
		*It will drop a sproc or default if it already exists

		*Check to see if the object already exists
		lcSQT=CHR(39)
		lcSQL="select uid from sysobjects where name =" + lcSQT + lcObjectName + lcSQT
		dummy="x"
		llObjectExists=this.SingleValueSPT(lcSQL, dummy, "uid")

		If llObjectExists THEN
			lcSQL="drop " + lcObjectType + " " + lcObjectName
			lnRetVal=this.ExecuteTempSPT(lcSQL)
			Return lnRetVal
		Else
			Return .T.
		Endif

	Endproc


	Function ExtractFieldNames
		Parameters lcExpression, lcTableName, lnKeyCount, aFieldNames
		Local ii, lcReturnExpression, lcEnum_Fields, lcFieldName, lnRow

		*
		*Takes a FoxPro expression and returns comma separated list of
		*remotized version of all the field names that were in the expression
		*
		*Called by AnalyzeIndexes and BuildRICode
		*

		*Build the array of field names if it wasn't passed
		If EMPTY(aFieldNames) THEN
			Dimension aFieldNames[1]
			lcEnum_Fields=RTRIM(this.EnumFieldsTbl)
			*Be sure they come back in order of the longest field names first
			*or the shorter ones which are substrings of longer ones (if any)
			*will mess things up
			Select FldName, RmtFldname, 1/LEN(RTRIM(RmtFldname)) as foo ;
				FROM &lcEnum_Fields ;
				WHERE &lcEnum_Fields..TblName=lcTableName ;
				ORDER BY foo ;
				INTO ARRAY aFieldNames
		Endif

		lnKeyCount=0
		lcReturnExpression=""

		*!* jvf: 08/16/99
		* Replaced code that caused indexes to be created out of the intended field sequence.
		* The subsequent code corrects this issue.
		Dimension laExp[1]
		This.StringToArray(lcExpression, @laExp, "+")
		For lnRow = 1 TO ALEN(laExp,1)
			lcFieldName=this.StripFunction(laExp[lnRow])
			If lcReturnExpression=="" THEN
				lcReturnExpression=lcFieldName
			Else
				lcReturnExpression=lcReturnExpression+", "+lcFieldName
			Endif

			*Keep track of how many fields are in the index expression
			lnKeyCount=lnKeyCount+1
		Endfor
		Return lcReturnExpression

	Endfunc


	Procedure StoreError
		Parameters lnError, lcErrMsg, lcSQL, lcWizErrMsg, lcObjName, lcObjType
		Local lcErrTbl, lnOldArea

		*Stores errors for report

		lnOldArea=SELECT()

		If this.ErrTbl=="" THEN
			This.ErrTbl=this.CreateWzTable("Errors")
		Endif
		lcErrTbl=this.ErrTbl
		If EMPTY(lcWizErrMsg) THEN
			lcWizErrMsg=""
		Endif
		Insert INTO &lcErrTbl (ErrNumber,ErrMsg, WizErr, FailedSQL, ObjName, ObjType) ;
			values (lnError, lcErrMsg, lcWizErrMsg, lcSQL,lcObjName, lcObjType)
		Select (lnOldArea)

	Endproc


	Procedure StoreSQL
		Parameters lcSQL,lcComment
		Local lcCRLF, lnOldArea, lcScriptTbl

		*Get out of here if user doesn't want a script
		If !this.DoScripts THEN
			Return
		Endif

		lcCRLF = CHR(13)
		lnOldArea=SELECT()

		If RTRIM(this.ScriptTbl) == "" THEN
			lcScriptTbl = this.CreateWzTable("Script")
			This.ScriptTbl = lcScriptTbl
		Else
			lcScriptTbl = RTRIM(this.ScriptTbl)
		Endif

		Select (lcScriptTbl)

		* There should only be one record in this table
		If RECCOUNT()=0 THEN
			Append BLANK
		Endif

		*Add some carriage returns/linefeeds and then stick everything together
		If !EMPTY(lcComment) THEN
			lcSQL = lcCRLF + lcComment + lcCRLF + lcSQL
		Endif
		Replace &lcScriptTbl..ScriptSQL WITH lcSQL + lcCRLF ADDITIVE

		* Prevent bulk build-up of memo
		Pack MEMO

		Select (lnOldArea)

	Endproc


	Procedure SetConnProps
		*Sets connection properties to where the upsizing wizard wants them
		=SQLSETPROP(this.MasterConnHand,"Asynchronous",.F.)
		=SQLSETPROP(this.MasterConnHand,"Batchmode",.T.)
		=SQLSETPROP(this.MasterConnHand,"ConnectTimeOut",45)
		=SQLSETPROP(this.MasterConnHand,"DispWarnings",.F.)
		*QueryTimeOut is set to 600 when creating devices and databases
		=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",45)
		=SQLSETPROP(this.MasterConnHand,"Transactions",1)
		=SQLSETPROP(this.MasterConnHand,"WaitTime",100)
		*Never timeout if idle
		=SQLSETPROP(this.MasterConnHand,"IdleTimeOut",0)
		*Default wait time of 100 milliseconds

	Endproc

	Procedure CreateTS
		Parameters lcTSName, lcTSFName,lcTSFSize
		Local lcSQL, lcSQL1, lcMsg, lnErr, lcErrMsg

		* create new tablespace on Oracle server and an associated data file
		* allocates unlimited space quota for the user on the new tablespace
		lcSQL = "CREATE TABLESPACE " + lcTSName + " DATAFILE '" + lcTSFName + "' SIZE " + ALLTRIM(STR(lcTSFSize)) + " K"
		lcSQL1 = "ALTER USER " + this.UserName + " QUOTA UNLIMITED ON " + lcTSName

		*Execute if appropriate
		If this.DoUpsize THEN
			lcMsg=STRTRAN(CREATING_TABLESPACE_LOC,'|1',RTRIM(lcTSName))
			This.InitTherm(lcMsg,0,0)
			This.UpDateTherm(0,TAKES_AWHILE_LOC)
			=SQLSETPROP(this.MasterConnHand,"QueryTimeOut",600)
			This.MyError=0

			* create tablespace
			If !this.ExecuteTempSPT(lcSQL, @lnErr,@lcErrMsg) THEN
				If lnErr = 01543 THEN
					*User doesn't have CREATE TABLESPACE permissions
					lcMsg=STRTRAN(NO_CREATETS_PERM_LOC,'|1',RTRIM(this.DataSourceName))
				Else
					*Something else went wrong
					lcMsg=STRTRAN(CREATE_TS_FAILED_LOC,'|1',RTRIM(lcTSName))
				Endif
				=MESSAGEBOX(lcMsg, ICON_EXCLAMATION,TITLE_TEXT_LOC)
				This.Die
			Endif

			* allocate unlimited quota on tablespace
			If !this.ExecuteTempSPT(lcSQL1, @lnErr,@lcErrMsg) THEN
				If lnErr = 01543 THEN
					*User doesn't have CREATE TABLESPACE permissions
					lcMsg=STRTRAN(NO_CREATETS_PERM_LOC,'|1',RTRIM(this.DataSourceName))
				Else
					*Something else went wrong
					lcMsg=STRTRAN(CREATE_TS_FAILED_LOC,'|1',RTRIM(lcTSName))
				Endif
				=MESSAGEBOX(lcMsg, ICON_EXCLAMATION,TITLE_TEXT_LOC)
				This.Die
			Endif

			=SQLSETPROP(this.MasterConnHand, "QueryTimeOut",30)
		Endif

		*Stash sql for script
		This.StoreSQL(lcSQL,CREATE_DBSQL_LOC)
		This.StoreSQL(lcSQL1,CREATE_DBSQL_LOC)
		This.ThermRef.Complete

	Endproc

	* create new datafile in existing tablespace
	Procedure CreateDataFile
		Parameters lcTSName, lcTSFName,lcTSFSize
		lcSQL = "ALTER TABLESPACE " + lcTSName + " ADD DATAFILE '" + lcTSFName + "' SIZE " + ALLTRIM(STR(lcTSFSize)) + " K"
		llRetVal = OEngine.ExecuteTempSPT(lcSQL)
	Endproc

	Function CreateWzTable
		Parameters lcPassed
		Local lcTableName, lcOldDir

		*
		*All tables used internally (except device table) get created here, indexes where possible
		*

		Select 0
		If this.NewDir == "" THEN
			This.CreateNewDir
		Endif
		lcTableName = this.UniqueTableName(lcPassed)

		Do CASE
		Case lcPassed="Tables"
			Create table &lcTableName FREE;
				(TblName C (128) not null, ;
				TblID I, ;
				CursName C (128) not null, ;
				TblPath M, ;
				RmtTblName C (30) not null, ;
				NewTblName C (128), ;
				Upsizable L, ;
				PreOpened L, ;
				Export L, ;
				Exported L, ;
				DataErrs n(9), ;
				DataErrMsg M, ;
				ErrTable C (128), ;
				FldsAnald L, ;
				CDXAnald L, ;
				ClustName C(30), ;
				TableSQL M, ;
				TStampAdd L, ;
				IdentAdd L, ;
				LocalRule M ,;
				RmtRule M, ;
				RRuleName C (30), ;
				RuleExport L, ;
				RuleError M, ;
				RuleErrNo n (5), ;
				ItrigName C (30), ;
				InsertRI M, ;
				InsertX L, ;
				DtrigName C (30), ;
				DeleteRI M, ;
				DeleteX L, ;
				UtrigName C (30), ;
				UpdateRI M, ;
				UpdateX L, ;
				RIError M, ;
				RIErrNo n (5), ;
				FKeyCrea L, ;
				PKeyCrea L, ;
				PkeyExpr M, ;
				PKTagName C(10), ;
				TblError M, ;
				TblErrNo n (5), ;
				RmtView C(128), ;
				ViewErr M)

			*DataSent indicates if data was successfully appended to the new table
			*Exported indicates if the table was successfully created

			*"RmtView" contains the name of the "SELECT *" view created if the table was part of a view
			*only some of whose tables were upsized; this field maybe ""

			*RRuleName is the name of remote rule

			*"NewTblName" is name of table after renaming if a remote view was created based on the table
			*Index actually created elsewhere for speed reasons
			*INDEX ON TblName TAG TblName

			*Insert, Delete, and Update contain trigger code of the same name
			*InsertX, DeleteX, and UpdateX show whether the triggers were created successfully

			*FKeyCrea and PKeyCrea are used only in the Oracle or SQL 95 case to indicate
			*whether ALTER TABLE statements to add RI succeeded or not

		Case lcPassed="Fields"
			Create table &lcTableName FREE;
				(TblName C (128) not null, ;
				FldName C (128) not null, ;
				DataType C (1) not null, ;
				ComboType C (20) not null, ;
				FullType C (10) not null, ;
				Length n (3) not null, ;
				Precision n (3) not null, ;
				NoCptrans L, ;
				LclNull L, ;
				RmtFldname C (30), ;
				RmtType C (13), ;
				RmtLength n (4), ;
				RmtPrec n (3),;
				RmtNull L, ;
				LocalRule M, ;
				RmtRule M, ;
				RRuleName C (30), ;
				RuleExport L, ;
				RuleError M, ;
				RuleErrNo n (5), ;
				Default M, ;
				RmtDefault M, ;
				RDName C (30), ;
				DefaExport L, ;
				DefaBound L, ;
				DefaError M, ;
				DefaErrNo n (5), ;
				InCluster L, ;
				ClustOrder I, ;
				TblID I)

			*Index actually created elsewhere for speed reasons
			*INDEX ON TblName TAG TblName
			*INDEX ON FldName TAG FldName

		Case lcPassed="Indexes"
			Create table &lcTableName FREE;
				(TblID I, ;
				IndexName C (128) not null, ;
				TagName C (10), ;
				LclExpr M, ;
				LclIdxType C (12), ;
				RmtTable C (30), ;
				RmtName C (10), ;
				RmtExpr M, ;
				RmtType C (20), ;
				Clustered L, ;
				Exported L, ;
				TblUpszd L, ;
				DontCreate L, ;
				IdxError M, ;
				IdxErrNo n (5),;
				IndexSQL M)

			*Value in IndexName is exactly the same as local tablename
			*INDEX ON RTRIM(IndexName)+TagName TAG TblAndTag (performed elsewhere)

		Case lcPassed="Views"
			Create table &lcTableName FREE;
				(ViewName C (128) not null,;
				NewName C (128), ;
				ViewSQL M, ;
				RmtViewSQL M, ;
				TblsUpszd M, ;
				NotUpszd  M, ;
				Connection C (128), ;
				Remotized L, ;
				ViewErr M,;
				ViewErrNo n(5) NULL)

		Case lcPassed="Script"
			Create TABLE &lcTableName FREE;
				(ScriptSQL M)

		Case lcPassed="Errors"
			Create TABLE &lcTableName FREE;
				(ObjType C(30), ;
				ObjName M, ;
				ErrNumber n(5) NULL,;
				ErrMsg M,;
				WizErr M,;
				FailedSQL M)

		Case lcPassed=MISC_NAME_LOC
			*This table gets created in the analysis database
			Create TABLE &lcTableName NAME MISC_NAME_LOC;
				(SvType C (20), ;
				DataSourceName M, ;
				UserConnection C (128), ;
				ViewConnection C (128), ;
				DeviceDBName C (30), ;
				DeviceDBPName C (12), ;
				DeviceDBSize n (6), ;
				DeviceDBNumber n (3), ;
				DeviceLogName C (30), ;
				DeviceLogPName C (12), ;
				DeviceLogSize n (6), ;
				DeviceLogNumber n (3), ;
				ServerDBName C (30), ;
				ServerDBSize n (6), ;
				ServerLogSize n (6), ;
				SourceDB M , ;
				ExportIndexes L, ;
				ExportValidation L, ;
				ExportRelations L, ;
				ExportStructureOnly L, ;
				ExportDefaults L, ;
				ExportTimeStamp L, ;
				ExportTableToView L, ;
				ExportViewToRmt L, ;
				ExportDRI L, ;
				ExportSavePwd L, ;
				DoUpsize L, ;
				DoScripts L, ;
				DoReport L)

		Case lcPassed="Relation"
			Create TABLE &lcTableName FREE;
				(DD_CHIEXPR M,;
				DD_CHILD C(128),;
				Dd_RmtChi C(128),;
				dd_delete C(1),;
				dd_insert C(1),;
				DD_PARENT C(128),;
				Dd_RmtPar C(128),;
				DD_PAREXPR M,;
				dd_update C(1),;
				ClustName C(30),;
				ClustType C(8),;
				ClusterSQL M,;
				HashKeys N(12),;
				RIError M, ;
				RIErrNo n (5), ;
				ClustErr M,;
				ClustErrNo N (5),;
				Export L,;
				Exported L,;
				Duplicates N(3))

		Case lcPassed = "Clusters"
			Create TABLE &lcTableName FREE;
				(ClustName C (30),;
				ClustType C (5),;
				HashKeys N (6),;
				ClustSize N (6),;
				ClusterSQL M,;
				ClustErr M,;
				ClustErrNo N (5),;
				Export L,;
				Exported L,;
				Duplicates N(3))

		Endcase

		Return lcTableName

	Endfunc


	Procedure CreateNewDir
		Local aDirArray, lcDirName
		*Create directory for upsizing files if it doesn't exist already
		If this.NewDir=="" THEN
			This.NewDir=NEW_DIRNAME_LOC
			Dimension aDirArray[1]
			If ADIR(aDirArray,this.NewDir,'D')=0 THEN
				Md (this.NewDir)
				This.CreatedNewDir=.T.
			Endif
			Cd (this.NewDir)
			Set DEFAULT TO CURDIR()
			This.NewDir=CURDIR()
		Endif

	Endproc


	Function ChangeOK
		* This function is called everytime the user changes the page they're on
		* Basically it allows validation of the current page

		Do CASE
		Case OWizard.iCurrentStep = 1
			Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page1.ChooseSourceDB1.ReallyChangeSourceDB()

		Case OWizard.iCurrentStep = 2
			*This is the choose datasource screen
			If OWizard.Direction="Back" THEN
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page2.ChooseDataSource1.MoveBackward()
			Else
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page2.ChooseDataSource1.MoveForward()
			Endif
		Case OWizard.iCurrentStep = 5 AND this.ServerType <> ORACLE_SERVER
			*Choose target database
			If OWizard.Direction = "Next" THEN
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page3.ChooseTargetDB1.MoveForward()
			Endif

		Case OWizard.iCurrentStep = 6 AND this.ServerType <> ORACLE_SERVER
			*DB device screen
			Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page4.Device1.ValuesOK()

		Case OWizard.iCurrentStep = 7 AND this.ServerType <> ORACLE_SERVER
			*Log device screen
			Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page5.Device1.ValuesOK()

		Case OWizard.iCurrentStep = 5 AND this.ServerType = ORACLE_SERVER
			* TS screen
			If OWizard.Direction = "Next" THEN
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page8.Choosetablespace1.MoveForward()
			Endif

		Case OWizard.iCurrentStep = 6 AND this.ServerType = ORACLE_SERVER
			* TSF screen
			If OWizard.Direction = "Next" THEN
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page9.Choosetablespacefile1.MoveForward()
			Endif

		Case OWizard.iCurrentStep = 7 AND this.ServerType = ORACLE_SERVER
			* create clusters screen
			If OWizard.Direction = "Next" THEN
				Return OWizard.Form1.PageFrame1.Page1.PageFrame1.Page10.CreateCluster1.GoNext()
			Endif
		Endcase
	Endfunc

	Procedure GetFoxDataSize
		Local lcEnumTablesTbl, lcFileName, lcTableStem

		lnTableSize = 0
		lnIndexSize = 0
		This.TBFoxTableSize = 0
		This.TBFoxIndexSize = 0

		lcEnumTablesTbl = this.EnumTablesTbl
		If EMPTY(lcEnumTablesTbl)
			Return
		Endif

		Select (lcEnumTablesTbl)

		Scan FOR Export=.T.
			* get table + memo size
			lcFileName = &lcEnumTablesTbl..TblPath
			If ADIR(laDir, lcFileName) <> 0
				lnTableSize = lnTableSize + laDir[1,2] / 1024.

				If RAT('.', lcFileName) > 0
					lcTableStem = LEFT(lcFileName, RAT('.', lcFileName)-1)
				Endif

				* lcTableStem = this.JustStem2(&lcEnumTablesTbl..TblPath)
				lcFileName = lcTableStem + ".fpt"
				If ADIR(laDir, lcFileName) <> 0
					lnTableSize = lnTableSize + laDir[1,2] / 1024.
				Endif

				* get index size
				lcFileName = lcTableStem + ".cdx"
				If ADIR(laDir, lcFileName) <> 0
					lnIndexSize = lnIndexSize + laDir[1,2] / 1024.
				Endif
			Else
				* die
			Endif
		Endscan

		This.TBFoxTableSize = lnTableSize
		This.TBFoxIndexSize = lnIndexSize

	Endproc

	Procedure InsArrayRow
		Lparameters aArray, lcElement1, lcElement2, lcElement3, lcElement4, lcElement5, lcElement6F
		Local lnParams, lnRow

		lnParams = PARAMETERS() - 1

		If ALEN (aArray, 1) = 1 AND EMPTY(aArray[1,1])
			lnRow = 1
		Else
			Dimension aArray[ALEN(aArray,1)+1, lnParams]
			lnRow = ALEN(aArray, 1)
		Endif

		If lnParams >= 2
			aArray[lnRow,1] = lcElement1
		Endif
		If lnParams >= 2
			aArray[lnRow,2] = lcElement2
		Endif
		If lnParams >= 3
			aArray[lnRow,3] = lcElement3
		Endif
		If lnParams >= 4
			aArray[lnRow,4] = lcElement4
		Endif
		If lnParams >= 5
			aArray[lnRow,5] = lcElement5
		Endif
		If lnParams >= 6
			aArray[lnRow,6] = lcElement6
		Endif

	Endproc

	Procedure Debug
		Activate window trace
		Activate window debug
		Suspend
	Endproc

	*set trunc.log on chkpt. option for database on server
	Procedure TruncLogOn
		Local lnOldArea, lcDBName, lnRes

		lcDBName = ALLTRIM(this.ServerDBName)
		lnOldArea = SELECT()
		If (SQLEXEC(this.MasterConnHand, "sp_helpdb ") = 1) AND !EMPTY(ALIAS())
			Locate FOR name = lcDBName
			If !EOF()
				This.TruncLog = IIF(ATC("trunc. log", status) > 0, 1, 0)
			Endif
			Use
		Endif
		lnRes = SQLEXEC(this.MasterConnHand, "sp_dboption " + lcDBName + ", 'trunc. log on chkpt.', true") = 1
		Select (lnOldArea)
	Endproc

	Procedure TruncLogOff
		Local lnRes

		* if false or unknown, set to false
		If this.TruncLog <> 1
			lnRes = SQLEXEC(this.MasterConnHand, "sp_dboption " + ALLTRIM(this.ServerDBName) + ", 'trunc. log on chkpt.', false")
		Endif
		This.TruncLog = -1

	Endproc

	Procedure UpsizeComplete
		Local lcEnumTablesTbl, lcCRLF, myarrray

		Dimension myarrray[1]

		This.cFinishMsg = ALL_DONE_LOC

		lcCRLF = CHR(10) + CHR(13)
		lcEnumTablesTbl	= this.EnumTablesTbl
		Select(lcEnumTablesTbl)
		Select COUNT(*) FROM (lcEnumTablesTbl) WHERE Exported = .F. INTO ARRAY myarray
		If (OEngine.DoScripts AND OEngine.DoUpsize) OR OEngine.DoUpsize
			If !EMPTY(myarray)
				This.cFinishMsg = ALL_DONE_LOC + lcCRLF + CANTUPSIZE_TABLE_LOC
				Scan FOR Exported = .F.
					This.cFinishMsg = THIS.cFinishMsg + RTRIM(LOWER(&lcEnumTablesTbl..TblName)) + ", "
				Endscan
				This.cFinishMsg = LEFT(THIS.cFinishMsg, LEN(RTRIM(THIS.cFinishMsg)) - 1)
			Endif
		Endif
		This.ThermRef.visible = .F.
	Endproc

	Procedure StripFunction
		Lparameter tcString

		Local lnPos, lcString, lcDelim

		lnPos = AT("(", tcString)
		lcString = tcString

		lcDelim = IIF(AT(",",tcString) > 0, ",", ")" )
		If lnPos > 0
			lcString = SUBSTR(tcString, lnPos + 1, AT(lcDelim, tcString) - 1 - lnPos)
		Endif

		Return lcString
	Endproc





Enddefine
