*:*********************************************************************
*:
*: 	   Class file: \WZINTNET\WIZINET.PRG
*:
*:         Wizard: Internet
*:         Author: Microsoft Corporation; Matthew Kowalczyk, Ken Levy
*:		  Created: 09/20/95
*:	Last modified: 01/11/96
*:
*:
*:	IWizEngine Class Methods
*:	========================	
*:		GenerateHTML		Generates the final HTML page
*:		CopyFile			Copies a file to the current directory
*:		CopyAllFiles		Copies all files used in this Class
*:		InternetFinish		Called when the finish button is Clicked in the wizard
*:
*:*********************************************************************
#INCLUDE "inetwiz.H"		&& Include basic INTERNET definitions

#DEFINE WIZFORM_CLASS		"form"
#DEFINE WIZFORM_NAME		"internetwizard"
#DEFINE	C_SAVEFORM_LOC		"Save HTML page as:"


*******************************************
DEFINE CLASS IWizEngine AS WizEngineAll
*******************************************
	
	
	**************************************
	* Method Descriptions
	*
	* GenerateHTML:		Generates Final HTML Page
	* GenerateIDC:		Generates Final IDC File	
	* GenerateHTX:		Generates Final HTX File
	*	
	*
	**************************************

	****************
	* Define Internet Specific Properties
	****************
	
	********* Search Page properties
	cSeaTitle				=TITLE1_LOC							&& Default for Title of Search Page. 
	cSeaHeaderTxt			=""									&& Default Search Header Text
	cSeaBackgroundImg		=""									&& Default Search Background Gif
	cSeaPageName			="Page1"							&& Name of Search Page
	cSeaFileName			=""									&& Default name for Search output
	cSeaEditTxt				=STRINGHERE_LOC						&& Default text for the EditBox
	cSeaButtonTxt			=SEARCHBTNCAPTION_LOC				&& Default button text
	cSeaTextSize			= 20								&& Default textbox size
	cSeaSearchColumn		= ""								&& Column to search on
	cSeaHeaderImg			= ""								&& Header Image
	cSeaOutputDirectory		= ""								&& Output directory to save output files
	cSeaReturnAsFile		= .F.								&& Return result as file
	
	******** Return Page Properties
	CRetTitle				=TITLE2_LOC							&& Default for Title of Return Page. 
	CRetHeaderTxt			=""									&& Default Return Header Text
	CRetBackgroundImg		=""									&& Default Return Background Gif
	CRetHeaderImg			= ""								&& Header Image
	nRetMaxRecords			= 10									&& Number of records to return
	cRetTemplateID			="0000001"							&& Default Template ID
	DIMENSION aReturnColumns[1] 
	aReturnColumns[1]		= ""								&& Detail Fields to return 
	DIMENSION aTableFields[1] 
	aTableFields[1]			= ""								&& Fields of table to search 
	
	******** Misc Properties
	cDBFpath				= ""								&& DBF to be searched. Must be entered by user
	cDBFFullPath			= ""								&& complete path to cDBFPath
	cHTMLText				= ""								&& HTML Code
	cIDCText 				= ""								&& IDC Code
	cHTXText 				= ""								&& HTX Code
	cDataSource				= ""								&& IDC DataSource

	Procedure InternetFinish
		LOCAL ;
			cCurrentDir,;
			cNewDir ;
								
		m.cCurrentDir = fullpath(curdir())
		
		if empty(this.cSeaOutputDirectory)
			this.cSeaOutputDirectory = m.cCurrentDir
		endif
		m.cNewDir = this.cSeaOutputDirectory
		
		cd (cNewDir)
		this.GenerateHTML
		this.GenerateHTX
		this.GenerateIDC
		this.CopyAllFiles(cNewDir)
		cd (cCurrentDir)
	EndProc
	
	Procedure CopyAllFiles(tcNewDir)
		LOCAL nDirExists,lcCopyToFileName,lcFileName
		LOCAL aDummy[1]

		nDirExists = 0
		nDirExists = adir(aDummy,"img","D")
		if 	(nDirExists = 0)
			md img
		ENDIF				
		*** copy images to img directory
		this.copyfile(UPPER(this.cSeaBackgroundImg),'IMG\')
		this.copyfile(UPPER(this.cSeaHeaderImg),'IMG\')
		this.copyfile(UPPER(this.cRetBackgroundImg),'IMG\')
		this.copyfile(UPPER(this.cRetHeaderImg),'IMG\')
		lcFileName=FULLPATH('FOXSM.GIF',oEngine.oFileInfo.cFilePath)
		lcCopyToFileName=UPPER(tcNewDir+'IMG\FOXSM.GIF')
		IF FILE(lcFileName) AND NOT FILE(lcCopyToFileName)
			COPY FILE (lcFileName) TO (lcCopyToFileName)
		ENDIF
		lcFileName=FULLPATH('VFPCGI.EXE',oEngine.oFileInfo.cFilePath)
		lcCopyToFileName=UPPER(tcNewDir+'VFPCGI.EXE')
		IF FILE(lcFileName) AND NOT FILE(lcCopyToFileName)
			COPY FILE (lcFileName) TO (lcCopyToFileName)
		ENDIF

	EndProc
	
	PROCEDURE ErrorTest
	LPARAMETERS cProgramName, nErrorNum
	
		if ("CopyAllFiles" $ cProgramName) and (nErrorNum =1961)
			Return .T.
		ENDIF
		RETURN .F.
	ENDPROC	
		
	Procedure CopyFile
	LPARAMETERS tcFileName,tcPath
	LOCAL lcPath,lcFileName
	
	lcPath=IIF(EMPTY(tcPath),'',tcPath)
	lcFileName=UPPER(ALLTRIM(this.justFname(tcFileName)))
	if !empty(lcFileName)
		if NOT FILE(lcFileName)
			copy file (tcFileName) to (lcPath+lcFileName)
		ENDIF
	ENDIF
	ENDPROC
	
	Procedure GenerateHTX
		*****************
		* Use this method to generate the HTX file
		*****************
		
		*****************
		* Local Vars
		*****************	
		LOCAL i, nSelected, cHTXTextTmpTop, cHTXTextTmpBottom, iSelect
		LOCAL array aTempFlds(1)
		LOCAL ARRAY aDBFStru[1,1]
		
		nSelected=Select()
		select tempstyl
		set order to tempid
		seek(this.cRetTemplateID)
		if !(found())			&& Should never happen
			return .F.
		ENDIF	
		
		cHTXTextTmpBottom=tempstyl.htxfile
		cHTXTextTmpBottom=strtran(cHTXTextTmpBottom,"<HTML>","")
		cHTXTextTmpTop='<HTML>'+CRLF
		
		if !Empty(this.cRetTitle)
			cHTXTextTmpTop=cHTXTextTmpTop+'<HEAD>'+ CRLF
			cHTXTextTmpTop=cHTXTextTmpTop+'<TITLE>'+allt(this.cRetTitle)+'</TITLE>'+ CRLF
			cHTXTextTmpTop=cHTXTextTmpTop+'</HEAD>'+ CRLF
		ENDIF
			
		If !Empty(this.cRetHeaderTxt)
			cHTXTextTmpTop=cHTXTextTmpTop+'<CENTER><h1>'+alltrim(this.cRetHeaderTxt)+'</h1></CENTER>'+ CRLF
		ENDIF

		if !empty(this.cRetBackgroundImg)
			cHTXTextTmpTop=cHTXTextTmpTop+'<BODY BACKGROUND="IMG/'+UPPER(alltrim(this.justfname(this.cRetBackgroundImg)))+'">'+ CRLF
		ENDIF

		if !empty(this.cRetHeaderImg)
			cHTXTextTmpTop=cHTXTextTmpTop+'<CENTER>'+ CRLF
			cHTXTextTmpTop=cHTXTextTmpTop+'<IMG SRC="IMG/'+UPPER(alltrim(this.justfname(this.cRetHeaderImg)))+'">'+ CRLF
			cHTXTextTmpTop=cHTXTextTmpTop+'</CENTER>'+ CRLF
		ENDIF

		*- get data structure of source table, so we can determine correct number of decimal places for numeric values
		iSelect = SELECT()
		IF USED("_tmpsource")
			USE IN _tmpsource
		ENDIF
		SELECT 0
		USE (THIS.cDBFFullPath) AGAIN ALIAS _tmpsource
		=AFIELDS(aDBFStru)
		USE IN _tmpSource
		SELECT (iSelect)
		set talk off
		select fieldname, fieldrepl from tempflds where tempflds.tempid=this.cRetTemplateID into array aTempFlds
		FOR i = 1 to alen(aTempFlds,1)
			lcNewText=IIF(i<=alen(this.aReturnColumns,1),this.aReturnColumns[i,1],'')
			iFldIndex = ASCAN(aDBFStru,UPPER(lcNewText))
			IF iFldIndex > 0
				iFldIndex = ASUBSCRIPT(aDBFStru, iFldIndex, 1)
				iType = aDBFStru[iFldIndex,2]
				iLen = aDBFStru[iFldIndex,3]
				iDec = aDBFStru[iFldIndex,4]
			ELSE
				iType = 'C'
				iLen = 10
				iDec = 0
			ENDIF
			*- adjust numeric values so that they display properly (e.g., all decimal places)
			DO CASE
				CASE iType $ 'NFB'
					lcNewText = "STR(" + lcNewText + "," + LTRIM(STR(iLen)) + "," + LTRIM(STR(iDec)) + ")"
				CASE iType $ 'Y'
					lcNewText = "STR(" + lcNewText + ",16," + LTRIM(STR(iDec)) + ")"
				CASE iType == 'I'
					*- this will be handled appropriately by the server
				CASE iType == 'B'
					*- double
					*- lcNewText = "ALLT(STR(SIGN(" + lcNewText + ")*IIF(" + lcNewText + "=0,0,LOG10(ABS(" + lcNewText + "))),20,16))"
				OTHERWISE
					*- the EXPRTOC() function in the server app will handle all other cases
			ENDCASE
			cHTXTextTmpBottom=strtran(cHTXTextTmpBottom,alltrim(aTempFlds(i,1)),lcNewText)
		ENDFOR
		this.cHTXText=cHTXTextTmpTop+cHTXTextTmpBottom
		this.cHTXText=STRTRAN(STRTRAN(STRTRAN(STRTRAN(this.cHTXText,'<DD><%%>'+CRLF,''), ;
				'<DD><%%>'+C_CR,''),', <%%>',''),'<%%>','')
		this.WriteVarToFile(this.cHTXText,this.forceExt(this.juststem(this.cSeaFileName),"HTX"))
		select (nSelected)

	ENDPROC
	
	Procedure GenerateIDC
		LOCAL cReturnColumnTxt,lcWhere1,lcWhere2,lcExpr,lcSubExpr,lcField
		LOCAL lnCount,lnAtPos,lnAtPos2,lnOffset,lcDBFPath
		LOCAL aTempFlds(1)
		
		m.cReturnColumnTxt=""
		
		*** Return Columns
		this.cIDCText="Datasource: "+ALLTRIM(this.cDataSource)+CRLF
		this.cIDCText=this.cIDCText+"Template: "+this.JustFName(this.forceExt(this.juststem(this.cSeaFileName),"HTX"))+CRLF
		select distinct fieldrepl from tempflds where tempflds.tempid=this.cRetTemplateID into array aTempFlds

		for i = 1 to ALEN(aTempFlds)
			
				m.CReturnColumnTxt = m.CReturnColumnTxt+ " "+ALLTRIM(aTempFlds(i))
				if !(i = ALEN(aTempFlds))
					m.cReturnColumnTxt = m.cReturnColumnTxt +","
				endif
		endfor
		this.cIDCText=this.cIDCText+"SQLStatement:"+CRLF
		this.cIDCText=this.cIDCText+"+" + "SELECT" + m.cReturnColumnTxt
		for i = 1 to ALEN(this.aReturnColumns,1)
			this.cIDCText= this.cIDCText+ " "+ALLTRIM(this.aReturnColumns[i,1])
			if !(i = ALEN(this.aReturnColumns,1))
				this.cIDCText= this.cIDCText+","
			endif
		endfor
		lcDBFPath=ALLTRIM(this.cDBFPath)
		IF LOWER(RIGHT(lcDBFPath,4))=='.dbf'
			lcDBFPath=LEFT(lcDBFPath,LEN(lcDBFPath)-4)
		ENDIF
		this.cIDCText=this.cIDCText+CRLF+"+ FROM '" + lcDBFPath+"'"+CRLF
		lcWhere1=ALLTRIM(this.cSeaSearchColumn)
		lcWhere2="'%SearchParam%'"
		lcExpr=lcWhere1
		DO WHILE .T.
			lnAtPos=AT('+',lcExpr)
			IF lnAtPos=0
				EXIT
			ENDIF
			lcSubExpr=SUBSTR(lcExpr,lnAtPos)
 			lnAtPos2=AT(')',lcSubExpr)
			IF lnAtPos2=0
				lcExpr=ALLTRIM(LEFT(lcExpr,lnAtPos-1))
			ELSE
				IF BETWEEN(AT('(',lcSubExpr),1,lnAtPos2)
					lnOffset=0
				ELSE
					lnOffset=1
				ENDIF
				lcExpr=ALLTRIM(LEFT(lcExpr,lnAtPos-1))+ ;
						ALLTRIM(SUBSTR(lcExpr,lnAtPos+lnAtPos2-lnOffset))
			ENDIF
		ENDDO
		IF '('$lcExpr
			FOR lnCount = 1 TO ALEN(this.aTableFields,1)
				lcField=this.aTableFields[lnCount,1]
				IF EMPTY(lcField)
					LOOP
				ENDIF
				IF ATC(lcField,lcExpr)>0
					lcWhere2=StrTranC(lcExpr,lcField,lcWhere2)
					EXIT
				ENDIF
			ENDFOR
		ENDIF

		this.cIDCText=this.cIDCText+"+ " + "WHERE "+lcWhere1+" = "+lcWhere2+CRLF
		this.cIDCText=this.cIDCText+"Maxrecords: "+ALLTRIM(STR(this.nRetMaxRecords))+CRLF
		this.WriteVarToFile(this.cIDCText,this.ForceExt(this.JustStem(this.cSeaFileName),"IDC"))

	ENDPROC
	
	Procedure WriteVarToFile
	PARAMETER cVarName, cFileName
	LOCAL nFileHandle
	
		nFileHandle = fcreate(cFileName)	
		=FWRITE(nFileHandle, cVarName)
		=FClose(nFileHandle)
		
	ENDPROC
		
	Procedure GenerateHTML
		*****************
		* Use this method to generate the HTML page
		*****************
		
		*****************
		* Local Vars
		*****************		
		Local ;		
			i ,j 						
		
		this.cHTMLText='<HTML>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<HEAD>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<TITLE>'+this.cSeaTitle+'</TITLE>'+ CRLF
		this.cHTMLText=this.cHTMLText+'</HEAD>'+ CRLF
		if !empty(this.cSeaBackgroundImg)
			this.cHTMLText=this.cHTMLText+'<BODY BACKGROUND="IMG/'+UPPER(alltrim(this.justfname(this.cSeaBackgroundImg)))+'">'+ CRLF
		ENDIF
		this.cHTMLText=this.cHTMLText+'<CENTER><h1>'+alltrim(this.cSeaTitle)+'</h1></CENTER>'+ CRLF
		if !empty(this.cSeaHeaderImg)
			this.cHTMLText=this.cHTMLText+'<CENTER>'+ CRLF
			this.cHTMLText=this.cHTMLText+'<IMG SRC="IMG/'+UPPER(alltrim(this.justfname(this.cSeaHeaderImg)))+'">'+ CRLF
			this.cHTMLText=this.cHTMLText+'</CENTER>'+ CRLF
		ENDIF
		this.cHTMLText=this.cHTMLText+'<P>'+ CRLF
		this.cHTMLText=this.cHTMLText+this.cSeaHeaderTxt+ CRLF
		this.cHTMLText=this.cHTMLText+'</BODY>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<P>'+ CRLF
		
		This.cHTMLText=this.cHTMLText+'<CENTER>'+CRLF
		this.cHTMLText=this.cHTMLText+'<P>'+this.cSeaEditTxt+'</P>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<FORM ACTION="'
		this.cSeaFileName=ALLTRIM(MLINE(ALLTRIM(this.cSeaFileName),1))
		IF EMPTY(this.cDataSource)
			this.cHTMLText=this.cHTMLText+'vfpcgi.exe?IDCFile='+ ;
					TrimPath(this.cSeaFileName,.T.)+'.IDC'
		ELSE
			this.cHTMLText=this.cHTMLText+TrimPath(this.cSeaFileName,.T.)+'.IDC'
		ENDIF
		this.cHTMLText=this.cHTMLText+'" METHOD="POST">'+ CRLF
	
		this.cHTMLText=this.cHTMLText+'<INPUT NAME="SearchParam" SIZE='+ ;
				ALLTRIM(STR(this.cSeaTextSize))+' VALUE="" >'+ CRLF
		this.cHTMLText=this.cHTMLText+'<INPUT TYPE="SUBMIT" VALUE="'+this.cSeaButtonTxt+'">'+ CRLF
		this.cHTMLText=This.cHTMLText+"<br>"+CRLF
		IF 	this.cSeaReturnAsFile
			this.cHTMLText=this.cHTMLText+'<br><INPUT NAME="ReturnAsFile" TYPE = checkbox>'+RETDATA_LOC+'<br>'
		ENDIF
		This.cHTMLText=this.cHTMLText+'</CENTER>'+CRLF
		this.cHTMLText=this.cHTMLText+'<hr><center>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<img src="IMG/FOXSM.GIF">'+ CRLF
		this.cHTMLText=this.cHTMLText+GENERATE_LOC+ CRLF
		this.cHTMLText=this.cHTMLText+'</center>'+ CRLF
		this.cHTMLText=this.cHTMLText+'<hr>'+ CRLF
		
		this.cHTMLText=this.cHTMLText+'</FORM>'+ CRLF
		this.cHTMLText=this.cHTMLText+'</BODY>'+ CRLF
		this.cHTMLText=this.cHTMLText+'</HTML>'+ CRLF
		this.WriteVarToFile(this.cHTMLText,this.forceExt(this.juststem(this.cSeaFileName),"HTM"))

	EndProc

ENDDEFINE



FUNCTION StrTranC(tcExpC1,tcExpC2,tcExpC3,tnExpN1,tnExpN2)
LOCAL lcExpr,lnAtPos,lnAtPos2,lnCount1,lnCount2

IF EMPTY(tcExpC1).OR.EMPTY(tcExpC2)
  RETURN tcExpC1
ENDIF
lcExpr=tcExpC1
IF TYPE('tnExpN1')#'N'
  tnExpN1=1
ENDIF
IF TYPE('tnExpN2')#'N'
  tnExpN2=LEN(tcExpC1)
ENDIF
IF tnExpN1<1.OR.tnExpN2<1
  RETURN tcExpC1
ENDIF
lnCount1=0
lnCount2=0
lnAtPos2=1
DO WHILE .T.
  lnAtPos=ATC(tcExpC2,SUBSTR(lcExpr,lnAtPos2))
  IF lnAtPos=0
    EXIT
  ENDIF
  lnCount1=lnCount1+1
  IF lnCount1<tnExpN1
    lnAtPos2=lnAtPos+lnAtPos2+LEN(tcExpC2)-1
    LOOP
  ENDIF
  lcExpr=LEFT(lcExpr,lnAtPos+lnAtPos2-2)+tcExpC3+;
         SUBSTR(lcExpr,lnAtPos+lnAtPos2+LEN(tcExpC2)-1)
  lnCount2=lnCount2+1
  IF lnCount2>=tnExpN2
    EXIT
  ENDIF
  lnAtPos2=lnAtPos+lnAtPos2+LEN(tcExpC3)-1
  IF lnAtPos2>LEN(lcExpr)
    EXIT
  ENDIF
ENDDO
RETURN lcExpr



FUNCTION TrimExt(filename)
LOCAL at_pos,at_pos2

m.at_pos=RAT('.',m.filename)
IF m.at_pos>0
	m.at_pos2=RAT(':',m.filename)
	IF m.at_pos>m.at_pos2
		m.filename=LEFT(m.filename,m.at_pos-1)
	ENDIF
ENDIF
RETURN ALLTRIM(m.filename)

* END TrimExt



FUNCTION TrimPath(filename,trim_ext)
LOCAL at_pos

IF EMPTY(m.filename)
	RETURN ''
ENDIF
m.at_pos=AT(':',m.filename)
IF m.at_pos>0
	m.filename=SUBSTR(m.filename,m.at_pos+1)
ENDIF
IF m.trim_ext
	m.filename=trimext(m.filename)
ENDIF
m.filename=ALLTRIM(SUBSTR(m.filename,AT('\',m.filename,;
	MAX(OCCURS('\',m.filename),1))+1))
DO WHILE LEFT(m.filename,1)=='.'
	m.filename=ALLTRIM(SUBSTR(m.filename,2))
ENDDO
DO WHILE RIGHT(m.filename,1)=='.'
	m.filename=ALLTRIM(LEFT(m.filename,LEN(m.filename)-1))
ENDDO
RETURN m.filename

* END TrimPath



FUNCTION TrimFile(filename)
LOCAL at_pos

m.at_pos=RAT('\',m.filename)
m.filename=ALLTRIM(IIF(m.at_pos=0,m.filename,LEFT(m.filename,m.at_pos)))
RETURN m.filename

* END TrimFile
